/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.eclipse.core.resources.IStorage;

public class UserExtensiblePointcut
extends AbstractPointcut {
    private Closure<?> closure;

    public UserExtensiblePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    public UserExtensiblePointcut(IStorage containerIdentifier, String pointcutName, Closure<?> closure) {
        super(containerIdentifier, pointcutName);
        this.setClosure(closure);
    }

    public void setClosure(Closure<?> closure) {
        closure.setResolveStrategy(1);
        this.closure = closure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<?> matches(GroovyDSLDContext context, Object toMatch) {
        if (this.closure != null) {
            try {
                Object result = null;
                Closure<?> closure = this.closure;
                synchronized (closure) {
                    this.closure.setDelegate(this.getClosureDelegate(context, toMatch));
                    try {
                        result = this.closure.call(toMatch);
                    }
                    finally {
                        this.closure.setDelegate(null);
                    }
                }
                return this.ensureCollection(result);
            }
            catch (Exception e) {
                GroovyLogManager.manager.logException(TraceCategory.DSL, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void verify() throws PointcutVerificationException {
    }

    private Object getClosureDelegate(GroovyDSLDContext context, Object toMatch) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currentType", context.getCurrentType());
        for (Map.Entry<String, Object> entry : this.namedArgumentsAsMap().entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof IPointcut) {
                Collection<?> matches = this.matchOnPointcutArgument((IPointcut)val, context, this.ensureCollection(toMatch));
                if (matches != null && !matches.isEmpty()) {
                    map.put(key, context.getCurrentBinding().getBinding(key));
                    continue;
                }
                map.put(key, null);
                continue;
            }
            map.put(key, val);
        }
        return map;
    }
}

