/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application;

import com.kms.katalon.application.KatalonApplication;
import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.MacOSAddon;
import com.kms.katalon.application.MetadataCorruptedResolver;
import com.kms.katalon.application.preference.EclipseSettingPreference;
import com.kms.katalon.application.preference.ProxyPreferences;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.logging.LogUtil;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class Application
implements IApplication {
    private static final String KATALON_MIDDLE_APP_LOCATION = "\\configuration\\resources\\middle\\KatalonApp.exe";
    private static final String INVALID_RUNNING_MODE = "Invalid running mode.";
    public static final String RUN_MODE_OPTION = "runMode";
    public static final String RUN_MODE_OPTION_CONSOLE = "console";
    private static final Object RUN_MODE_OPTION_SELFTEST = "selfTest";

    public Object start(IApplicationContext context) {
        this.createLicenseFolder();
        if (!this.activeLoggingBundle()) {
            return IApplication.EXIT_OK;
        }
        if (!this.activateInternalPlatformBundle()) {
            return IApplication.EXIT_OK;
        }
        try {
            this.preRunInit();
        }
        catch (Error error) {
            this.resolve();
        }
        Map args = context.getArguments();
        String[] appArgs = (String[])args.get("application.args");
        RunningModeParam runningModeParam = this.getRunningModeParamFromParam(this.parseOption(appArgs));
        try {
            EclipseSettingPreference.disableEclipseFeatureByDefault();
        }
        catch (NoClassDefFoundError error) {
            LogUtil.logError((Throwable)error);
            this.deleteResourceFolder();
        }
        if (this.isKSRE()) {
            runningModeParam = RunningModeParam.CONSOLE;
        }
        if (Platform.OS.isWindows() && !this.isKSRE()) {
            Thread exeThread = new Thread(() -> this.triggerKatalonMiddleApp());
            exeThread.start();
        }
        switch (runningModeParam) {
            case CONSOLE: {
                try {
                    Bundle consoleBundle = Platform.getBundle((String)"com.kms.katalon.console");
                    if (consoleBundle == null) {
                        System.out.println(INVALID_RUNNING_MODE);
                        return IApplication.EXIT_OK;
                    }
                    consoleBundle.start();
                }
                catch (BundleException bundleException) {
                    return IApplication.EXIT_OK;
                }
                return this.runConsole(context, appArgs);
            }
            case SELFTEST: {
                return this.runSelfTest();
            }
            case GUI: {
                try {
                    Bundle composerKatalonBundle = Platform.getBundle((String)"com.kms.katalon");
                    if (composerKatalonBundle == null) {
                        System.out.println(INVALID_RUNNING_MODE);
                        return IApplication.EXIT_OK;
                    }
                    composerKatalonBundle.start();
                }
                catch (BundleException e) {
                    LogUtil.logError((Throwable)e);
                }
                return this.runGUI(appArgs);
            }
        }
        System.out.println(INVALID_RUNNING_MODE);
        return IApplication.EXIT_OK;
    }

    private void resolve() {
        MetadataCorruptedResolver resolver = new MetadataCorruptedResolver();
        resolver.resolve();
    }

    private boolean isKSRE() {
        return Platform.getProduct().getId().equals("com.kms.katalon.console.product");
    }

    private Object runConsole(IApplicationContext context, String[] appArgs) {
        try {
            context.applicationRunning();
            ApplicationRunningMode.set((RunningMode)RunningMode.CONSOLE);
            ApplicationEdition.set((KatalonEdition)KatalonEdition.ENTERPRISE);
            System.setProperty("application.version", VersionUtil.getCurrentVersion().getVersion());
            return KatalonApplicationActivator.getInstance().getApplicationStarters().get(RunningMode.CONSOLE).start(appArgs);
        }
        catch (Error e) {
            LogUtil.logError((Throwable)e);
            return IApplication.EXIT_OK;
        }
    }

    private void preRunInit() {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc.getURL() == null) {
            try {
                File newLocationFile = this.getWorkspaceFile();
                if (!newLocationFile.exists()) {
                    newLocationFile.mkdirs();
                }
                instanceLoc.set(new URL(newLocationFile.toURI().toURL().toString().replaceAll("%20", " ")), false);
                LogUtil.printOutputLine((String)("Katalon workspace folder is set to default location: " + newLocationFile.getAbsolutePath()));
            }
            catch (IOException | IllegalStateException | URISyntaxException ex) {
                LogUtil.logError((Throwable)ex);
                return;
            }
        } else {
            LogUtil.printOutputLine((String)("Katalon workspace folder is set custom to: " + instanceLoc.getURL().toString()));
        }
        MacOSAddon.initMacOSConfig();
        ApplicationInfo.setAppInfoIntoUserHomeDir();
    }

    private File getWorkspaceFile() throws URISyntaxException {
        Object configRelativePath;
        if (this.isKSRE()) {
            File tempParentFolder = FileUtils.getTempDirectory();
            File workSpaceFile = new File(tempParentFolder, "/session-" + KatalonApplication.SESSION_ID.substring(0, 8));
            workSpaceFile.mkdirs();
            return workSpaceFile;
        }
        File installLocation = new File(Platform.getInstallLocation().getURL().getPath());
        Object object = configRelativePath = "macosx".equals(Platform.getOS()) ? "../MacOS/config" : "config";
        if (Platform.inDevelopmentMode()) {
            configRelativePath = (String)configRelativePath + "-dev";
        }
        return new File(installLocation.getAbsolutePath(), (String)configRelativePath);
    }

    private OptionSet parseOption(String[] appArgs) {
        OptionParser parser = new OptionParser(false);
        parser.allowsUnrecognizedOptions();
        parser.accepts(RUN_MODE_OPTION).withRequiredArg().ofType(String.class);
        OptionSet options = parser.parse(appArgs);
        return options;
    }

    private int runSelfTest() {
        return 0;
    }

    private int runGUI(String[] arguments) {
        ApplicationRunningMode.set((RunningMode)RunningMode.GUI);
        ApplicationEdition.set((KatalonEdition)ApplicationInfo.getKatalonEdition());
        System.setProperty("application.version", VersionUtil.getCurrentVersion().getVersion());
        System.setProperty("system.proxy", JsonUtil.toJson((Object)ProxyPreferences.getSystemProxyInformation()));
        return KatalonApplicationActivator.getInstance().getApplicationStarters().get(RunningMode.GUI).start(arguments);
    }

    private RunningModeParam getRunningModeParamFromParam(OptionSet options) {
        if (!options.has(RUN_MODE_OPTION)) {
            return RunningModeParam.GUI;
        }
        if (RUN_MODE_OPTION_CONSOLE.equals(options.valueOf(RUN_MODE_OPTION))) {
            return RunningModeParam.CONSOLE;
        }
        if (RUN_MODE_OPTION_SELFTEST.equals(options.valueOf(RUN_MODE_OPTION))) {
            return RunningModeParam.SELFTEST;
        }
        return RunningModeParam.INVALID;
    }

    public void stop() {
        KatalonApplicationActivator.getInstance().getApplicationStarters().get(ApplicationRunningMode.get()).stop();
        try {
            ResourcesPlugin.getWorkspace().save(false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private boolean activeLoggingBundle() {
        try {
            Platform.getBundle((String)"com.kms.katalon.logging").start();
            return true;
        }
        catch (BundleException bundleException) {
            return false;
        }
    }

    private boolean activateInternalPlatformBundle() {
        try {
            Platform.getBundle((String)"com.kms.katalon.platform.internal").start();
            return true;
        }
        catch (BundleException bundleException) {
            return false;
        }
    }

    private void createLicenseFolder() {
        try {
            File licenseFolder = new File(ApplicationInfo.userDirLocation(), "license");
            if (!licenseFolder.exists()) {
                licenseFolder.mkdir();
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private void deleteResourceFolder() {
        try {
            FileUtils.deleteDirectory((File)Platform.getLocation().toFile());
        }
        catch (IOException | IllegalStateException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private void triggerKatalonMiddleApp() {
        try {
            File installLoc = new File(FileLocator.resolve((URL)Platform.getInstallLocation().getURL()).getFile());
            String exePackageRootPath = installLoc.getPath();
            LogUtil.logInfo((String)("triggerKatalonMiddleApp => exePackageRootPath: " + exePackageRootPath));
            String keyPath = "katalonstudio";
            String valueName = "ExePackageRootPath";
            String exePackageRootPathFromRegistry = this.readRegistry(keyPath, valueName);
            LogUtil.logInfo((String)("triggerKatalonMiddleApp => exePackageRootPathFromRegistry: " + exePackageRootPathFromRegistry));
            if (StringUtils.equals((CharSequence)exePackageRootPath, (CharSequence)exePackageRootPathFromRegistry)) {
                return;
            }
            String exePath = exePackageRootPath + KATALON_MIDDLE_APP_LOCATION;
            LogUtil.logInfo((String)("triggerKatalonMiddleApp => KatalonMiddleApp path: " + exePath));
            String[] exeArgs = new String[]{"UPDATE", exePackageRootPath};
            StringBuilder argList = new StringBuilder();
            String[] stringArray = exeArgs;
            int n = exeArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                argList.append("'").append(arg.replace("'", "''")).append("',");
                ++n2;
            }
            if (argList.length() > 0) {
                argList.setLength(argList.length() - 1);
            }
            String psCommand = String.format("Start-Process -FilePath '%s' -ArgumentList %s -Verb RunAs", exePath, argList);
            ProcessBuilder processBuilder = new ProcessBuilder("powershell", "-Command", psCommand);
            processBuilder.start();
        }
        catch (Exception ex) {
            LogUtil.logError((String)("triggerKatalonMiddleApp => Error while trying to run the .exe file as Admin: " + String.valueOf(ex)));
        }
    }

    private String readRegistry(String keyPath, String valueName) {
        if (Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_CLASSES_ROOT, (String)keyPath)) {
            String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CLASSES_ROOT, (String)keyPath, (String)valueName);
            return value != null ? new String(value).trim() : null;
        }
        return null;
    }

    public static enum RunningModeParam {
        GUI,
        CONSOLE,
        INVALID,
        SELFTEST;

    }
}

