/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.machine.service;

import com.kms.katalon.application.hardware.Hardware4Win;
import com.kms.katalon.application.machine.service.MachineIdService;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class WindowsMachineIdService
implements MachineIdService {
    private static final String WINDOWS_GET_MACHINE_ID_DELIMITER = "REG_SZ";
    public static final String[] WINDOWS_GET_MACHINE_ID_COMMAND = new String[]{"reg", "query", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Cryptography", "/v", "MachineGuid"};

    @Override
    public String getMachineId() {
        String machineId;
        try {
            LogUtil.logInfo((String)String.format("Start getting machine ID on Windows", new Object[0]));
            machineId = WindowsMachineIdService.getMachineIdFromCmd();
            if (StringUtils.equals((CharSequence)"N/A", (CharSequence)machineId)) {
                machineId = Hardware4Win.getSerialNumber();
                LogUtil.logInfo((String)"Unable to get machine ID by CMD, used hardware serial number instead.");
            }
            machineId = StringUtils.isNotBlank((CharSequence)machineId) ? this.appendAdditionalSignatures(machineId) : "N/A";
        }
        catch (IOException | InterruptedException e) {
            LogUtil.logError((Throwable)e);
            machineId = "N/A";
        }
        String result = MachineIdService.hash(machineId);
        LogUtil.logInfo((String)String.format("End getting machine ID on Windows %s", result));
        return result;
    }

    @Override
    public String getOsDependentUsername() {
        String username = "";
        try {
            Class<?> clazz = Class.forName("com.sun.security.auth.module.NTSystem");
            Object o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = clazz.getDeclaredMethod("getName", new Class[0]);
            username = (String)method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            LogUtil.logInfo((String)"OS username is empty");
            username = System.getProperty("user.name", "");
        }
        return username;
    }

    private static String getMachineIdFromCmd() throws IOException, InterruptedException {
        List commandLineResults = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])WINDOWS_GET_MACHINE_ID_COMMAND);
        String commandLineResult = commandLineResults.stream().filter(item -> item.contains(WINDOWS_GET_MACHINE_ID_DELIMITER)).findFirst().orElse("N/A");
        return Arrays.asList(commandLineResult.split(WINDOWS_GET_MACHINE_ID_DELIMITER)).stream().map(String::trim).map(String::toLowerCase).filter(result -> result.matches("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}")).findAny().orElse("N/A");
    }
}

