/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.kms.katalon.application.KatalonApplication;
import com.kms.katalon.application.constants.ApplicationStringConstants;
import com.kms.katalon.application.utils.BrowserLaunchMode;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.application.utils.Organization;
import com.kms.katalon.application.utils.TestOpsServerURL;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.logging.logback.LogMarkers;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.model.KatalonPackage;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.license.models.CombinedAuthenticationToken;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInfo {
    private static final Logger logger = LoggerFactory.getLogger((String)ApplicationInfo.class.getName());
    public static final String DEV_PROFILE = "dev";
    public static final String STAG_PROFILE = "stag";
    public static final String PROD_PROFILE = "prod";
    private static final String ABOUT_MAPPINGS_FILE_NAME = "about.mappings";
    private static final String ABOUT_BUILD_NUMBER_KEY = "0";
    private static final String ABOUT_VERSION_NUMBER_KEY = "1";
    private static final String ABOUT_VERSION_TAG = "3";
    private static final String ABOUT_OFFICIAL_RELEASE_VERSION = "5";
    private static final String PROFILE_PROPERTY_KEY = "katalonProfile";
    private static Properties aboutMappingsProperties;
    private static Properties appProperties;
    private static final String FREE_EDITION_BUNDLE_ID = "com.kms.katalon.product-free";

    private static Properties getAboutMappingsProperties() {
        if (aboutMappingsProperties != null && !aboutMappingsProperties.isEmpty()) {
            return aboutMappingsProperties;
        }
        aboutMappingsProperties = new Properties();
        try {
            aboutMappingsProperties.load(Platform.getBundle((String)"com.kms.katalon.application").getResource(ABOUT_MAPPINGS_FILE_NAME).openStream());
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return aboutMappingsProperties;
    }

    public static String versionNo() {
        return ApplicationInfo.getAboutMappingsProperties().getProperty(ABOUT_VERSION_NUMBER_KEY, GlobalStringConstants.EMPTY);
    }

    public static String officialReleaseVersion() {
        return ApplicationInfo.getAboutMappingsProperties().getProperty(ABOUT_OFFICIAL_RELEASE_VERSION, ApplicationInfo.versionNo());
    }

    public static String buildNo() {
        return ApplicationInfo.getAboutMappingsProperties().getProperty(ABOUT_BUILD_NUMBER_KEY, GlobalStringConstants.EMPTY);
    }

    public static String profile() {
        return System.getProperty(PROFILE_PROPERTY_KEY);
    }

    public static String versionTag() {
        return ApplicationInfo.getAboutMappingsProperties().getProperty(ABOUT_VERSION_TAG, GlobalStringConstants.EMPTY);
    }

    public static String installLocation() {
        try {
            return Paths.get(new URI(Platform.getInstallLocation().getURL().toString().replace(" ", "%20"))).toString();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        return ApplicationStringConstants.EMPTY;
    }

    public static String userDirLocation() {
        return ApplicationStringConstants.APP_USER_DIR_LOCATION;
    }

    public static void setAppInfoIntoUserHomeDir() {
        String version = ApplicationInfo.versionNo();
        String buildNo = ApplicationInfo.buildNo();
        ApplicationInfo.getAppProperties();
        System.setProperty("katalon.versionNumber", version);
        ApplicationInfo.logInfo("katalon.versionNumber=" + version);
        ApplicationInfo.logInfo("katalon.buildNumber=" + buildNo);
        if (version.equals(ApplicationInfo.getAppProperty("katalon.versionNumber")) && buildNo.equals(ApplicationInfo.getAppProperty("katalon.buildNumber"))) {
            return;
        }
        ApplicationInfo.setAppProperty("katalon.versionNumber", version, false);
        ApplicationInfo.setAppProperty("katalon.buildNumber", buildNo, false);
        ApplicationInfo.saveAppProperties();
    }

    private static Properties getAppProperties() {
        if (appProperties != null) {
            return appProperties;
        }
        File appPropFile = new File(ApplicationStringConstants.APP_INFO_FILE_LOCATION);
        File katalonDir = new File(ApplicationInfo.userDirLocation());
        if (!appPropFile.exists()) {
            if (!katalonDir.exists()) {
                katalonDir.mkdir();
            }
            try {
                appPropFile.createNewFile();
            }
            catch (Exception ex) {
                LogUtil.logError((Throwable)ex);
            }
        }
        try {
            Throwable ex = null;
            Object var3_6 = null;
            try (FileInputStream in = new FileInputStream(appPropFile);){
                appProperties = new Properties();
                appProperties.load(in);
            }
            catch (Throwable throwable) {
                if (ex == null) {
                    ex = throwable;
                } else if (ex != throwable) {
                    ex.addSuppressed(throwable);
                }
                throw ex;
            }
        }
        catch (Exception ex) {
            appProperties = null;
            LogUtil.logError((Throwable)ex);
        }
        return appProperties;
    }

    public static void setAppProperty(String key, String value, boolean autoSave) {
        Properties appProps = ApplicationInfo.getAppProperties();
        appProps.setProperty(key, value);
        if (autoSave) {
            ApplicationInfo.saveAppProperties();
        }
    }

    public static String getAppProperty(String key) {
        Properties appProps = ApplicationInfo.getAppProperties();
        if (appProps != null && appProps.containsKey(key)) {
            return appProps.getProperty(key);
        }
        return null;
    }

    private static void saveAppProperties() {
        if (appProperties == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (FileOutputStream out = new FileOutputStream(ApplicationStringConstants.APP_INFO_FILE_LOCATION);){
                appProperties.store(out, ApplicationInfo.installLocation());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
        }
    }

    private static void logInfo(String message) {
        logger.info(LogMarkers.NOT_USER_FRIENDLY, message);
    }

    public static void removeAppProperty(String key) {
        Properties appProps = ApplicationInfo.getAppProperties();
        if (appProps != null && appProps.containsKey(key)) {
            appProps.remove(key);
            ApplicationInfo.saveAppProperties();
        }
    }

    public static Long getOrgId() {
        Organization org = ApplicationInfo.getOrganization();
        return org != null ? org.getId() : null;
    }

    public static Organization getOrganization() {
        String jsonObject = ApplicationInfo.getAppProperty("organization");
        if (StringUtils.isNotBlank((CharSequence)jsonObject)) {
            try {
                return (Organization)JsonUtil.fromJson((String)jsonObject, Organization.class);
            }
            catch (IllegalArgumentException e) {
                LogUtil.logError((Throwable)e);
            }
        }
        return null;
    }

    public static void setOrg(Organization org) {
        ApplicationInfo.setAppProperty("organization", JsonUtil.toJson((Object)org), true);
    }

    public static void setOrg(com.kms.katalon.session.core.model.Organization org) {
        ApplicationInfo.setAppProperty("organization", JsonUtil.toJson((Object)org), true);
    }

    public static void clearOrg() {
        ApplicationInfo.removeAppProperty("organization");
    }

    public static void setTestOpsServer(String serverUrl) {
        RunningMode runMode = ApplicationRunningMode.get();
        if (runMode == RunningMode.GUI) {
            ApplicationInfo.setAppProperty("testOps.serverUrl", serverUrl, true);
        }
        TestOpsServerURL.set(serverUrl);
    }

    public static void setAdminServer(String serverUrl) {
        RunningMode runMode = ApplicationRunningMode.get();
        if (runMode == RunningMode.GUI) {
            ApplicationInfo.setAppProperty("testOps.adminServerUrl", serverUrl, true);
        }
        TestOpsServerURL.setAdminServerURL(serverUrl);
    }

    public static String getDefaultTestOpsAdminServer() {
        String server = (String)Strings.firstNonBlank((CharSequence[])new String[]{System.getProperty("testOps.adminServerUrl"), "https://admin.katalon.com"});
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        return server;
    }

    public static String getTestOpsServer() {
        String finalServer = Strings.firstNonBlank((Strings.StringProvider[])new Strings.StringProvider[]{() -> TestOpsServerURL.get(), () -> System.getProperty("testOps.serverUrl"), () -> {
            String server = "";
            RunningMode runMode = ApplicationRunningMode.get();
            if (runMode == RunningMode.GUI) {
                server = ApplicationInfo.getAppProperty("testOps.serverUrl");
            }
            return server;
        }, () -> "https://testops.katalon.io"});
        TestOpsServerURL.set(finalServer);
        return finalServer;
    }

    public static String getDefaultTestOpsServer() {
        String finalServer = (String)Strings.firstNonBlank((CharSequence[])new String[]{System.getProperty("testOps.serverUrl"), "https://testops.katalon.io"});
        TestOpsServerURL.set(finalServer);
        return finalServer;
    }

    public static String getAdminServer() {
        String finalServer = Strings.firstNonBlank((Strings.StringProvider[])new Strings.StringProvider[]{() -> TestOpsServerURL.getAdminServerURL(), () -> System.getProperty("testOps.adminServerUrl"), () -> {
            String server = "";
            RunningMode runMode = ApplicationRunningMode.get();
            if (runMode == RunningMode.GUI) {
                server = ApplicationInfo.getAppProperty("testOps.adminServerUrl");
            }
            return server;
        }, () -> "https://admin.katalon.com"});
        TestOpsServerURL.setAdminServerURL(finalServer);
        return finalServer;
    }

    public static String getMyServerUrl() {
        return "https://my.katalon.com";
    }

    public static CombinedAuthenticationToken getAuthenticationInfo() {
        String rawToken;
        block3: {
            try {
                rawToken = ApplicationInfo.getAppProperty("authenticationInfo");
                if (!StringUtils.isBlank((CharSequence)rawToken)) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return (CombinedAuthenticationToken)JsonUtil.fromJson((String)rawToken, CombinedAuthenticationToken.class);
    }

    public static void setAuthenticationInfo(CombinedAuthenticationToken token) {
        ApplicationInfo.setAppProperty("authenticationInfo", JsonUtil.toJson((Object)token, (boolean)false), true);
    }

    public static void clearAuthenticationInfo() {
        ApplicationInfo.removeAppProperty("authenticationInfo");
    }

    public static void setActivationCode(String activationCode) {
        ApplicationInfo.setAppProperty("newActivationCode", activationCode, true);
    }

    public static LoginMethod getLoginMethod() {
        String method = (String)StringUtils.defaultIfEmpty((CharSequence)ApplicationInfo.getAppProperty("loginMethod"), (CharSequence)LoginMethod.SSO.name());
        return LoginMethod.valueOf(method);
    }

    public static void setLoginMethod(LoginMethod loginMethod) {
        ApplicationInfo.setAppProperty("loginMethod", loginMethod.name(), true);
    }

    public static void clearActivationCode() {
        ApplicationInfo.removeAppProperty("newActivationCode");
    }

    public static void clearLoginMethod() {
        ApplicationInfo.removeAppProperty("loginMethod");
    }

    public static void cleanAll() {
        String tempAdminServer = ApplicationInfo.getAdminServer();
        Properties appProps = ApplicationInfo.getAppProperties();
        appProps.clear();
        ApplicationInfo.saveAppProperties();
        ApplicationInfo.setAdminServer(tempAdminServer);
    }

    public static boolean isRunningUnitTest() {
        return System.getProperty("runUnitTests") != null;
    }

    public static boolean isPlatformStudio() {
        return KatalonApplication.getKatalonPackage() == KatalonPackage.KSE && Platform.getProduct().getId().equals("com.kms.katalon.product-platform-edition");
    }

    public static KatalonEdition getKatalonEdition() {
        if (ApplicationRunningMode.get() == RunningMode.CONSOLE) {
            return KatalonEdition.ENTERPRISE;
        }
        return Platform.getProduct().getId().equals(FREE_EDITION_BUNDLE_ID) ? KatalonEdition.FREE : KatalonEdition.ENTERPRISE;
    }

    public static void setAuthenticationType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        ApplicationInfo.setAppProperty("authenticationType", type, true);
    }

    public static String getAuthenticationType() {
        return ApplicationInfo.getAppProperty("authenticationType");
    }

    public static void clearAuthenticationType() {
        ApplicationInfo.removeAppProperty("authenticationType");
    }

    public static void setAuthenticationSubDomain(String subDomain) {
        if (StringUtils.isBlank((CharSequence)subDomain)) {
            return;
        }
        ApplicationInfo.setAppProperty("authenticationSubDomain", subDomain, true);
    }

    public static String getAuthenticationSubDomain() {
        return ApplicationInfo.getAppProperty("authenticationSubDomain");
    }

    public static void clearAuthenticationSubDomain() {
        ApplicationInfo.removeAppProperty("authenticationSubDomain");
    }

    public static void setBrowserLaunchMode(String option) {
        if (StringUtils.isBlank((CharSequence)option)) {
            return;
        }
        ApplicationInfo.setAppProperty("browserLaunchMode", option, true);
    }

    public static BrowserLaunchMode getBrowserLaunchMode() {
        String mode = ApplicationInfo.getAppProperty("browserLaunchMode");
        if (StringUtils.isNotBlank((CharSequence)mode) && !EnumUtils.isValidEnum(BrowserLaunchMode.class, (String)mode)) {
            LogUtil.logError((String)("Invalid browser launch mode: " + mode));
            return BrowserLaunchMode.IN_APP;
        }
        return (BrowserLaunchMode)EnumUtils.getEnumIgnoreCase(BrowserLaunchMode.class, (String)mode, (Enum)BrowserLaunchMode.IN_APP);
    }
}

