/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.license.models;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.license.models.AuthenticationInfo;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;

public class AuthenticationToken
extends AuthenticationInfo {
    private String accessToken;
    private String refreshToken;
    private String server;
    private Long creationTime;
    private Long accessTokenExpirationTime;
    private Long refreshTokenExpirationTime;

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long creationTime) {
        this.creationTime = creationTime;
    }

    public Long getAccessTokenExpirationTime() {
        return this.accessTokenExpirationTime;
    }

    public void setAccessTokenExpirationTime(Long accessTokenExpirationTime) {
        this.accessTokenExpirationTime = accessTokenExpirationTime;
    }

    public Long getRefreshTokenExpirationTime() {
        return this.refreshTokenExpirationTime;
    }

    public void setRefreshTokenExpirationTime(Long refreshTokenExpirationTime) {
        this.refreshTokenExpirationTime = refreshTokenExpirationTime;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public AuthenticationToken() {
    }

    public AuthenticationToken(String accessToken, String refreshToken, String server) {
        this.updateTokens(accessToken, refreshToken, server);
    }

    public boolean isSameServer(String server) {
        return StringUtils.equals((CharSequence)this.server, (CharSequence)server);
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.accessToken);
    }

    public boolean isNotEmpty() {
        return StringUtils.isNotBlank((CharSequence)this.accessToken);
    }

    public boolean isAvailable(String server) {
        return this.isNotEmpty() && this.isSameServer(server);
    }

    public void clear() {
        this.accessToken = null;
        this.refreshToken = null;
        this.accessTokenExpirationTime = null;
        this.refreshTokenExpirationTime = null;
        this.creationTime = null;
    }

    public void updateTokens(String accessToken, String refreshToken, String server) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.server = server;
    }

    public <T> T parseAccessToken(Class<T> type) {
        return this.parseToken(this.accessToken, type);
    }

    public <T> T parseRefreshToken(Class<T> type) {
        return this.parseToken(this.refreshToken, type);
    }

    public <T> T parseToken(String token, Class<T> type) {
        String[] chunk = token.split("\\.");
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String payload = new String(decoder.decode(chunk[1]));
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(payload, type);
    }

    public AuthenticationToken clone() {
        return (AuthenticationToken)ObjectUtil.clone((Object)this);
    }

    public void assign(AuthenticationToken token) {
        this.assignTokens(token);
        this.server = token.server;
    }

    public void assignTokens(AuthenticationToken token) {
        this.accessToken = token.accessToken;
        this.refreshToken = token.refreshToken;
        this.creationTime = token.creationTime;
        this.accessTokenExpirationTime = token.accessTokenExpirationTime;
        this.accessTokenExpirationTime = token.accessTokenExpirationTime;
    }

    public record JwtTokenInfo(Long exp) {
    }
}

