/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.dialog;

import com.katalon.capability.constant.DriverType;
import com.kms.katalon.composer.mobile.component.DeviceSelectionComposite;
import com.kms.katalon.composer.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DeviceSelectionDialog
extends TitleAreaDialog {
    private DriverType platform;
    private DeviceSelectionComposite deviceSelectionComposite;
    private MobileDeviceInfo device;

    public DeviceSelectionDialog(Shell parentShell, MobileDriverType platform) {
        super(parentShell);
        this.platform = switch (platform) {
            case MobileDriverType.IOS_DRIVER -> DriverType.IOS_DRIVER;
            case MobileDriverType.ANDROID_DRIVER -> DriverType.ANDROID_DRIVER;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.deviceSelectionComposite = new DeviceSelectionComposite(area, 0, this.platform);
        this.deviceSelectionComposite.setSelectionIndex(0);
        this.deviceSelectionComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceSelectionDialog.this.updateStatus();
            }
        });
        return area;
    }

    private void updateStatus() {
        super.getButton(0).setEnabled(this.deviceSelectionComposite.getSelectedDevice() != null);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateStatus();
    }

    public void create() {
        super.create();
        this.setTitle(String.valueOf(this.platform) + " Devices");
        this.setMessage(StringConstants.DIA_SELECT_DEVICE_NAME_MSG, 1);
    }

    protected Point getInitialSize() {
        return new Point(400, 200);
    }

    protected void okPressed() {
        this.device = this.deviceSelectionComposite.getSelectedDevice();
        super.okPressed();
    }

    public MobileDeviceInfo getDevice() {
        return this.device;
    }
}

