/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.dialog;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.control.GifCLabel;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.mobile.component.ProvisioningProfile;
import com.kms.katalon.composer.mobile.constants.ComposerMobileMessageConstants;
import com.kms.katalon.composer.mobile.constants.ImageConstants;
import com.kms.katalon.composer.mobile.dialog.provider.IosIdentityColumnLabelProvider;
import com.kms.katalon.composer.mobile.util.MobileUtil;
import com.kms.katalon.execution.mobile.constants.StringConstants;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import com.kms.katalon.execution.mobile.identity.IosIdentityInfo;
import com.kms.katalon.execution.mobile.util.SystemCertificationUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class IosProvisioningProfileAndIdentitySelectionDialog
extends AbstractDialog {
    private List<IosIdentityInfo> identities;
    private IosIdentityInfo selectedIdentity;
    private TableViewer identityTableViewer;
    private Thread thread;
    private boolean interrupted = false;
    private Composite identitySelectionMainComposite;
    private StackLayout stackLayout;
    private Composite noIdentityComposite;
    private Composite tableComposite;
    private Composite loadingIdentitiesComposite;
    private Composite notificationComposite;
    private GifCLabel connectingLabel;
    private InputStream loadingImgInputStream;
    private Label provisioningProfileLabel;
    private Composite provisioningProfileComposite;
    private Label provisioningProfileComboBoxLabel;
    private Combo provisioningProfileCombo;
    private Label developmentIdentityLabel;
    private String mobileDeviceId;
    private String provisionigProfileName;
    private List<ProvisioningProfile> eligibleProvisioningProfileList;
    private static final String PROVISIONING_PROFILE_LOCATION = "/Library/MobileDevice/Provisioning Profiles";
    private static final String NEW_PROVISIONING_PROFILE_LOCATION = "/Library/Developer/Xcode/UserData/Provisioning Profiles";

    public IosProvisioningProfileAndIdentitySelectionDialog(Shell parentShell) {
        super(parentShell);
        this.mobileDeviceId = "";
    }

    public IosProvisioningProfileAndIdentitySelectionDialog(Shell parentShell, String mobileDeviceId) {
        super(parentShell);
        this.mobileDeviceId = mobileDeviceId;
    }

    protected void registerControlModifyListeners() {
        this.identityTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IosProvisioningProfileAndIdentitySelectionDialog.this.selectedIdentity = (IosIdentityInfo)IosProvisioningProfileAndIdentitySelectionDialog.this.identityTableViewer.getStructuredSelection().getFirstElement();
                IosProvisioningProfileAndIdentitySelectionDialog.this.getButton(0).setEnabled(IosProvisioningProfileAndIdentitySelectionDialog.this.selectedIdentity != null);
            }
        });
        this.identityTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IosProvisioningProfileAndIdentitySelectionDialog.this.okPressed();
            }
        });
        this.connectingLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    IosProvisioningProfileAndIdentitySelectionDialog.this.loadingImgInputStream.close();
                }
                catch (IOException iOException) {}
            }
        });
        this.provisioningProfileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = IosProvisioningProfileAndIdentitySelectionDialog.this.provisioningProfileCombo.getSelectionIndex();
                IosProvisioningProfileAndIdentitySelectionDialog.this.interrupted = false;
                IosProvisioningProfileAndIdentitySelectionDialog.this.thread = IosProvisioningProfileAndIdentitySelectionDialog.this.createThreadToLoadCertificates(index);
                IosProvisioningProfileAndIdentitySelectionDialog.this.thread.start();
            }
        });
    }

    private boolean identitiesChanged(List<IosIdentityInfo> newIdentities, List<IosIdentityInfo> oldIdentities) {
        if (newIdentities == null || oldIdentities == null) {
            return true;
        }
        if (newIdentities.size() != oldIdentities.size()) {
            return true;
        }
        return newIdentities.parallelStream().filter(d -> !oldIdentities.contains(d)).findAny().isPresent();
    }

    protected void setInput() {
        this.getButton(0).setEnabled(false);
        this.stackLayout.topControl = this.loadingIdentitiesComposite;
        this.identitySelectionMainComposite.layout();
        try {
            String userHome = System.getProperty("user.home");
            ArrayList<String> provisioningProfileContents = new ArrayList<String>();
            provisioningProfileContents.addAll(MobileUtil.readProvisioningProfileContents(new File(userHome, PROVISIONING_PROFILE_LOCATION)));
            provisioningProfileContents.addAll(MobileUtil.readProvisioningProfileContents(new File(userHome, NEW_PROVISIONING_PROFILE_LOCATION)));
            this.eligibleProvisioningProfileList = MobileUtil.getEligibleProvisioningProfiles(provisioningProfileContents, this.mobileDeviceId);
            this.setProvisioningProfileName(MobileUtil.getEligibleProvisioningProfileNames(provisioningProfileContents, this.mobileDeviceId));
            this.thread = this.createThreadToLoadCertificates(0);
            this.thread.start();
        }
        catch (IOException | InterruptedException | CertificateException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private Thread createThreadToLoadCertificates(int provisioningProfileIndex) {
        return new Thread(() -> {
            try {
                while (!this.interrupted) {
                    ProvisioningProfile provisioningProfile;
                    if (this.eligibleProvisioningProfileList.isEmpty()) {
                        provisioningProfile = null;
                    } else {
                        provisioningProfile = this.eligibleProvisioningProfileList.get(provisioningProfileIndex);
                        this.provisionigProfileName = provisioningProfile.getName();
                    }
                    List<IosIdentityInfo> newIdentities = this.getIndentityListFromEligibleProvisioningProfile(provisioningProfile);
                    boolean identitiesChanged = this.identitiesChanged(newIdentities, this.identities);
                    if (this.interrupted) {
                        return;
                    }
                    if (identitiesChanged) {
                        this.identities = newIdentities;
                        UISynchronizeService.syncExec(() -> {
                            if (this.identitySelectionMainComposite.isDisposed()) {
                                return;
                            }
                            this.notificationComposite.getParent().setRedraw(false);
                            this.identityTableViewer.setInput(this.identities);
                            if (this.identities.isEmpty()) {
                                this.stackLayout.topControl = this.noIdentityComposite;
                            } else {
                                this.stackLayout.topControl = this.tableComposite;
                                if (this.selectedIdentity == null) {
                                    this.identityTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.identities.get(0)));
                                }
                            }
                            this.identitySelectionMainComposite.forceFocus();
                            this.identitySelectionMainComposite.layout();
                            this.cleanNotifications();
                            if (this.identities.isEmpty()) {
                                this.addNoIdentityNotification();
                            }
                            this.notificationComposite.getParent().setRedraw(true);
                            this.notificationComposite.getParent().layout(true, true);
                        });
                    }
                    Thread.sleep(2000L);
                    this.interrupted = true;
                }
            }
            catch (MobileSetupException | InterruptedException throwable) {
            }
            catch (IOException e) {
                UISynchronizeService.syncExec(() -> MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR, (String)e.getMessage()));
            }
            catch (Exception exception) {}
        });
    }

    private void setProvisioningProfileName(List<String> eligibleProvisioningProfileNameList) {
        if (!eligibleProvisioningProfileNameList.isEmpty()) {
            this.provisioningProfileCombo.setItems(eligibleProvisioningProfileNameList.toArray(new String[0]));
            this.provisioningProfileCombo.select(0);
        } else {
            eligibleProvisioningProfileNameList.add(ComposerMobileMessageConstants.DEFAULT_PROVISIONING_PROFILE_NAME);
            this.provisioningProfileCombo.setItems(eligibleProvisioningProfileNameList.toArray(new String[0]));
            this.provisioningProfileCombo.select(0);
        }
    }

    private List<IosIdentityInfo> getIndentityListFromEligibleProvisioningProfile(ProvisioningProfile provisioningProfile) throws Exception {
        ArrayList<IosIdentityInfo> teamIdentities = new ArrayList<IosIdentityInfo>();
        List<String> identityLines = MobileUtil.getRawIdentityList();
        for (String identityLine : identityLines) {
            boolean identityExistInProvisioningProfile;
            LoggerSingleton.logInfo((String)identityLine);
            IosIdentityInfo identity = this.parseIdentityFromIdentityLine(identityLine);
            if (identity == null || provisioningProfile == null || !(identityExistInProvisioningProfile = this.identityExistInEligibleProvisioningProfile(provisioningProfile.getDeveloperCertificates(), identity.fingerprint()))) continue;
            try {
                IosIdentityInfo team = SystemCertificationUtil.getTeamInfoByCertificateName((String)identity.name(), (String)identity.fingerprint());
                if (team == null || teamIdentities.contains(team)) continue;
                teamIdentities.add(team);
            }
            catch (CertificateException error) {
                LoggerSingleton.logError((Throwable)error);
                UISynchronizeService.syncExec(() -> MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR, (String)error.getMessage()));
            }
        }
        return teamIdentities;
    }

    private boolean identityExistInEligibleProvisioningProfile(List<X509Certificate> certificates, String fingerprint) {
        return certificates.stream().anyMatch(cert -> {
            try {
                String certFingerprint = SystemCertificationUtil.getFingerPrint((X509Certificate)cert);
                return StringUtils.equals((String)certFingerprint, (String)fingerprint);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return false;
            }
        });
    }

    private IosIdentityInfo parseIdentityFromIdentityLine(String identityLine) {
        String name = null;
        String teamId = null;
        Matcher fullnameMatcher = Pattern.compile(".+? \"(.+?)\"").matcher(identityLine);
        if (!fullnameMatcher.find()) {
            return null;
        }
        name = fullnameMatcher.group(1);
        Matcher teamIdMatcher = Pattern.compile("\\((\\w+?)\\)").matcher(name);
        if (!teamIdMatcher.find()) {
            return null;
        }
        teamId = teamIdMatcher.group(1);
        Matcher fingerprintMatcher = Pattern.compile("\\b[A-F0-9]{40}\\b").matcher(identityLine);
        if (!fingerprintMatcher.find()) {
            return null;
        }
        String fingerprint = fingerprintMatcher.group(0);
        return new IosIdentityInfo(name, teamId, fingerprint);
    }

    private void cleanNotifications() {
        while (this.notificationComposite.getChildren() != null && this.notificationComposite.getChildren().length > 0) {
            this.notificationComposite.getChildren()[0].dispose();
        }
    }

    private void addNoIdentityNotification() {
        Composite noIdentityNotificationComposite = new Composite(this.notificationComposite, 0);
        noIdentityNotificationComposite.setLayout((Layout)new GridLayout(2, false));
        noIdentityNotificationComposite.setBackground(ColorUtil.getWarningLogBackgroundColor());
        noIdentityNotificationComposite.setBackgroundMode(2);
        Label lblNoIdentityNotification = new Label(noIdentityNotificationComposite, 0);
        lblNoIdentityNotification.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        lblNoIdentityNotification.setText(ComposerMobileMessageConstants.DIA_LBL_IDENTITY_TROUBLESHOOT);
        Link lnkNoIdentityTroubleshoot = new Link(noIdentityNotificationComposite, 0);
        lnkNoIdentityTroubleshoot.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        lnkNoIdentityTroubleshoot.setText(String.format("<a>%s</a>", ComposerMobileMessageConstants.DIA_LNK_IDENTITY_TROUBLESHOOT));
        lnkNoIdentityTroubleshoot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)IosProvisioningProfileAndIdentitySelectionDialog.this.getTroubleshootLink());
            }
        });
    }

    private String getTroubleshootLink() {
        return ComposerMobileMessageConstants.TROUBLESHOOT_WEBDRIVERAGENT_ISSUES_LINK;
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.provisioningProfileLabel = new Label(container, 0);
        this.provisioningProfileLabel.setText("1. Select your provisioning profile:");
        this.provisioningProfileComposite = new Composite(container, 0);
        this.provisioningProfileComposite.setLayout((Layout)new GridLayout(2, false));
        this.provisioningProfileComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.provisioningProfileComboBoxLabel = new Label(this.provisioningProfileComposite, 0);
        this.provisioningProfileComboBoxLabel.setText("Provisioning profile:");
        this.provisioningProfileCombo = new Combo(this.provisioningProfileComposite, 12);
        this.provisioningProfileCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.developmentIdentityLabel = new Label(container, 0);
        this.developmentIdentityLabel.setText("2. Select your development identity:");
        this.notificationComposite = new Composite(container, 0);
        this.notificationComposite.setLayout((Layout)new FillLayout(512));
        this.notificationComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.identitySelectionMainComposite = new Composite(container, 0);
        this.identitySelectionMainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.identitySelectionMainComposite.setLayout((Layout)this.stackLayout);
        this.loadingIdentitiesComposite = new Composite(this.identitySelectionMainComposite, 0);
        this.loadingIdentitiesComposite.setLayout((Layout)new GridLayout(2, false));
        this.connectingLabel = new GifCLabel(this.loadingIdentitiesComposite, 0x20000000);
        this.connectingLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        try {
            this.loadingImgInputStream = ImageConstants.URL_16_LOADING.openStream();
            this.connectingLabel.setGifImage(this.loadingImgInputStream);
        }
        catch (IOException iOException) {}
        Label lblLoadingIdentities = new Label(this.loadingIdentitiesComposite, 0);
        lblLoadingIdentities.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblLoadingIdentities.setText(ComposerMobileMessageConstants.DIA_LBL_LOADING_IDENTITIES);
        this.noIdentityComposite = new Composite(this.identitySelectionMainComposite, 0);
        this.noIdentityComposite.setLayout((Layout)new GridLayout());
        Label lblNoIdentityFound = new Label(this.noIdentityComposite, 0);
        lblNoIdentityFound.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblNoIdentityFound.setText(ComposerMobileMessageConstants.DIA_MSG_NO_IDENTITY_FOUND);
        this.tableComposite = new Composite(this.identitySelectionMainComposite, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)tableLayout);
        this.identityTableViewer = new CTableViewer(this.tableComposite, 2048);
        this.identityTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn identityColumnViewer = new TableViewerColumn(this.identityTableViewer, 0);
        tableLayout.setColumnData((Widget)identityColumnViewer.getColumn(), (ColumnLayoutData)new ColumnWeightData(98, 300));
        identityColumnViewer.setLabelProvider((CellLabelProvider)new IosIdentityColumnLabelProvider(0));
        this.stackLayout.topControl = this.tableComposite;
        this.identitySelectionMainComposite.layout();
        return this.identitySelectionMainComposite;
    }

    public String getDialogTitle() {
        return ComposerMobileMessageConstants.DIA_TITLE_IOS_PROVISIONING_PROFILE_AND_IDENTITIES;
    }

    protected Point getInitialSize() {
        return new Point(450, 350);
    }

    public IosIdentityInfo getIdentity() {
        return this.selectedIdentity;
    }

    public String getProvisioningProfileName() {
        return this.provisionigProfileName;
    }

    public boolean close() {
        this.interrupted = true;
        return super.close();
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        ComponentUtil.setFillLayout((Control)composite);
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        HelpComposite helpIcon = ComponentUtil.createHelpButton((Composite)composite, (String)ComposerMobileMessageConstants.INSTALL_WEBDRIVERAGENT_HELP_ICON_LINK);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        helpIcon.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 10;
        helpIcon.setLayout((Layout)gridLayout);
        Composite rightContainer = new Composite(composite, 0);
        GridData comboLayout = new GridData(131072, 0x1000000, true, false);
        rightContainer.setLayoutData((Object)comboLayout);
        gridLayout = new GridLayout(1, false);
        rightContainer.setLayout((Layout)gridLayout);
        this.createButton(rightContainer, 14, ComposerMobileMessageConstants.BTN_BACK_LABEL, false);
        this.createButton(rightContainer, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (14 == buttonId) {
            this.backPressed();
        }
    }

    private void backPressed() {
        this.setReturnCode(14);
        this.close();
    }
}

