/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.integration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.constants.HttpMethod;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.util.internal.ProcessUtil;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.util.EntityTagUtil;
import com.kms.katalon.execution.collector.AzureDevOpsReport;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.integration.azure.AzureIntegrationUtil;
import com.kms.katalon.integration.azure.constant.AzureMessagesConstants;
import com.kms.katalon.integration.azure.constant.StringConstants;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.integration.AzureReportIntegrationContributionHelper;
import com.kms.katalon.integration.azure.model.AzureBuildRef;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureGetWorkItemsBatchReqBody;
import com.kms.katalon.integration.azure.model.AzureGetWorkItemsBatchResBody;
import com.kms.katalon.integration.azure.model.AzureGetWorkItemsBatchResBodyItem;
import com.kms.katalon.integration.azure.model.AzureOperation;
import com.kms.katalon.integration.azure.model.AzureOperationType;
import com.kms.katalon.integration.azure.model.AzureProjectRef;
import com.kms.katalon.integration.azure.model.AzureReleaseRef;
import com.kms.katalon.integration.azure.model.AzureTestAttachment;
import com.kms.katalon.integration.azure.model.AzureTestCaseResult;
import com.kms.katalon.integration.azure.model.AzureTestCaseResultBody;
import com.kms.katalon.integration.azure.model.AzureTestPlanRef;
import com.kms.katalon.integration.azure.model.AzureTestPoint;
import com.kms.katalon.integration.azure.model.AzureTestPointList;
import com.kms.katalon.integration.azure.model.AzureTestRun;
import com.kms.katalon.integration.azure.model.AzureTestSuiteRef;
import com.kms.katalon.integration.azure.model.AzureUpdateWorkItemsBatchReqBodyItem;
import com.kms.katalon.integration.azure.model.AzureUpdateWorkItemsBatchResBody;
import com.kms.katalon.integration.azure.model.AzureUpdateWorkItemsBatchResBodyItem;
import com.kms.katalon.integration.azure.model.TestPointMappers;
import com.kms.katalon.integration.azure.provider.AzureAPIProvider;
import com.kms.katalon.integration.azure.provider.AzureIntegrationRequest;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import com.kms.katalon.integration.azure.setting.ExecutionMappingUtil;
import com.kms.katalon.integration.azure.setting.TestConfigurationMapping;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class AzureReportIntegrationContribution
implements ReportIntegrationContribution {
    public static final String ADO_TEST_PLAN_ID_OPTION = "adoPlanId";
    public static final String ADO_TEST_PLAN_ID_SECOND_OPTION = "adoPlanID";
    public static final String ADO_TEST_RUN_NAME = "adoTestRunName";
    private Set<Integer> testPlanIds;
    private String testRunName;
    private List<String> cliAdoPlanId = new ArrayList<String>();
    private String cliTestRunName;
    private AzureDevOpsReport trackingReport = new AzureDevOpsReport();
    public static final StringConsoleOption ADO_TEST_PLAN_ID_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return AzureReportIntegrationContribution.ADO_TEST_PLAN_ID_OPTION;
        }

        public boolean isRequired() {
            return false;
        }
    };
    public static final StringConsoleOption ADO_TEST_PLAN_ID_SECOND_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return AzureReportIntegrationContribution.ADO_TEST_PLAN_ID_SECOND_OPTION;
        }

        public boolean isRequired() {
            return false;
        }
    };
    public static final StringConsoleOption ADO_TEST_RUN_NAME_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return AzureReportIntegrationContribution.ADO_TEST_RUN_NAME;
        }

        public boolean isRequired() {
            return false;
        }
    };

    public void fetchRemoteSettings() {
    }

    public boolean isAllowedGenerateTestSuiteReportWhenRunningTestSuiteCollection() {
        return false;
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList integrationCommandList = new ArrayList();
        integrationCommandList.add((ConsoleOption<?>)ADO_TEST_PLAN_ID_CONSOLE_OPTION);
        integrationCommandList.add((ConsoleOption<?>)ADO_TEST_PLAN_ID_SECOND_CONSOLE_OPTION);
        integrationCommandList.add((ConsoleOption<?>)ADO_TEST_RUN_NAME_CONSOLE_OPTION);
        return integrationCommandList;
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (StringUtils.isBlank((CharSequence)argumentValue)) {
            return;
        }
        if (consoleOption == ADO_TEST_PLAN_ID_CONSOLE_OPTION) {
            String[] planIds;
            String[] stringArray = planIds = argumentValue.trim().split(",");
            int n = planIds.length;
            int n2 = 0;
            while (n2 < n) {
                String planId = stringArray[n2];
                String trimmedId = planId.trim();
                if (StringUtils.isNotBlank((CharSequence)trimmedId)) {
                    this.cliAdoPlanId.add(trimmedId);
                }
                ++n2;
            }
            return;
        }
        if (consoleOption == ADO_TEST_PLAN_ID_SECOND_CONSOLE_OPTION) {
            if (this.cliAdoPlanId.isEmpty()) {
                String[] planIds;
                String[] stringArray = planIds = argumentValue.trim().split(",");
                int n = planIds.length;
                int n3 = 0;
                while (n3 < n) {
                    String planId = stringArray[n3];
                    String trimmedId = planId.trim();
                    if (StringUtils.isNotBlank((CharSequence)trimmedId)) {
                        this.cliAdoPlanId.add(trimmedId);
                    }
                    ++n3;
                }
            }
            return;
        }
        if (consoleOption == ADO_TEST_RUN_NAME_CONSOLE_OPTION) {
            this.cliTestRunName = argumentValue.trim();
            return;
        }
    }

    public boolean isIntegrationActive(TestSuiteEntity testSuite) {
        String projectDir;
        this.trackingReport = new AzureDevOpsReport();
        if (testSuite == null) {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            projectDir = project.getFolderLocation();
        } else {
            projectDir = testSuite.getProject().getFolderLocation();
        }
        boolean isIntegrationEnabled = AzureIntegrationUtil.isIntegrationEnabled(projectDir);
        this.trackingReport.setIntegrationEnabled(isIntegrationEnabled);
        if (!isIntegrationEnabled) {
            return false;
        }
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        return settingStore.isAutoSubmitTestRunEnabled();
    }

    private boolean checkAndSetConsoleArgs(List<String> planIdParams, String testRunNameParam, String buildDefIdParam, String releaseDefIdParam) {
        if (AzureReportIntegrationContributionHelper.isUploadedByDefault(planIdParams, testRunNameParam, buildDefIdParam, releaseDefIdParam)) {
            return true;
        }
        if (!ProcessUtil.isKRE()) {
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringConstants.MSG_INFO_PARAMETER_RECEIVED);
        if (planIdParams != null && !planIdParams.isEmpty()) {
            HashSet<Integer> parsedTestPlanIds = new HashSet<Integer>();
            for (String planIdParam : planIdParams) {
                try {
                    int testPlanId = Integer.parseInt(planIdParam);
                    if (testPlanId < 0) {
                        throw new NumberFormatException();
                    }
                    parsedTestPlanIds.add(testPlanId);
                }
                catch (NumberFormatException exception) {
                    exception = new NumberFormatException(MessageFormat.format(StringConstants.MSG_ERROR_INVALID_PARAMETER, planIdParam, ADO_TEST_PLAN_ID_OPTION));
                    LogUtil.printAndLogError((Throwable)exception);
                    return false;
                }
            }
            if (!parsedTestPlanIds.isEmpty()) {
                stringBuilder.append(" AzureTestPlanIds=" + String.valueOf(parsedTestPlanIds));
                this.testPlanIds = parsedTestPlanIds;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)testRunNameParam)) {
            stringBuilder.append(" AzureTestRunName=" + testRunNameParam);
            this.testRunName = this.cliTestRunName;
        }
        if (StringUtils.isNotEmpty((CharSequence)buildDefIdParam)) {
            try {
                int buildDefId = Integer.parseInt(buildDefIdParam);
                if (buildDefId < 0) {
                    throw new NumberFormatException();
                }
                stringBuilder.append(" AzureBuildDefinitionId=" + buildDefIdParam);
            }
            catch (NumberFormatException exception) {
                exception = new NumberFormatException(MessageFormat.format(StringConstants.MSG_ERROR_INVALID_PARAMETER, buildDefIdParam, "adoBuildDefId (adoDefinitionId)"));
                LogUtil.printAndLogError((Throwable)exception);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)releaseDefIdParam)) {
            try {
                int releaseDefId = Integer.parseInt(releaseDefIdParam);
                if (releaseDefId < 0) {
                    throw new NumberFormatException();
                }
                stringBuilder.append(" AzureReleaseDefinitionId=" + releaseDefIdParam);
            }
            catch (NumberFormatException exception) {
                exception = new NumberFormatException(MessageFormat.format(StringConstants.MSG_ERROR_INVALID_PARAMETER, releaseDefIdParam, "adoReleaseDefId"));
                LogUtil.printAndLogError((Throwable)exception);
            }
        }
        LogUtil.logInfo((String)stringBuilder.toString());
        return true;
    }

    private Set<Integer> loadTestPlanIdsFromSettingStore(AzureSettingStore settingStore) {
        AzureTestPlanRef[] testPlans = settingStore.getAzureTestPlans();
        return Arrays.stream(testPlans).map(plan -> plan.getId()).collect(Collectors.toSet());
    }

    public void uploadTestSuiteCollectionResult(TestSuiteCollectionLogRecord collectionLogRecord) throws Exception {
        AzureBuildRef build;
        String rawReleaseDefinitionId;
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        if (!settingStore.isIntegrationEnabled()) {
            return;
        }
        if (!settingStore.isAutoSubmitTestRunEnabled()) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_SUBMIT_TEST_RUN_IS_DISABLED);
            return;
        }
        this.resetArgumentsForKS();
        TestCaseUploadStatistics statistics = new TestCaseUploadStatistics();
        if (collectionLogRecord == null || collectionLogRecord.getTestSuiteRecords() == null || collectionLogRecord.getTestSuiteRecords().size() <= 0) {
            return;
        }
        List suiteLogRecordList = collectionLogRecord.getTestSuiteRecords();
        String rawBuildDefinitionId = ((TestSuiteLogRecord)suiteLogRecordList.get(0)).getAzurebBuildDefinitionId();
        if (!this.checkAndSetConsoleArgs(this.cliAdoPlanId, this.cliTestRunName, rawBuildDefinitionId, rawReleaseDefinitionId = ((TestSuiteLogRecord)suiteLogRecordList.get(0)).getAzurebReleaseDefinitionId())) {
            return;
        }
        AzureProjectRef azureProject = settingStore.getIntegratedProject();
        if (azureProject == null) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_NO_PROJECT_SELECTED);
            return;
        }
        Set<Integer> set = this.testPlanIds = this.testPlanIds == null || this.testPlanIds.isEmpty() ? this.loadTestPlanIdsFromSettingStore(settingStore) : this.testPlanIds;
        if (this.testPlanIds.isEmpty()) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_NO_TEST_PLAN_SELECTED);
            return;
        }
        String string = this.testRunName = StringUtils.isEmpty((CharSequence)this.testRunName) ? settingStore.getTestRunName() : this.testRunName;
        if (StringUtils.isEmpty((CharSequence)this.testRunName)) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_TEST_RUN_NAME_IS_EMPTY);
            return;
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        AzureCredential credential = settingStore.getCredential();
        TestPointMappers allTestPointMappers = new TestPointMappers();
        List<TestConfigurationMapping> testConfigurationMappingList = settingStore.getTestConfigurationMappings();
        ArrayList<TestSuiteLogRecord> testSuitesHaveFailedOrErrorTestPoints = new ArrayList<TestSuiteLogRecord>();
        for (TestSuiteLogRecord suiteLog : suiteLogRecordList) {
            TestPointMappers mappersForCurrentTS = this.getAzureTestPointsWithKatalonTestCases(testConfigurationMappingList, project, suiteLog, statistics);
            if (mappersForCurrentTS == null || mappersForCurrentTS.isEmpty()) continue;
            allTestPointMappers.addAll(mappersForCurrentTS);
            if (!AzureReportIntegrationContributionHelper.doesTestSuiteHasFailedOrErrorTestPoints(suiteLog, mappersForCurrentTS)) continue;
            testSuitesHaveFailedOrErrorTestPoints.add(suiteLog);
        }
        if (allTestPointMappers.isEmpty()) {
            return;
        }
        int buildDefId = NumberUtils.toInt((String)rawBuildDefinitionId, (int)settingStore.getBuildDefinitionId());
        int releaseDefId = NumberUtils.toInt((String)rawReleaseDefinitionId, (int)settingStore.getReleaseDefinitionId());
        int buildNumberId = -1;
        if (buildDefId >= 0 && (build = AzureIntegrationRequest.getLatestBuildNumber(credential, azureProject.getId(), buildDefId)) != null) {
            buildNumberId = build.getId();
        }
        AzureReleaseRef release = null;
        try {
            if (releaseDefId >= 0) {
                LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_GETTING_LATEST_RELEASE, releaseDefId));
                release = AzureIntegrationRequest.getLatestReleaseWithInProgressEnvironment(credential, azureProject.getId(), releaseDefId);
                if (release == null) {
                    LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_LATEST_RELEASE_NOT_IN_PROGRESS, releaseDefId));
                }
            }
        }
        catch (AzureApiException exception) {
            LogUtil.logError((String)exception.getMessage());
            throw exception;
        }
        StringBuilder testRunComment = new StringBuilder(AzureMessagesConstants.MSG_COMMENT_EXECUTED_BY);
        for (TestSuiteLogRecord suiteLog : suiteLogRecordList) {
            testRunComment.append("\n").append(this.getTestSuiteInfoComment(suiteLog));
        }
        String azureProjectId = azureProject.getId();
        Map<Integer, TestPointMappers> testPointMappersByTestPlanId = allTestPointMappers.splitAndGroupByTestPlanId();
        for (Map.Entry<Integer, TestPointMappers> entry : testPointMappersByTestPlanId.entrySet()) {
            int testPlanId = entry.getKey();
            TestPointMappers testPointMappers = entry.getValue();
            int[] testPointIds = testPointMappers.getTestPointIds();
            LogUtil.logInfo((String)StringConstants.MSG_INFO_CREATING_TEST_RUN);
            AzureTestRun testRun = AzureIntegrationRequest.createTestRun(credential, azureProjectId, buildNumberId, this.testRunName, testRunComment.toString(), testPlanId, testPointIds, release);
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_CREATED_TEST_RUN, testRun.getId(), testRun.getUrl()));
            this.trackingReport.setTestRunCreated(true);
            LogUtil.logInfo((String)StringConstants.MSG_INFO_RETRIEVING_TEST_RESULTS);
            AzureTestCaseResultBody getTestCaseResultsBody = AzureIntegrationRequest.getTestCaseResults(credential, azureProjectId, testRun);
            this.trackingReport.setAdoCreatedTestResultCount(getTestCaseResultsBody.getCount());
            AzureTestCaseResult[] updatedResults = AzureReportIntegrationContributionHelper.updateStatusForTestCaseResult(((TestSuiteLogRecord)suiteLogRecordList.get(0)).getHostName(), allTestPointMappers, settingStore.getExecutionStatusMappings(), getTestCaseResultsBody);
            LogUtil.logInfo((String)StringConstants.MSG_INFO_UPDATE_TEST_RESULTS);
            AzureIntegrationRequest.updateTestCaseResults(credential, azureProjectId, testRun, updatedResults);
            List<AzureTestAttachment> attachments = AzureReportIntegrationContributionHelper.getTestSuiteCollectionAttachments(settingStore, collectionLogRecord, testSuitesHaveFailedOrErrorTestPoints);
            if (attachments != null && !attachments.isEmpty()) {
                for (AzureTestAttachment a : attachments) {
                    LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_UPLOAD_ATTACHMENT, a.getFileName()));
                    try {
                        AzureIntegrationRequest.uploadAttachment(credential, azureProjectId, testRun, a);
                        if (a.getAbsolutePath() == null) continue;
                        File attachmentFile = new File(a.getAbsolutePath());
                        if (a.getFileName() == null || !a.getFileName().contains(".zip") || !attachmentFile.exists()) continue;
                        attachmentFile.delete();
                    }
                    catch (AzureApiException azureApiException) {}
                }
            }
            LogUtil.logInfo((String)StringConstants.MSG_INFO_COMPLETING_TEST_RUN);
            AzureTestRun completedTestRun = AzureIntegrationRequest.completeTestRun(credential, azureProjectId, testRun);
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_COMPLETED_TEST_RUN, this.testRunName, completedTestRun.getId(), testPlanId, completedTestRun.getUrl()));
        }
        try {
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_START_UPDATING_AZURE_TEST_CASES_FIELDS, collectionLogRecord.getId()));
            this.updateAzureTestCasesFields(suiteLogRecordList);
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_UPDATED_AZURE_TEST_CASES_FIELDS, collectionLogRecord.getId()));
            statistics.logSummary();
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)MessageFormat.format(StringConstants.MSG_INFO_UPDATED_AZURE_TEST_CASES_FIELDS, collectionLogRecord.getId()));
        }
    }

    public void uploadTestSuiteResult(TestSuiteLogRecord suiteLogRecord) throws Exception {
        AzureBuildRef build;
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        if (!settingStore.isIntegrationEnabled()) {
            return;
        }
        if (!settingStore.isAutoSubmitTestRunEnabled()) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_SUBMIT_TEST_RUN_IS_DISABLED);
            return;
        }
        this.resetArgumentsForKS();
        TestCaseUploadStatistics statistics = new TestCaseUploadStatistics();
        String rawBuildDefId = suiteLogRecord.getAzurebBuildDefinitionId();
        String rawReleaseDefId = suiteLogRecord.getAzurebReleaseDefinitionId();
        if (!this.checkAndSetConsoleArgs(this.cliAdoPlanId, this.cliTestRunName, rawBuildDefId, rawReleaseDefId)) {
            return;
        }
        AzureProjectRef azureProject = settingStore.getIntegratedProject();
        if (azureProject == null) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_NO_PROJECT_SELECTED);
            return;
        }
        Set<Integer> set = this.testPlanIds = this.testPlanIds == null || this.testPlanIds.isEmpty() ? this.loadTestPlanIdsFromSettingStore(settingStore) : this.testPlanIds;
        if (this.testPlanIds.isEmpty()) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_NO_TEST_PLAN_SELECTED);
            return;
        }
        String string = this.testRunName = StringUtils.isEmpty((CharSequence)this.testRunName) ? settingStore.getTestRunName() : this.testRunName;
        if (StringUtils.isEmpty((CharSequence)this.testRunName)) {
            LogUtil.logInfo((String)StringConstants.MSG_INFO_TEST_RUN_NAME_IS_EMPTY);
            return;
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        AzureCredential credential = settingStore.getCredential();
        TestPointMappers allTestPointMappers = this.getAzureTestPointsWithKatalonTestCases(settingStore.getTestConfigurationMappings(), project, suiteLogRecord, statistics);
        if (allTestPointMappers == null || allTestPointMappers.isEmpty()) {
            return;
        }
        int buildDefId = NumberUtils.toInt((String)rawBuildDefId, (int)settingStore.getBuildDefinitionId());
        int releaseDefId = NumberUtils.toInt((String)rawReleaseDefId, (int)settingStore.getReleaseDefinitionId());
        int buildNumberId = -1;
        if (buildDefId >= 0 && (build = AzureIntegrationRequest.getLatestBuildNumber(credential, azureProject.getId(), buildDefId)) != null) {
            buildNumberId = build.getId();
        }
        AzureReleaseRef release = null;
        try {
            if (releaseDefId >= 0) {
                LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_GETTING_LATEST_RELEASE, releaseDefId));
                release = AzureIntegrationRequest.getLatestReleaseWithInProgressEnvironment(credential, azureProject.getId(), releaseDefId);
                if (release == null) {
                    LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_LATEST_RELEASE_NOT_IN_PROGRESS, releaseDefId));
                }
            }
        }
        catch (AzureApiException exception) {
            LogUtil.logError((String)exception.getMessage());
        }
        String azureProjectId = azureProject.getId();
        Map<Integer, TestPointMappers> testPointMappersByTestPlanId = allTestPointMappers.splitAndGroupByTestPlanId();
        for (Map.Entry<Integer, TestPointMappers> entry : testPointMappersByTestPlanId.entrySet()) {
            int testPlanId = entry.getKey();
            TestPointMappers testPointMappers = entry.getValue();
            int[] testPointIds = testPointMappers.getTestPointIds();
            LogUtil.logInfo((String)StringConstants.MSG_INFO_CREATING_TEST_RUN);
            String testRunComment = AzureMessagesConstants.MSG_COMMENT_EXECUTED_BY + "\n" + this.getTestSuiteInfoComment(suiteLogRecord);
            AzureTestRun testRun = AzureIntegrationRequest.createTestRun(credential, azureProjectId, buildNumberId, this.testRunName, testRunComment, testPlanId, testPointIds, release);
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_CREATED_TEST_RUN, testRun.getId(), testRun.getUrl()));
            this.trackingReport.setTestRunCreated(true);
            LogUtil.logInfo((String)StringConstants.MSG_INFO_RETRIEVING_TEST_RESULTS);
            AzureTestCaseResultBody getTestCaseResultsBody = AzureIntegrationRequest.getTestCaseResults(credential, azureProjectId, testRun);
            this.trackingReport.setAdoCreatedTestResultCount(getTestCaseResultsBody.getCount());
            AzureTestCaseResult[] updatedResults = AzureReportIntegrationContributionHelper.updateStatusForTestCaseResult(suiteLogRecord.getHostName(), allTestPointMappers, settingStore.getExecutionStatusMappings(), getTestCaseResultsBody);
            LogUtil.logInfo((String)StringConstants.MSG_INFO_UPDATE_TEST_RESULTS);
            AzureIntegrationRequest.updateTestCaseResults(credential, azureProjectId, testRun, updatedResults);
            boolean doesTestSuiteHasFailedOrErrorTestPoints = AzureReportIntegrationContributionHelper.doesTestSuiteHasFailedOrErrorTestPoints(suiteLogRecord, allTestPointMappers);
            List<AzureTestAttachment> attachments = AzureReportIntegrationContributionHelper.getTestSuiteAttachments(settingStore, suiteLogRecord, doesTestSuiteHasFailedOrErrorTestPoints);
            if (attachments != null && !attachments.isEmpty()) {
                for (AzureTestAttachment a : attachments) {
                    LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_UPLOAD_ATTACHMENT, a.getFileName()));
                    try {
                        AzureIntegrationRequest.uploadAttachment(credential, azureProjectId, testRun, a);
                    }
                    catch (AzureApiException azureApiException) {}
                }
            }
            LogUtil.logInfo((String)StringConstants.MSG_INFO_COMPLETING_TEST_RUN);
            AzureTestRun completedTestRun = AzureIntegrationRequest.completeTestRun(credential, azureProjectId, testRun);
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_COMPLETED_TEST_RUN, this.testRunName, completedTestRun.getId(), testPlanId, completedTestRun.getUrl()));
        }
        try {
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_START_UPDATING_AZURE_TEST_CASES_FIELDS, suiteLogRecord.getId()));
            this.updateAzureTestCasesFields(List.of(suiteLogRecord));
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_UPDATED_AZURE_TEST_CASES_FIELDS, suiteLogRecord.getId()));
            statistics.logSummary();
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)MessageFormat.format(StringConstants.MSG_INFO_UPDATED_AZURE_TEST_CASES_FIELDS, suiteLogRecord.getId()));
        }
    }

    private TestPointMappers getAzureTestPointsWithKatalonTestCases(List<TestConfigurationMapping> storedTestConfigurationMappingList, ProjectEntity project, TestSuiteLogRecord suiteLogRecord, TestCaseUploadStatistics statistics) throws Exception {
        if (suiteLogRecord == null) {
            return null;
        }
        TestPointMappers mappers = new TestPointMappers();
        String testSuiteId = suiteLogRecord.getId();
        TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, project);
        List<Integer> configurationIdList = ExecutionMappingUtil.getSuitableConfigurations(suiteLogRecord, storedTestConfigurationMappingList);
        if (configurationIdList.isEmpty()) {
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_NO_SUITABLE_TEST_CONFIGURATION, testSuite.getName()));
            return null;
        }
        ArrayList skippedTestCaseIds = new ArrayList();
        ILogRecord[] iLogRecordArray = suiteLogRecord.filterFinalTestCasesResult();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord logRecord = iLogRecordArray[n2];
            if (logRecord instanceof TestCaseLogRecord) {
                statistics.incrementTotal();
                TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)logRecord;
                List<Object> testCasePoints = new ArrayList();
                try {
                    testCasePoints = this.getTestPoints(testSuite, testCaseLogRecord, suiteLogRecord, configurationIdList);
                }
                catch (Exception exception) {
                    LogUtil.logError((Throwable)exception);
                    throw exception;
                }
                if (!testCasePoints.isEmpty()) {
                    for (AzureTestPoint azureTestPoint : testCasePoints) {
                        mappers.add(azureTestPoint, testCaseLogRecord);
                    }
                    statistics.incrementUploaded();
                } else {
                    String rawTestCaseIds;
                    TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseLogRecord.getId());
                    IntegratedEntity testCaseIntegratedEntity = AzureIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCaseEntity);
                    if (testCaseIntegratedEntity != null && StringUtils.isNotBlank((CharSequence)(rawTestCaseIds = (String)testCaseIntegratedEntity.getProperties().get("azure.testcase.ids")))) {
                        statistics.incrementSkipped();
                        Set parsedIds = EntityTagUtil.parse((String)rawTestCaseIds);
                        skippedTestCaseIds.addAll(parsedIds);
                    }
                }
            }
            ++n2;
        }
        if (!skippedTestCaseIds.isEmpty()) {
            int maxExamples = 3;
            List exampleIds = skippedTestCaseIds.stream().limit(maxExamples).collect(Collectors.toList());
            Object testCaseIdsDisplay = String.join((CharSequence)", ", exampleIds);
            if (skippedTestCaseIds.size() > maxExamples) {
                int remaining = skippedTestCaseIds.size() - maxExamples;
                testCaseIdsDisplay = (String)testCaseIdsDisplay + "... (and " + remaining + " more)";
            }
            LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_WARNING_SKIPPED_TEST_CASE_IDS, testCaseIdsDisplay, this.testPlanIds));
        }
        return mappers;
    }

    private List<AzureTestPoint> getTestPoints(TestSuiteEntity testSuiteEntity, TestCaseLogRecord testLogEntity, TestSuiteLogRecord suiteLog, List<Integer> configurationIdList) throws Exception {
        TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId(testLogEntity.getId());
        IntegratedEntity testCaseIntegratedEntity = AzureIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCaseEntity);
        if (testCaseIntegratedEntity == null) {
            return new ArrayList<AzureTestPoint>();
        }
        String rawTestCaseIds = (String)testCaseIntegratedEntity.getProperties().get("azure.testcase.ids");
        if (StringUtils.isNotBlank((CharSequence)(rawTestCaseIds = AzureReportIntegrationContributionHelper.parseVariablesFromInput(rawTestCaseIds, testLogEntity)))) {
            this.trackingReport.addIntegratedTestCase(testLogEntity);
        }
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        AzureCredential credential = settingStore.getCredential();
        AzureProjectRef azureProject = settingStore.getIntegratedProject();
        boolean isSubmitMultipleTestPointsEnabled = settingStore.isSubmitMultipleTestPointsEnabled();
        ArrayList<AzureTestPoint> testPoints = new ArrayList<AzureTestPoint>();
        for (String id : EntityTagUtil.parse((String)rawTestCaseIds)) {
            int testCaseId;
            List<AzureTestSuiteRef> testSuiteOfTestCase;
            if (!AzureIntegrationUtil.isPositiveInteger(id) || (testSuiteOfTestCase = AzureIntegrationUtil.getTestSuiteRefs(credential, this.testPlanIds, testCaseId = Integer.parseInt(id))) == null || testSuiteOfTestCase.isEmpty()) continue;
            List<AzureTestPoint> testPointsOfTestCase = new ArrayList<AzureTestPoint>();
            for (AzureTestSuiteRef testSuite : testSuiteOfTestCase) {
                AzureTestPointList testPointsByTestSuite = AzureIntegrationRequest.getTestPointListByTestCase(credential, azureProject.getId(), testSuite.getTestPlan().getId(), testSuite.getId(), testCaseId);
                if (testPointsByTestSuite == null || testPointsByTestSuite.getCount() <= 0) continue;
                testPointsOfTestCase.addAll(Arrays.asList(testPointsByTestSuite.getValue()));
            }
            if (testPointsOfTestCase.isEmpty()) continue;
            if (testPointsOfTestCase.size() > 1 && !isSubmitMultipleTestPointsEnabled) {
                LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_DUPLICATE_TEST_POINTS, testCaseId, AzureReportIntegrationContributionHelper.getTestPointsIdString(testPointsOfTestCase)));
                continue;
            }
            testPointsOfTestCase = AzureReportIntegrationContributionHelper.filterTestPointsByConfigurationIdList(testPointsOfTestCase, configurationIdList);
            testPoints.addAll(testPointsOfTestCase);
        }
        return testPoints;
    }

    private void updateAzureTestCasesFields(List<TestSuiteLogRecord> suiteLogRecordList) throws Exception {
        if (suiteLogRecordList == null || suiteLogRecordList.isEmpty()) {
            return;
        }
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        AzureCredential credential = settingStore.getCredential();
        boolean shouldOverrideExistingAutomationFields = settingStore.isOverrideExistingAutomationFieldsEnabled();
        HashMap<Integer, AzureUpdateWorkItemsBatchReqBodyItem.Builder> currentHashMapBatch = new HashMap<Integer, AzureUpdateWorkItemsBatchReqBodyItem.Builder>(200);
        HashSet<String[]> bulkUpdateErrors = new HashSet<String[]>();
        for (TestSuiteLogRecord suiteLogRecord : suiteLogRecordList) {
            ILogRecord[] iLogRecordArray = suiteLogRecord.filterFinalTestCasesResult();
            int n = iLogRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILogRecord logRecord = iLogRecordArray[n2];
                if (logRecord instanceof TestCaseLogRecord) {
                    TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)logRecord;
                    Set<String> linkedAzureTestCaseIds = this.getLinkedAzureTestCaseIds(testCaseLogRecord);
                    for (String id : linkedAzureTestCaseIds) {
                        if (!AzureIntegrationUtil.isPositiveInteger(id)) continue;
                        int azureTestCaseId = Integer.parseInt(id);
                        if (!shouldOverrideExistingAutomationFields && currentHashMapBatch.containsKey(azureTestCaseId)) continue;
                        AzureUpdateWorkItemsBatchReqBodyItem.Builder witBuilderBatch = this.createAzureWorkItemBuilderBatch(azureTestCaseId, testCaseLogRecord);
                        currentHashMapBatch.put(azureTestCaseId, witBuilderBatch);
                        if (!shouldOverrideExistingAutomationFields && currentHashMapBatch.size() >= 200) {
                            this.filterOutAzureUpdateWorkItemBodyFields(currentHashMapBatch);
                        }
                        if (currentHashMapBatch.size() < 200) continue;
                        List<AzureUpdateWorkItemsBatchReqBodyItem> updateWorkItems = currentHashMapBatch.values().stream().map(AzureUpdateWorkItemsBatchReqBodyItem.Builder::build).collect(Collectors.toList());
                        AzureUpdateWorkItemsBatchResBody response = AzureIntegrationRequest.bulkUpdateWorkItems(credential, updateWorkItems.toArray(new AzureUpdateWorkItemsBatchReqBodyItem[updateWorkItems.size()]));
                        bulkUpdateErrors.addAll(this.getErrorsFromBulkUpdateResponse(response, updateWorkItems));
                        currentHashMapBatch.clear();
                    }
                }
                ++n2;
            }
        }
        if (!shouldOverrideExistingAutomationFields) {
            this.filterOutAzureUpdateWorkItemBodyFields(currentHashMapBatch);
        }
        if (!currentHashMapBatch.isEmpty()) {
            List<AzureUpdateWorkItemsBatchReqBodyItem> updateWorkItems = currentHashMapBatch.values().stream().map(AzureUpdateWorkItemsBatchReqBodyItem.Builder::build).collect(Collectors.toList());
            AzureUpdateWorkItemsBatchResBody response = AzureIntegrationRequest.bulkUpdateWorkItems(credential, updateWorkItems.toArray(new AzureUpdateWorkItemsBatchReqBodyItem[updateWorkItems.size()]));
            bulkUpdateErrors.addAll(this.getErrorsFromBulkUpdateResponse(response, updateWorkItems));
            currentHashMapBatch.clear();
        }
        if (!bulkUpdateErrors.isEmpty()) {
            for (String[] error : bulkUpdateErrors) {
                String testCaseIdText = error[0] == null ? "" : String.format("(ID: %s) ", error[0]);
                String errorMessage = error[1];
                LogUtil.logError((String)MessageFormat.format(StringConstants.MSG_ERROR_CANNOT_UPDATE_AZURE_TEST_CASE_ID_FIELDS, testCaseIdText, errorMessage));
            }
        }
    }

    private void filterOutAzureUpdateWorkItemBodyFields(Map<Integer, AzureUpdateWorkItemsBatchReqBodyItem.Builder> currentBatch) {
        if (currentBatch == null || currentBatch.isEmpty()) {
            return;
        }
        try {
            List<AzureGetWorkItemsBatchResBodyItem> azureTestCasesInfo = this.fetchAzureTestCasesInfo(currentBatch);
            this.removeAzureUpdateWorkItemBodyFields(currentBatch, azureTestCasesInfo);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"An exception occurred while filtering Azure update work item body fields");
        }
    }

    private List<AzureGetWorkItemsBatchResBodyItem> fetchAzureTestCasesInfo(Map<Integer, AzureUpdateWorkItemsBatchReqBodyItem.Builder> currentBatch) throws AzureApiException {
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        if (settingStore == null) {
            return Collections.emptyList();
        }
        AzureCredential credential = settingStore.getCredential();
        if (credential == null) {
            return Collections.emptyList();
        }
        List<Integer> workItemIds = currentBatch.keySet().stream().filter(Objects::nonNull).filter(witId -> witId > 0).collect(Collectors.toList());
        if (workItemIds.isEmpty()) {
            return Collections.emptyList();
        }
        AzureGetWorkItemsBatchReqBody getWIBatchReqBody = new AzureGetWorkItemsBatchReqBody(workItemIds, List.of("Microsoft.VSTS.TCM.AutomatedTestId", "Microsoft.VSTS.TCM.AutomatedTestName", "Microsoft.VSTS.TCM.AutomatedTestStorage"));
        AzureGetWorkItemsBatchResBody response = AzureIntegrationRequest.bulkRetrieveWorkItemsBatch(credential, getWIBatchReqBody);
        if (response == null || response.getValue() == null || response.getValue().isEmpty()) {
            return Collections.emptyList();
        }
        return response.getValue().stream().filter(Objects::nonNull).filter(item -> item.getFields() != null).collect(Collectors.toList());
    }

    private void removeAzureUpdateWorkItemBodyFields(Map<Integer, AzureUpdateWorkItemsBatchReqBodyItem.Builder> currentBatch, List<AzureGetWorkItemsBatchResBodyItem> azureTestCasesInfo) {
        if (azureTestCasesInfo.isEmpty()) {
            return;
        }
        Map<Integer, AzureGetWorkItemsBatchResBodyItem> azureTestCasesInfoMap = azureTestCasesInfo.stream().collect(Collectors.toMap(AzureGetWorkItemsBatchResBodyItem::getId, item -> item, (existing, replacement) -> replacement));
        ArrayList keysToRemove = new ArrayList();
        currentBatch.forEach((witId, item) -> {
            boolean shouldRemoveCurrentWitId;
            if (item == null) {
                keysToRemove.add(witId);
                return;
            }
            AzureGetWorkItemsBatchResBodyItem azureTestCaseInfo = (AzureGetWorkItemsBatchResBodyItem)azureTestCasesInfoMap.get(witId);
            if (azureTestCaseInfo != null && (shouldRemoveCurrentWitId = this.processUpdateWorkItemBodyFieldsAndDecideToRemove((AzureUpdateWorkItemsBatchReqBodyItem.Builder)item, azureTestCaseInfo, (int)witId))) {
                keysToRemove.add(witId);
            }
        });
        if (!keysToRemove.isEmpty()) {
            currentBatch.keySet().removeAll(keysToRemove);
        }
    }

    private boolean processUpdateWorkItemBodyFieldsAndDecideToRemove(AzureUpdateWorkItemsBatchReqBodyItem.Builder item, AzureGetWorkItemsBatchResBodyItem azureTestCaseInfo, int witId) {
        Map<String, String> fields = azureTestCaseInfo.getFields();
        boolean hasAutomatedTestId = StringUtils.isNotEmpty((CharSequence)fields.get("Microsoft.VSTS.TCM.AutomatedTestId"));
        boolean hasAutomatedTestName = StringUtils.isNotEmpty((CharSequence)fields.get("Microsoft.VSTS.TCM.AutomatedTestName"));
        boolean hasAutomatedTestStorage = StringUtils.isNotEmpty((CharSequence)fields.get("Microsoft.VSTS.TCM.AutomatedTestStorage"));
        if (hasAutomatedTestName || hasAutomatedTestStorage) {
            this.logFieldUpdateSkipped(hasAutomatedTestName, hasAutomatedTestStorage, witId);
        }
        if (hasAutomatedTestId && hasAutomatedTestName && hasAutomatedTestStorage) {
            return true;
        }
        if (hasAutomatedTestId) {
            item.removeBodyOperation("Microsoft.VSTS.TCM.AutomatedTestId");
        }
        if (hasAutomatedTestName) {
            item.removeBodyOperation("Microsoft.VSTS.TCM.AutomatedTestName");
        }
        if (hasAutomatedTestStorage) {
            item.removeBodyOperation("Microsoft.VSTS.TCM.AutomatedTestStorage");
        }
        return false;
    }

    private void logFieldUpdateSkipped(boolean hasAutomatedTestName, boolean hasAutomatedTestStorage, int witId) {
        String pluralText;
        CharSequence[] fieldsExisted;
        if (hasAutomatedTestName && hasAutomatedTestStorage) {
            fieldsExisted = new String[]{"Automated test name", "Automated test storage"};
            pluralText = "values in these fields.";
        } else if (hasAutomatedTestName) {
            fieldsExisted = new String[]{"Automated test name"};
            pluralText = "a value in this field.";
        } else {
            fieldsExisted = new String[]{"Automated test storage"};
            pluralText = "a value in this field.";
        }
        LogUtil.logError((String)MessageFormat.format(StringConstants.MSG_ERROR_CANNOT_UPDATE_AZURE_TEST_CASE_ID_DUE_TO_EXISTED_FIELDS, String.join((CharSequence)", ", fieldsExisted), witId, pluralText));
    }

    private Set<String> getLinkedAzureTestCaseIds(TestCaseLogRecord testCaseLogRecord) throws Exception {
        if (testCaseLogRecord == null) {
            return Set.of();
        }
        TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseLogRecord.getId());
        IntegratedEntity testCaseIntegratedEntity = AzureIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCaseEntity);
        if (testCaseIntegratedEntity == null) {
            return Set.of();
        }
        String rawTestCaseIds = (String)testCaseIntegratedEntity.getProperties().get("azure.testcase.ids");
        rawTestCaseIds = AzureReportIntegrationContributionHelper.parseVariablesFromInput(rawTestCaseIds, testCaseLogRecord);
        return EntityTagUtil.parse((String)rawTestCaseIds);
    }

    private AzureUpdateWorkItemsBatchReqBodyItem.Builder createAzureWorkItemBuilderBatch(int azureTestCaseId, TestCaseLogRecord testCaseLogRecord) {
        if (azureTestCaseId < 0 || testCaseLogRecord == null) {
            return null;
        }
        String azureAutomatedTestStorage = testCaseLogRecord.getId();
        String azureAutomatedTestName = testCaseLogRecord.getName();
        if (azureAutomatedTestName.lastIndexOf("/") >= 0) {
            azureAutomatedTestName = azureAutomatedTestName.substring(azureAutomatedTestName.lastIndexOf("/") + 1, azureAutomatedTestName.length());
        }
        String azureAutomatedTestId = testCaseLogRecord.getId();
        return AzureUpdateWorkItemsBatchReqBodyItem.builder().workItemId("" + azureTestCaseId).method(HttpMethod.PATCH).uri(AzureAPIProvider.getWorkItemBatchUri(azureTestCaseId)).headers(Map.of("Content-Type", "application/json-patch+json")).addBodyOperation("Microsoft.VSTS.TCM.AutomatedTestStorage", new AzureOperation(AzureOperationType.add, "/fields/Microsoft.VSTS.TCM.AutomatedTestStorage", azureAutomatedTestStorage)).addBodyOperation("Microsoft.VSTS.TCM.AutomatedTestName", new AzureOperation(AzureOperationType.add, "/fields/Microsoft.VSTS.TCM.AutomatedTestName", azureAutomatedTestName)).addBodyOperation("Microsoft.VSTS.TCM.AutomatedTestId", new AzureOperation(AzureOperationType.add, "/fields/Microsoft.VSTS.TCM.AutomatedTestId", azureAutomatedTestId));
    }

    private Set<String[]> getErrorsFromBulkUpdateResponse(AzureUpdateWorkItemsBatchResBody response, List<AzureUpdateWorkItemsBatchReqBodyItem> workItemBatchList) {
        if (response == null || workItemBatchList == null || workItemBatchList.isEmpty()) {
            return Set.of();
        }
        HashSet<String[]> errors = new HashSet<String[]>();
        if (response.getCount() == workItemBatchList.size()) {
            int index = 0;
            while (index < response.getCount()) {
                AzureUpdateWorkItemsBatchResBodyItem bodyItem = response.getValue().get(index);
                if (bodyItem.getCode() != 200) {
                    String workItemId = workItemBatchList.get(index).getWorkItemId();
                    String errorMessage = this.extractErrorMessageFromBody(bodyItem.getCode(), bodyItem.getBody());
                    errors.add(new String[]{workItemId, errorMessage});
                }
                ++index;
            }
        } else {
            AzureUpdateWorkItemsBatchResBodyItem bodyItem = response.getValue().get(0);
            if (bodyItem.getCode() != 200) {
                String errorMessage = this.extractErrorMessageFromBody(bodyItem.getCode(), bodyItem.getBody());
                String[] stringArray = new String[2];
                stringArray[1] = errorMessage;
                errors.add(stringArray);
            }
        }
        return errors;
    }

    private String extractErrorMessageFromBody(int statusCode, String bodyJson) {
        String statusCodeMsg = "Status code " + statusCode;
        if (StringUtils.isBlank((CharSequence)bodyJson)) {
            return statusCodeMsg;
        }
        try {
            String errorMessage;
            Gson gson = new GsonBuilder().create();
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            Map body = (Map)gson.fromJson(bodyJson, type);
            if (body == null || body.isEmpty()) {
                return statusCodeMsg + " - " + bodyJson;
            }
            Map value = (Map)body.get("value");
            if (value != null && StringUtils.isNotBlank((CharSequence)(errorMessage = (String)value.get("Message")))) {
                return statusCodeMsg + " - " + errorMessage;
            }
            errorMessage = (String)body.get("errorMessage");
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                return statusCodeMsg + " - " + errorMessage;
            }
        }
        catch (Exception exception) {}
        return statusCodeMsg + " - " + bodyJson;
    }

    private void resetArgumentsForKS() {
        if (ProcessUtil.isKRE()) {
            return;
        }
        this.testPlanIds = Collections.emptySet();
        this.testRunName = "";
        this.cliAdoPlanId = new ArrayList<String>();
    }

    public boolean isNeededTrackingData() {
        return true;
    }

    public Map<String, Object> getTrackingProperties() {
        if (this.trackingReport == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        boolean isIntegrationEnabled = this.trackingReport.isIntegrationEnabled();
        properties.put("ado_integration_enabled", isIntegrationEnabled);
        if (isIntegrationEnabled) {
            properties.put("ado_testrun_created", this.trackingReport.isTestRunCreated());
            properties.put("ado_testcases_integrated_count", this.trackingReport.getAdoIntegratedTestCaseCount());
            properties.put("ado_testresults_created_count", this.trackingReport.getAdoCreatedTestResultCount());
        }
        return properties;
    }

    private String getTestSuiteInfoComment(TestSuiteLogRecord logRecord) {
        File executionSettingFile = ReportController.getInstance().getExecutionSettingFile(logRecord.getLogFolder());
        RunConfiguration.setExecutionSettingFile((String)executionSettingFile.getAbsolutePath());
        Object runWith = RunConfiguration.getProperty((String)"Name");
        runWith = runWith == null ? "N/A" : runWith;
        Map generalSettings = RunConfiguration.getExecutionGeneralProperties();
        String executionProfile = generalSettings.getOrDefault("executionProfile", "N/A");
        return MessageFormat.format(AzureMessagesConstants.MSG_COMMENT_TS_INFO_FORMAT, logRecord.getId(), executionProfile, runWith);
    }

    public boolean isIntegrationEnabled() {
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        return settingStore.isIntegrationEnabled();
    }

    public boolean canUploadTestSuiteCollectionReport() {
        AzureSettingStore settingStore = AzureSettingStore.getStore();
        return settingStore.isIntegrationEnabled() && settingStore.isAutoSubmitTestRunEnabled() && settingStore.getIntegratedProject() != null && !settingStore.getIntegratedProject().getId().isEmpty();
    }

    public boolean isAllowedGenerateReport(TestSuiteEntity testSuite) {
        return this.isIntegrationActive(testSuite);
    }

    private static class TestCaseUploadStatistics {
        private int totalTestCases = 0;
        private int skippedTestCases = 0;
        private int uploadedTestCases = 0;

        private TestCaseUploadStatistics() {
        }

        void incrementTotal() {
            ++this.totalTestCases;
        }

        void incrementSkipped() {
            ++this.skippedTestCases;
        }

        void incrementUploaded() {
            ++this.uploadedTestCases;
        }

        boolean hasSkippedTestCases() {
            return this.skippedTestCases > 0;
        }

        void logSummary() {
            if (this.hasSkippedTestCases()) {
                LogUtil.logInfo((String)MessageFormat.format(StringConstants.MSG_INFO_UPLOAD_SUMMARY, this.uploadedTestCases, this.totalTestCases, this.skippedTestCases));
            }
        }
    }
}

