/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.integration;

import com.fasterxml.jackson.core.type.TypeReference;
import com.kms.katalon.core.helper.LogRecordHelper;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.core.testcase.Variable;
import com.kms.katalon.core.testcase.VariableReport;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.integration.azure.constant.StringConstants;
import com.kms.katalon.integration.azure.integration.ZipUtil;
import com.kms.katalon.integration.azure.model.AzureTestAttachment;
import com.kms.katalon.integration.azure.model.AzureTestCaseResult;
import com.kms.katalon.integration.azure.model.AzureTestCaseResultBody;
import com.kms.katalon.integration.azure.model.AzureTestPoint;
import com.kms.katalon.integration.azure.model.TestPointMapper;
import com.kms.katalon.integration.azure.model.TestPointMappers;
import com.kms.katalon.integration.azure.setting.AzureAttachmentSendingType;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import com.kms.katalon.integration.azure.setting.ExecutionStatusHelper;
import com.kms.katalon.integration.azure.setting.ExecutionStatusMapping;
import com.kms.katalon.integration.azure.setting.ReportFormatHelper;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;

public class AzureReportIntegrationContributionHelper {
    public static boolean isUploadedByDefault(List<String> planIdParam, String testRunNameParam, String buildDefIdParam, String releaseDefIdParam) {
        return (planIdParam == null || planIdParam.isEmpty()) && StringUtils.isEmpty((CharSequence)testRunNameParam) && StringUtils.isEmpty((CharSequence)buildDefIdParam) && StringUtils.isEmpty((CharSequence)releaseDefIdParam);
    }

    public static List<AzureTestAttachment> getTestSuiteCollectionAttachments(AzureSettingStore store, TestSuiteCollectionLogRecord collectionLogRecord, List<TestSuiteLogRecord> testSuiteHasFailedOrErrorTestPoints) {
        File[] fileArray;
        if (!store.isIncludeAttachmentEnabled()) {
            return Collections.emptyList();
        }
        List<Object> testSuiteNeededToAttach = new ArrayList();
        testSuiteNeededToAttach = store.getAttachmentSendingType() == AzureAttachmentSendingType.SEND_IF_FAILS ? testSuiteHasFailedOrErrorTestPoints : collectionLogRecord.getTestSuiteRecords();
        File collectionReportFolder = new File(collectionLogRecord.getReportFolder());
        if (!collectionReportFolder.exists() || !collectionReportFolder.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<AzureTestAttachment> azureTestAttachments = new ArrayList<AzureTestAttachment>();
        List<ReportFormatType> reportFormatTypes = store.getAttachmentFileTypes();
        if (reportFormatTypes == null || reportFormatTypes.isEmpty()) {
            return Collections.emptyList();
        }
        if (!testSuiteNeededToAttach.isEmpty()) {
            for (TestSuiteLogRecord testSuiteLogRecord : testSuiteNeededToAttach) {
                List<AzureTestAttachment> testSuiteAttachments = AzureReportIntegrationContributionHelper.getTestSuiteAttachments(store, testSuiteLogRecord, true);
                if (testSuiteAttachments.isEmpty()) continue;
                String zipFileName = (String)StringUtils.defaultIfBlank((CharSequence)new File(testSuiteLogRecord.getLogFolder()).getName(), (CharSequence)testSuiteLogRecord.getName());
                try {
                    File zipTestSuiteReport = AzureReportIntegrationContributionHelper.createTempFile(zipFileName, ".zip");
                    ArrayList<Path> filePaths = new ArrayList<Path>();
                    for (AzureTestAttachment attachment : testSuiteAttachments) {
                        filePaths.add(Paths.get(attachment.getAbsolutePath(), new String[0]));
                    }
                    ZipUtil.compress(filePaths, Paths.get(zipTestSuiteReport.getAbsolutePath(), new String[0]));
                    AzureTestAttachment zippedTestSuiteAttachment = new AzureTestAttachment();
                    zippedTestSuiteAttachment.setFileName(zipTestSuiteReport.getName());
                    zippedTestSuiteAttachment.setStream(Base64.encodeFile((File)zipTestSuiteReport));
                    zippedTestSuiteAttachment.setAbsolutePath(zipTestSuiteReport.getAbsolutePath());
                    azureTestAttachments.add(zippedTestSuiteAttachment);
                }
                catch (IOException error) {
                    LogUtil.logError((Throwable)error, (String)MessageFormat.format(StringConstants.MSG_ERROR_CANNOT_ENCODE_FILE, zipFileName + ".zip"));
                }
            }
        }
        if ((fileArray = collectionReportFolder.listFiles()) == null) {
            return Collections.emptyList();
        }
        ReportFormatHelper helper = new ReportFormatHelper(reportFormatTypes);
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (helper.match(file)) {
                AzureTestAttachment attachment;
                attachment = new AzureTestAttachment();
                attachment.setFileName(file.getName());
                try {
                    attachment.setStream(Base64.encodeFile((File)file));
                    azureTestAttachments.add(attachment);
                }
                catch (IOException iOException) {
                    LogUtil.logError((String)MessageFormat.format(StringConstants.MSG_ERROR_CANNOT_ENCODE_FILE, file.getName()));
                }
            }
            ++n2;
        }
        return azureTestAttachments;
    }

    public static List<AzureTestAttachment> getTestSuiteAttachments(AzureSettingStore store, TestSuiteLogRecord suiteLogRecord, boolean hasFailedOrErrorTestPoints) {
        if (!store.isIncludeAttachmentEnabled()) {
            return Collections.emptyList();
        }
        if (store.getAttachmentSendingType() == AzureAttachmentSendingType.SEND_IF_FAILS && !hasFailedOrErrorTestPoints) {
            return Collections.emptyList();
        }
        List<ReportFormatType> reportFormatTypes = store.getAttachmentFileTypes();
        if (reportFormatTypes == null || reportFormatTypes.isEmpty()) {
            return Collections.emptyList();
        }
        File logFolder = new File(suiteLogRecord.getLogFolder());
        if (!logFolder.exists() || !logFolder.isDirectory()) {
            return Collections.emptyList();
        }
        File[] childFiles = logFolder.listFiles();
        if (childFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<AzureTestAttachment> azureTestAttachments = new ArrayList<AzureTestAttachment>();
        ReportFormatHelper helper = new ReportFormatHelper(reportFormatTypes);
        File[] fileArray = childFiles;
        int n = childFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (helper.match(file)) {
                AzureTestAttachment attachment = new AzureTestAttachment();
                try {
                    if (file.isFile()) {
                        attachment.setStream(Base64.encodeFile((File)file));
                        attachment.setFileName(file.getName());
                        attachment.setAbsolutePath(file.getAbsolutePath());
                    } else {
                        Path tempFolder = Files.createTempDirectory("katalon-ado", new FileAttribute[0]);
                        File tempFile = new File(tempFolder.toFile(), file.getName() + ".zip");
                        ZipUtil.compressFolder(tempFile, file);
                        attachment.setStream(Base64.encodeFile((File)tempFile));
                        attachment.setFileName(tempFile.getName());
                        attachment.setAbsolutePath(tempFile.getAbsolutePath());
                    }
                    if (StringUtils.isNotBlank((CharSequence)attachment.getFileName())) {
                        azureTestAttachments.add(attachment);
                    }
                }
                catch (ZipUtil.FileCompressionException | IOException error) {
                    LogUtil.logError((Throwable)error, (String)MessageFormat.format(StringConstants.MSG_ERROR_CANNOT_ENCODE_FILE, file.getName()));
                }
            }
            ++n2;
        }
        return azureTestAttachments;
    }

    private static File createTempFile(String prefix, String suffix) throws IOException {
        File parent = new File(System.getProperty("java.io.tmpdir"));
        File temp = new File(parent, prefix + suffix);
        if (temp.exists()) {
            temp.delete();
        }
        temp.createNewFile();
        return temp;
    }

    public static String getTestPointsIdString(List<AzureTestPoint> testPoints) {
        return "<" + StringUtils.join((int[])AzureReportIntegrationContributionHelper.getTestPointsIds(testPoints), (char)',') + ">";
    }

    private static int[] getTestPointsIds(List<AzureTestPoint> testPoints) {
        int[] testPointsIds = new int[testPoints.size()];
        int i = 0;
        while (i < testPoints.size()) {
            testPointsIds[i] = testPoints.get(i).getId();
            ++i;
        }
        return testPointsIds;
    }

    public static AzureTestCaseResult[] updateStatusForTestCaseResult(String hostName, TestPointMappers testPointMappers, List<ExecutionStatusMapping> statusMappings, AzureTestCaseResultBody resultBody) {
        TestPointMappers mappers = testPointMappers.copy();
        ArrayList<AzureTestCaseResult> updatedResults = new ArrayList<AzureTestCaseResult>();
        ExecutionStatusHelper helper = new ExecutionStatusHelper(statusMappings);
        int i = 0;
        while (i < resultBody.getCount()) {
            AzureTestCaseResult result = resultBody.getValue()[i];
            TestPointMapper mapper = mappers.getMapper(result.getTestPoint().getId());
            TestCaseLogRecord testCaseLogRecord = mapper.getTestCaseLogRecord();
            result.setState("Completed");
            result.setComputerName(hostName);
            if (testCaseLogRecord != null) {
                long duration;
                TestStatus testStatus = testCaseLogRecord.getStatus();
                if (testStatus != null) {
                    result.setOutcome(helper.getAzureStatus(testCaseLogRecord));
                    if (testStatus.getStatusValue().isError()) {
                        result.setErrorMessage(testCaseLogRecord.getMessage());
                    }
                }
                if ((duration = testCaseLogRecord.getEndTime() - testCaseLogRecord.getStartTime()) > 0L) {
                    result.setDurationInMs(duration);
                }
                mappers.remove(mapper);
                updatedResults.add(result);
            }
            ++i;
        }
        return updatedResults.toArray(new AzureTestCaseResult[updatedResults.size()]);
    }

    public static boolean doesTestSuiteHasFailedOrErrorTestPoints(TestSuiteLogRecord suiteLogRecord, TestPointMappers testPointMappers) throws Exception {
        if (suiteLogRecord == null) {
            return false;
        }
        ILogRecord[] iLogRecordArray = suiteLogRecord.filterFinalTestCasesResult();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord logRecord = iLogRecordArray[n2];
            if (logRecord instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)logRecord;
                boolean isTestCaseFailed = testCaseLogRecord.getStatus().getStatusValue().equals((Object)TestStatus.TestStatusValue.FAILED);
                boolean isTestCaseError = testCaseLogRecord.getStatus().getStatusValue().equals((Object)TestStatus.TestStatusValue.ERROR);
                if (isTestCaseFailed || isTestCaseError) {
                    for (TestPointMapper mapper : testPointMappers.get()) {
                        boolean areTestCasesRunFromTestSuite;
                        TestCaseLogRecord testCaseLog = mapper.getTestCaseLogRecord();
                        boolean foundTestCaseLog = testCaseLog.getId().equals(testCaseLogRecord.getId());
                        boolean bl = areTestCasesRunFromTestSuite = testCaseLog.getParentLogRecord() instanceof TestSuiteLogRecord && testCaseLogRecord.getParentLogRecord() instanceof TestSuiteLogRecord;
                        if (!foundTestCaseLog || !areTestCasesRunFromTestSuite) continue;
                        TestSuiteLogRecord currentTestSuite = (TestSuiteLogRecord)testCaseLogRecord.getParentLogRecord();
                        TestSuiteLogRecord testSuiteOfCurrentTestPoint = (TestSuiteLogRecord)testCaseLog.getParentLogRecord();
                        if (!currentTestSuite.getLogFolder().equals(testSuiteOfCurrentTestPoint.getLogFolder())) continue;
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public static String parseVariablesFromInput(String inputWithVariables, TestCaseLogRecord logRecord) {
        if (!inputWithVariables.contains("$")) {
            return inputWithVariables;
        }
        String rawTestCaseVariables = LogRecordHelper.getProperty((ILogRecord)logRecord, (String)"executionBindingVariables");
        TypeReference<List<VariableReport>> typeReference = new TypeReference<List<VariableReport>>(){};
        List dataBindings = (List)JsonUtil.fromJson((String)rawTestCaseVariables, (Type)typeReference.getType());
        Map<String, String> variables = dataBindings.stream().collect(Collectors.toMap(Variable::getName, VariableReport::getValue));
        StrSubstitutor sub = new StrSubstitutor(variables);
        return AzureReportIntegrationContributionHelper.escapeValueFromListOrStringFormat(sub.replace(inputWithVariables));
    }

    private static String escapeValueFromListOrStringFormat(String value) {
        return value.replace("[", "").replace("]", "").replace("'", "").replace(".0", "");
    }

    public static List<AzureTestPoint> filterTestPointsByConfigurationIdList(List<AzureTestPoint> testPointList, List<Integer> configurationIdList) {
        return testPointList.stream().filter(testPoint -> configurationIdList.contains(testPoint.getConfiguration().getId())).collect(Collectors.toList());
    }
}

