/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.tracking.model;

import com.google.gson.JsonObject;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.session.core.model.KatalonPackage;
import com.kms.katalon.session.core.model.LicenseType;

public class TrackingActivationInfo {
    private String errorMessage;
    private KatalonPackage katalonPackage;
    private LicenseType licenseType;
    private JsonObject properties = new JsonObject();
    private String userId;

    private TrackingActivationInfo(Builder builder) {
        this.userId = builder.userId;
        this.katalonPackage = builder.katalonPackage;
        this.licenseType = builder.licenseType;
        this.errorMessage = builder.errorMessage;
        this.properties = builder.properties != null ? builder.properties : new JsonObject();
    }

    public void addProperty(JsonObject newProperty) {
        JsonUtil.mergeJsonObject((JsonObject)newProperty, (JsonObject)this.properties);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public KatalonPackage getKatalonPackage() {
        return this.katalonPackage;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public JsonObject getProperties() {
        return this.properties;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setKatalonPackage(KatalonPackage katalonPackage) {
        this.katalonPackage = katalonPackage;
    }

    public void setLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType;
    }

    public void setProperties(JsonObject properties) {
        this.properties = properties;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class Builder {
        private String errorMessage;
        private KatalonPackage katalonPackage;
        private LicenseType licenseType;
        private JsonObject properties;
        private String userId;

        public TrackingActivationInfo build() {
            return new TrackingActivationInfo(this);
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder katalonPackage(KatalonPackage katalonPackage) {
            this.katalonPackage = katalonPackage;
            return this;
        }

        public Builder licenseType(LicenseType licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public Builder properties(JsonObject properties) {
            this.properties = properties;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }
    }
}

