/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.tracking.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatStatus;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.util.RecorderPlusSettingUtil;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.KatOneJwtToken;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.SessionExpireSchedule;
import com.kms.katalon.session.core.model.UserInfo;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.tracking.builder.TrackPropertyBuilder;
import com.kms.katalon.tracking.model.EmailConfigurationTrackingInfo;
import com.kms.katalon.tracking.model.ProjectStatistics;
import com.kms.katalon.tracking.model.ReportConfigurationTrackingInfo;
import com.kms.katalon.tracking.model.TestCaseTrackingInfo;
import com.kms.katalon.tracking.model.TestEntityTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteCollectionTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteTrackingInfo;
import com.kms.katalon.tracking.model.TrackingActivationInfo;
import com.kms.katalon.tracking.model.TrackingUsageInfo;
import com.kms.katalon.tracking.osgi.service.IProjectStatisticsCollector;
import com.kms.katalon.tracking.osgi.service.ServiceConsumer;
import com.kms.katalon.tracking.service.EmailTemplateConfigurationTrackingInfo;
import com.kms.katalon.tracking.service.TrackingService;
import com.kms.katalon.util.ExecutionTimeTracker;
import com.kms.katalon.util.ExecutorUtils;
import com.kms.katalon.util.SystemInformationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class Trackings {
    private static final String API_COLLECTION_NAME = "apicollection_name";
    private static final String API_COLLECTION_TYPE = "apicollection_type";
    private static TrackingService trackingService = new TrackingService();
    private static ISessionController sessionController;

    static {
        BundleContext bundleContext = FrameworkUtil.getBundle(Trackings.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ContextInjectionFactory.inject((Object)trackingService, (IEclipseContext)context);
        sessionController = (ISessionController)context.get(ISessionController.class);
    }

    public static void trackOpenApplication(boolean isAnonymous, String runningMode) throws Exception {
        double cpu = 0.0;
        long freePhysicalMemorySize = 0L;
        long totalPhysicalMemorySize = 0L;
        cpu = SystemInformationUtil.getProcessCpuLoad();
        long maxMemory = SystemInformationUtil.getMaxMemory();
        long usedMemory = SystemInformationUtil.getUsedMemory();
        long totalMemory = SystemInformationUtil.getTotalMemory();
        long freeMemory = SystemInformationUtil.getFreeMemory();
        double percentageUsed = SystemInformationUtil.getPercentageUsed();
        freePhysicalMemorySize = SystemInformationUtil.freePhysicalMemorySize();
        totalPhysicalMemorySize = SystemInformationUtil.totalPhysicalMemorySize();
        double percentageUsedFormatted = SystemInformationUtil.getPercentageUsedFormatted();
        Trackings.trackAction("openApplication", isAnonymous, "runningMode", runningMode, "percent_cpu", cpu, "max_memory", maxMemory, "used_memory", usedMemory, "total_memory", totalMemory, "free_memory", freeMemory, "percent_used", percentageUsed, "format_percent_used", percentageUsedFormatted, "freephysicalMemorySize", freePhysicalMemorySize, "totalphysicalMemorySize", totalPhysicalMemorySize);
    }

    public static void trackProjectStatistics(ProjectEntity project, boolean isAnonymous, String runningMode, Boolean smartWaitEnabled) {
        Trackings.trackUsageData(project, isAnonymous, runningMode, "collectStatistics", smartWaitEnabled);
    }

    public static void trackOpenProject(ProjectEntity project, Boolean smartWaitEnabled) {
        ExecutorService trackPool = Executors.newFixedThreadPool(1);
        trackPool.submit(() -> {
            Trackings.trackUsageData(project, false, "gui", "openProject", smartWaitEnabled);
            Trackings.trackOpenObject("project", new Object[0]);
        });
        ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)trackPool);
    }

    public static void trackActivation(LoginMethod loginMethod, boolean isActivateSuccess, String errorMessage) {
        CompletableFuture.runAsync(() -> {
            License license;
            JsonObject propertiesObject = new JsonObject();
            propertiesObject.addProperty("loginMethod", loginMethod.toString());
            propertiesObject.addProperty("activated", Boolean.valueOf(isActivateSuccess));
            JsonObject sessionObject = Trackings.collectSessionInfoForActivation();
            JsonUtil.mergeJsonObject((JsonObject)sessionObject, (JsonObject)propertiesObject);
            Session session = sessionController.getSession();
            TrackingActivationInfo.Builder trackInfoBuilder = new TrackingActivationInfo.Builder().userId((String)StringUtils.defaultIfBlank((CharSequence)Trackings.getEmail(session), (CharSequence)"")).katalonPackage(session.getKatalonPackage()).errorMessage((String)StringUtils.defaultIfBlank((CharSequence)errorMessage, (CharSequence)"")).properties(propertiesObject);
            if (isActivateSuccess && Objects.nonNull(license = session.getLicense())) {
                LicenseType licenseType = license.getLicenseType();
                trackInfoBuilder.licenseType(licenseType);
            }
            trackingService.trackActivation(trackInfoBuilder.build());
        });
    }

    private static void trackUsageData(ProjectEntity project, boolean isAnonymous, String runningMode, String triggeredBy, Boolean smartWaitEnabled) {
        CompletableFuture.runAsync(() -> {
            if (project == null) {
                return;
            }
            if (!trackingService.canSubmitUsageTrackingData()) {
                return;
            }
            try {
                JsonObject propertiesObject = new JsonObject();
                JsonObject statisticsObject = Trackings.collectProjectStatistics(project);
                JsonUtil.mergeJsonObject((JsonObject)statisticsObject, (JsonObject)propertiesObject);
                Session session = sessionController.getSession();
                JsonObject sessionObject = Trackings.collectSessionInfo();
                JsonUtil.mergeJsonObject((JsonObject)sessionObject, (JsonObject)propertiesObject);
                propertiesObject.addProperty("triggeredBy", triggeredBy);
                propertiesObject.addProperty("runningMode", runningMode);
                if (smartWaitEnabled != null) {
                    propertiesObject.addProperty("smart_wait_enabled", smartWaitEnabled);
                }
                TrackingUsageInfo trackInfo = new TrackingUsageInfo.Builder().userId((String)StringUtils.defaultIfBlank((CharSequence)Trackings.getEmail(session), (CharSequence)"")).eventName("Katalon Studio Track").isAnonymous(isAnonymous).eventProperties(propertiesObject).build();
                trackingService.trackUsage(trackInfo);
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
        });
    }

    private static JsonObject collectProjectStatistics(ProjectEntity project) throws Exception {
        IProjectStatisticsCollector collector = ServiceConsumer.getProjectStatisticsCollector();
        String taskName = "Collect project stats";
        ExecutionTimeTracker.getInstance().start(taskName);
        ProjectStatistics statistics = collector.collect(project);
        ExecutionTimeTracker.getInstance().stop(taskName);
        JsonObject statisticsObject = JsonUtil.toJsonObject((Object)statistics);
        return statisticsObject;
    }

    private static JsonObject collectSessionInfo() {
        Account account;
        Session session = sessionController.getSession();
        JsonObject propertiesObject = new JsonObject();
        propertiesObject.addProperty("katalonPackage", session.getKatalonPackage().getValue());
        propertiesObject.addProperty("edition", session.getKatalonEdition().getName());
        License license = session.getLicense();
        if (Objects.nonNull(license)) {
            propertiesObject.addProperty("licenseType", license.getLicenseType().toString());
        }
        propertiesObject.addProperty("os", session.getOs());
        propertiesObject.addProperty("osArch", session.getOsArch());
        propertiesObject.addProperty("osVersion", session.getOsVersion());
        propertiesObject.addProperty("osType", session.getOsType());
        propertiesObject.addProperty("katType", session.getKatType());
        propertiesObject.addProperty("katVersion", session.getKatVersion());
        propertiesObject.addProperty("hostName", session.getHostname());
        Organization organization = session.getOrganization();
        if (Objects.nonNull(organization)) {
            propertiesObject.addProperty("organizationId", Long.toString(organization.getId()));
        }
        if (Objects.nonNull(account = session.getAccount())) {
            propertiesObject.addProperty("accountId", Long.toString(account.getId()));
        }
        propertiesObject.addProperty("machineId", session.getMachineId());
        propertiesObject.addProperty("sessionId", session.getSessionId());
        propertiesObject.addProperty("userKey", session.getUserKey());
        return propertiesObject;
    }

    private static JsonObject collectSessionInfoForActivation() {
        Account account;
        Session session = sessionController.getSession();
        JsonObject propertiesObject = new JsonObject();
        propertiesObject.addProperty("edition", session.getKatalonEdition().getName());
        License license = session.getLicense();
        if (Objects.nonNull(license)) {
            propertiesObject.addProperty("license", license.getLicenseType().toString());
        }
        propertiesObject.addProperty("os", session.getOs());
        propertiesObject.addProperty("osArch", session.getOsArch());
        propertiesObject.addProperty("osType", session.getOsType());
        propertiesObject.addProperty("osVersion", session.getOsVersion());
        propertiesObject.addProperty("katPackage", session.getKatalonPackage().getValue());
        propertiesObject.addProperty("katType", session.getKatType());
        propertiesObject.addProperty("katVersion", session.getKatVersion());
        propertiesObject.addProperty("hostName", session.getHostname());
        Organization organization = session.getOrganization();
        if (Objects.nonNull(organization)) {
            propertiesObject.addProperty("orgId", Long.toString(organization.getId()));
        }
        if (Objects.nonNull(account = session.getAccount())) {
            propertiesObject.addProperty("accountId", Long.toString(account.getId()));
        }
        propertiesObject.addProperty("machineId", session.getMachineId());
        propertiesObject.addProperty("sessionId", session.getSessionId());
        propertiesObject.addProperty("userKey", session.getUserKey());
        return propertiesObject;
    }

    public static void trackOpenFirstTime() {
        CompletableFuture.runAsync(() -> {
            JsonObject propertiesObject = new JsonObject();
            JsonObject sessionObject = Trackings.collectSessionInfo();
            JsonUtil.mergeJsonObject((JsonObject)sessionObject, (JsonObject)propertiesObject);
            TrackingUsageInfo trackInfo = new TrackingUsageInfo.Builder().eventName("Katalon Open First Time").isAnonymous(true).eventProperties(propertiesObject).build();
            trackingService.trackUsage(trackInfo);
        });
    }

    public static void trackSSOEvent(String event) {
        Trackings.trackSSOEvent(event, null);
    }

    public static void trackSSOEvent(String event, String details) {
        Trackings.trackUserAction("ksu_sso_event", "event_name", event, "details", details);
    }

    public static void trackLoginDialogAction(String action, Optional<Boolean> rememberMeEnabled) {
        if (rememberMeEnabled.isPresent()) {
            Trackings.trackUserAction("ksu_login_dialog_action", "action_id", action, "remember_me", rememberMeEnabled.get());
            return;
        }
        Trackings.trackUserAction("ksu_login_dialog_action", "action_id", action);
    }

    public static void trackLoginWithAnotherAccountAction() {
        Trackings.trackUserAction("ksu_login_click_alt_account", new Object[0]);
    }

    public static void trackReloginViaRememberMe(boolean success, SessionExpireSchedule.Reason expireReason, String reloginErrorMessage) {
        String expireReasonString = switch (expireReason) {
            case SessionExpireSchedule.Reason.TOKEN_WILL_EXPIRE_AND_NO_WAY_TO_RENEW, SessionExpireSchedule.Reason.TOKEN_WILL_EXPIRE_AND_FAILED_TO_RENEW -> "session_expired";
            case SessionExpireSchedule.Reason.LICENSE_EXPIRED, SessionExpireSchedule.Reason.LICENSE_ERROR -> "license_expired";
            case SessionExpireSchedule.Reason.USER_IDLE -> "idle_timeout";
            default -> "";
        };
        if (StringUtils.isBlank((CharSequence)reloginErrorMessage)) {
            Trackings.trackUserAction("ksu_login_click_relogin", "success", success, "relogin_reason", expireReasonString);
            return;
        }
        Trackings.trackUserAction("ksu_login_click_relogin", "success", success, "relogin_reason", expireReasonString, "relogin_error_message", reloginErrorMessage);
    }

    public static void trackQuickStartAction(String action) {
        Trackings.trackUserAction("quickStartAction", "userAction", action);
    }

    public static void trackQuickStartOpen() {
        Trackings.trackUserAction("ksu_quick_start_welcome_open", new Object[0]);
    }

    public static void trackQuickStartWelcome1(boolean newUser) {
        Trackings.trackUserAction("ksu_quick_start_welcome_continue", "new_user", newUser);
    }

    public static void trackQuickStartWelcome2(String projectType, String yearsOfExperience, String testingMethodologies) {
        Trackings.trackUserAction("ksu_quick_start_welcome_continue_2", "project_type", projectType, "years_of_experience", yearsOfExperience, "testing_methodologies", testingMethodologies);
    }

    public static void trackQuickStartWelcome3() {
        Trackings.trackUserAction("ksu_quick_start_welcome_continue_3", new Object[0]);
    }

    public static void trackQuickStartWelcomeCreateProject(String projectType) {
        Trackings.trackUserAction("ksu_quick_start_welcome_create_project", "project_type", projectType);
    }

    public static void trackGitLogin() {
        Trackings.trackUserAction("git_login_required", new Object[0]);
    }

    public static void trackOpenProjectSucceeded() {
        Trackings.trackUserAction("open_project_succeeded", new Object[0]);
    }

    public static void trackOpenProjectFailed() {
        Trackings.trackUserAction("open_project_failed", new Object[0]);
    }

    public static void trackQuickStartRecordOpen(String scenario) {
        Trackings.trackUserAction("ksu_quick_start_record_open", "option", scenario);
    }

    public static void trackQuickStartStartRecord(String browser, String scenario, boolean useDefaultBrowser) {
        Trackings.trackUserAction("ksu_quick_start_record_record", "browser", browser, "option", scenario, "useDefaultBrowser", useDefaultBrowser);
    }

    public static void trackQuickRecordSurveySend(String answer, String other) {
        Trackings.trackUserAction("ksu_quick_start_record_survey_send", "answer", answer, "other", other);
    }

    public static void trackQuickRecordSurveyClose() {
        Trackings.trackUserAction("ksu_quick_start_record_survey_close", new Object[0]);
    }

    public static void trackQuickStartGuidingDialog() {
        Trackings.trackUserAction("ksu_quick_start_record_guide", new Object[0]);
    }

    public static void trackQuickRecordLeave() {
        Trackings.trackUserAction("ksu_quick_start_record_leave", new Object[0]);
    }

    public static void trackQuickRecordContinue() {
        Trackings.trackUserAction("ksu_quick_start_record_continue", new Object[0]);
    }

    public static void trackQuickStartRunOpen() {
        Trackings.trackUserAction("ksu_quick_start_run_open", new Object[0]);
    }

    public static void trackQuickStartStartRun(String browser) {
        Trackings.trackUserAction("ksu_quick_start_run_run", "browser", browser);
    }

    public static void trackQuickStartRunPass() {
        Trackings.trackUserAction("ksu_quick_start_passed_run_open", new Object[0]);
    }

    public static void trackQuickStartRunFail() {
        Trackings.trackUserAction("ksu_quick_start_failed_run_open", new Object[0]);
    }

    public static void trackQuickStartWelcomeBack() {
        Trackings.trackUserAction("ksu_quick_start_greeting_old_user_open", new Object[0]);
    }

    public static void trackQuickStartWelcomeBackOpenProject() {
        Trackings.trackUserAction("ksu_quick_start_greeting_old_user_open_project", new Object[0]);
    }

    public static void trackQuickStartWelcomeBackCloneProject() {
        Trackings.trackUserAction("ksu_quick_start_greeting_old_user_clone_git", new Object[0]);
    }

    public static void trackQuickStartWelcomeBackNewProject() {
        Trackings.trackUserAction("ksu_quick_start_greeting_old_user_new_project", new Object[0]);
    }

    public static void trackTourAction(String tourName, String tourAction) {
        Trackings.trackUserAction("ksu_quickstart_tour_action", "tourName", tourName, "tourAction", tourAction);
    }

    public static void trackTourStep(String tourName, String tourStep) {
        Trackings.trackUserAction("ksu_quickstart_tour_step", "tourName", tourName, "tourStep", tourStep);
    }

    public static void trackWebSpy(String browserType) {
        Trackings.trackUserAction("spyWeb", "browserType", browserType, "recorder_plus_option", Trackings.getTrackingValueFromRecorderPlusSetting());
    }

    public static void trackMobileSpy(String deviceType, String appiumVersion, String deviceName, String deviceOsVersion, String remoteServer) {
        Trackings.trackUserAction("spyMobile", "deviceType", deviceType, "appiumVersion", appiumVersion, "deviceName", deviceName, "deviceOsVersion", deviceOsVersion, "remote_server", remoteServer);
    }

    public static void trackWindowsSpy() {
        Trackings.trackUserAction("spyWindows", new Object[0]);
    }

    public static void trackWebRecord(String browserType, boolean useActiveBrowser, String webLocatorConfig) {
        Trackings.trackUserAction("recordWeb", "browserType", browserType, "active", useActiveBrowser, "webLocatorConfig", webLocatorConfig, "recorder_plus_option", Trackings.getTrackingValueFromRecorderPlusSetting());
    }

    public static void trackMobileRecord(String deviceType, String appiumVersion, String deviceName, String deviceOsVersion, String remoteServer) {
        Trackings.trackUserAction("recordMobile", "deviceType", deviceType, "appiumVersion", appiumVersion, "deviceName", deviceName, "deviceOsVersion", deviceOsVersion, "remote_server", remoteServer);
    }

    public static void trackWindowsRecord() {
        Trackings.trackUserAction("recordWindows", new Object[0]);
    }

    public static void trackWindowsNativeRecord() {
        Trackings.trackUserAction("recordWindowsNative", new Object[0]);
    }

    public static void trackNewTestCaseButtonClicked() {
        Trackings.trackUserAction("newTestCaseButtonClicked", new Object[0]);
    }

    public static void trackExecuteTestCase(TestCaseTrackingInfo testCaseTrackingInfo) {
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)testCaseTrackingInfo.getHealingInfo());
        List<Object> properties = TrackPropertyBuilder.create().addProperty("launchMode", testCaseTrackingInfo.getLaunchMode()).addProperty("driver", testCaseTrackingInfo.getDriverType()).addProperty("executionResult", testCaseTrackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(testCaseTrackingInfo.getDuration()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(testCaseTrackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(testCaseTrackingInfo.isTriggerSelfHealing()))).addProperty("execute_from_here", (String)((Object)Boolean.valueOf(testCaseTrackingInfo.isExecuteFromHere()))).addProperty("executed_keyword_types", (String)((Object)testCaseTrackingInfo.getKeywordsUsage())).addProperty("executed_applitools_keywords", (Map<String, Boolean>)testCaseTrackingInfo.isUsingApplitools()).addProperty("test_case_data_binding", (Map<String, Boolean>)testCaseTrackingInfo.isUseDataBinding()).addProperty("recorded_with_testcloud", (Map<String, Boolean>)testCaseTrackingInfo.isRecordedWithTestCloud()).addProperty("testcloud_run_configuration", (Map<String, Boolean>)((Object)testCaseTrackingInfo.getTestCloudRunConfiguration())).addProperty("ai_api_test_case", (Map<String, Boolean>)testCaseTrackingInfo.isAIAPITestCase()).addProperty("testops_accountId", (Map<String, Boolean>)((Object)testCaseTrackingInfo.getTestOpsAccountId())).addProperty("testops_projectId", (Map<String, Boolean>)((Object)testCaseTrackingInfo.getTestOpsProjectId())).addProperty("testcloud_accountId", (Map<String, Boolean>)((Object)testCaseTrackingInfo.getTestCloudAccountId())).addProperty("testcloud_projectId", (Map<String, Boolean>)((Object)testCaseTrackingInfo.getTestCloudProjectId())).addProperty("smart_wait_enabled", (Map<String, Boolean>)testCaseTrackingInfo.isSmartWaitEnabled()).addProperty("origin", (Map<String, Boolean>)((Object)testCaseTrackingInfo.getOrigin())).build();
        if (hasAnySuccessfulSelfHealed) {
            properties.add((Map<String, Boolean>)((Object)"successful_self_healing"));
            properties.add(testCaseTrackingInfo.getHealingInfo());
        }
        if (StringUtils.isNotBlank((CharSequence)testCaseTrackingInfo.getRemoteDomain())) {
            properties.add((Map<String, Boolean>)((Object)"remote_domain"));
            properties.add(testCaseTrackingInfo.getRemoteDomain());
        }
        Trackings.addTrackingAppiumVersionForExecuting(testCaseTrackingInfo, properties);
        Trackings.trackUserAction("executeTestCase", properties.toArray());
    }

    public static void trackCreateOrImportApiCollection(String source, String collectionName, String collectionType) {
        Trackings.trackUserAction("ksu_studio_created_apicollection", "source", source, API_COLLECTION_NAME, collectionName, API_COLLECTION_TYPE, collectionType);
    }

    public static void trackApiCollectionAuthorizationChange(String collectionName, String collectionType) {
        Trackings.trackUserAction("ksu_studio_apicollection_setAuth", API_COLLECTION_NAME, collectionName, API_COLLECTION_TYPE, collectionType);
    }

    private static void addTrackingAppiumVersionForExecuting(TestEntityTrackingInfo info, List<Object> properties) {
        if (info.getAppiumVersion() != null) {
            properties.add("appiumVersion");
            properties.add(info.getAppiumVersion());
        }
    }

    public static void trackExecuteTestSuiteInGuiMode(TestSuiteTrackingInfo testSuiteTrackingInfo) {
        Trackings.trackExecuteTestSuite(testSuiteTrackingInfo, "gui");
    }

    public static void trackExecuteTestSuiteInConsoleMode(TestSuiteTrackingInfo testSuiteTrackingInfo) {
        Trackings.trackExecuteTestSuite(testSuiteTrackingInfo, "console");
    }

    private static void trackExecuteTestSuite(TestSuiteTrackingInfo testSuiteTrackingInfo, String runningMode) {
        TrackPropertyBuilder<String, Map<String, Map<String, Integer>>> builder = TrackPropertyBuilder.create().addProperty("runningMode", runningMode).addProperty("driver", testSuiteTrackingInfo.getDriverType()).addProperty("executionResult", testSuiteTrackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(testSuiteTrackingInfo.getDuration()))).addProperty("retryStrategy", testSuiteTrackingInfo.getRetryStrategy()).addProperty("numberOfRerun", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isTriggerSelfHealing()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)testSuiteTrackingInfo.getOrgId())).addProperty("isInCollection", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isInCollection()))).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableVideo()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableHideHostname()))).addProperty("support_level", testSuiteTrackingInfo.getVideoRecordingLevel()).addProperty("num_test_steps", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getNumTestSteps()))).addProperty("executed_keyword_types", (String)((Object)testSuiteTrackingInfo.getKeywordsUsage())).addProperty("executed_test_case_types", testSuiteTrackingInfo.getExecutedTestCaseKeywordTypes()).addProperty("executed_keyword_name", testSuiteTrackingInfo.getExecutedKeywordNames()).addProperty("executed_applitools_keywords", (Map<String, Integer>)testSuiteTrackingInfo.isUsingApplitools()).addProperty("dynamic_test_suite", (Map<String, Integer>)testSuiteTrackingInfo.isDynamicTestSuite()).addProperty("testcloud_tunnel_enabled", (Map<String, Integer>)testSuiteTrackingInfo.getIsTestCloudTunnelEnabled()).addProperty("number_of_emails_sent", (Map<String, Integer>)testSuiteTrackingInfo.getNumberOfEmailsSent()).addProperty("test_case_data_binding", (Map<String, Integer>)testSuiteTrackingInfo.isUseDataBinding()).addProperty("suite_test_case_data_binding", (Map<String, Integer>)testSuiteTrackingInfo.isSuiteTestCaseDataBinding()).addProperty("testcloud_run_configuration", (Map<String, Integer>)((Object)testSuiteTrackingInfo.getTestCloudRunConfiguration())).addProperty("test_suite_collection_id", (Map<String, Integer>)((Object)(testSuiteTrackingInfo.isInCollection() ? testSuiteTrackingInfo.getTestSuiteCollectionId() : ""))).addProperty("testcloud_recorder_test_case_count", (Map<String, Integer>)testSuiteTrackingInfo.getTestcloudRecorderTestCaseCount()).addProperty("ai_api_test_case_count", (Map<String, Integer>)testSuiteTrackingInfo.getNumberOfAIAPITestCase()).addProperty("report_generated", (Map<String, Integer>)((Object)testSuiteTrackingInfo.getReportGenerationTypes())).addProperty("testops_accountId", (Map<String, Integer>)((Object)testSuiteTrackingInfo.getTestOpsAccountId())).addProperty("testops_projectId", (Map<String, Integer>)((Object)testSuiteTrackingInfo.getTestOpsProjectId())).addProperty("testcloud_accountId", (Map<String, Integer>)((Object)testSuiteTrackingInfo.getTestCloudAccountId())).addProperty("testcloud_projectId", (Map<String, Integer>)((Object)testSuiteTrackingInfo.getTestCloudProjectId())).addProperty("smart_wait_enabled", (Map<String, Integer>)testSuiteTrackingInfo.isSmartWaitEnabled()).addProperty("origin", testSuiteTrackingInfo.getOrigin()).addProperty("ai_html_report", (Map<String, Map<String, Integer>>)testSuiteTrackingInfo.getAIHtmlReport()).addProperty("ai_email_report", (Map<String, Map<String, Integer>>)testSuiteTrackingInfo.getAIEmailReport());
        if ("gui".equals(runningMode)) {
            builder.addProperty("launchMode", (Map<String, Map<String, Integer>>)((Object)testSuiteTrackingInfo.getLaunchMode()));
        } else if ("console".equals(runningMode)) {
            builder.addProperty("maxFailedTest", (Map<String, Map<String, Integer>>)testSuiteTrackingInfo.isUsedMaxFailedTestParam()).addProperty("cicd_integration", (Map<String, Map<String, Integer>>)((Object)testSuiteTrackingInfo.getCicdIntegration()));
        }
        List<Object> properties = builder.build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)testSuiteTrackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add((Map<String, Map<String, Integer>>)((Object)"successful_self_healing"));
            properties.add((Map<String, Map<String, Integer>>)((Object)testSuiteTrackingInfo.getHealingInfo()));
        }
        for (Map.Entry<String, Object> entry : testSuiteTrackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)testSuiteTrackingInfo.getRemoteDomain())) {
            properties.add((Map<String, Map<String, Integer>>)((Object)"remote_domain"));
            properties.add(testSuiteTrackingInfo.getRemoteDomain());
        }
        Trackings.addTrackingAppiumVersionForExecuting(testSuiteTrackingInfo, properties);
        if ("gui".equals(runningMode)) {
            Trackings.trackUserAction("executeTestSuite", properties.toArray());
        } else {
            Trackings.trackAction("executeTestSuite", testSuiteTrackingInfo.isAnonymous(), properties.toArray());
        }
    }

    public static void trackExecuteSequentialTestSuiteCollectionInGuiMode(TestSuiteCollectionTrackingInfo trackingInfo) {
        List<Object> properties = TrackPropertyBuilder.create().addProperty("runningMode", "gui").addProperty("total_test_suites", (String)((Object)Integer.valueOf(trackingInfo.getTotalRunTestSuite()))).addProperty("executionResult", trackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(trackingInfo.getDuration()))).addProperty("executionMode", "Sequential").addProperty("numberOfRerun", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isTriggerSelfHealing()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(trackingInfo.isEnableHideHostname()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)trackingInfo.getOrgId())).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(trackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(trackingInfo.isEnableVideo()))).addProperty("support_level", trackingInfo.getVideoRecordingLevel()).addProperty("number_of_emails_sent", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfEmailsSent()))).addProperty("test_suite_collection_id", trackingInfo.getTestSuiteCollectionId()).addProperty("testcloud_recorder_test_case_count", (String)((Object)Integer.valueOf(trackingInfo.getTestcloudRecorderTestCaseCount()))).addProperty("ai_api_test_case_count", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfAIAPITestCase()))).addProperty("report_generated", trackingInfo.getReportGenerationTypes()).addProperty("testops_accountId", trackingInfo.getTestOpsAccountId()).addProperty("testops_projectId", trackingInfo.getTestOpsProjectId()).addProperty("testcloud_accountId", trackingInfo.getTestCloudAccountId()).addProperty("testcloud_projectId", trackingInfo.getTestCloudProjectId()).build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)trackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add("successful_self_healing");
            properties.add(trackingInfo.getHealingInfo());
        }
        for (Map.Entry<String, Object> entry : trackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        Trackings.addTrackingAppiumVersionForExecuting(trackingInfo, properties);
        Trackings.trackUserAction("executeTestSuiteCollection", properties.toArray());
    }

    public static void trackExecuteParallelTestSuiteCollectionInGuiMode(TestSuiteCollectionTrackingInfo trackingInfo) {
        List<Object> properties = TrackPropertyBuilder.create().addProperty("runningMode", "gui").addProperty("executionResult", trackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(trackingInfo.getDuration()))).addProperty("executionMode", "Parallel").addProperty("maxConcurrent", (String)((Object)Integer.valueOf(trackingInfo.getMaxConcurrentInstances()))).addProperty("numberOfRerun", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isTriggerSelfHealing()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(trackingInfo.isEnableHideHostname()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)trackingInfo.getOrgId())).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(trackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(trackingInfo.isEnableVideo()))).addProperty("support_level", trackingInfo.getVideoRecordingLevel()).addProperty("number_of_emails_sent", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfEmailsSent()))).addProperty("test_suite_collection_id", trackingInfo.getTestSuiteCollectionId()).addProperty("testcloud_recorder_test_case_count", (String)((Object)Integer.valueOf(trackingInfo.getTestcloudRecorderTestCaseCount()))).addProperty("ai_api_test_case_count", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfAIAPITestCase()))).addProperty("report_generated", trackingInfo.getReportGenerationTypes()).addProperty("testops_accountId", trackingInfo.getTestOpsAccountId()).addProperty("testops_projectId", trackingInfo.getTestOpsProjectId()).addProperty("testcloud_accountId", trackingInfo.getTestCloudAccountId()).addProperty("testcloud_projectId", trackingInfo.getTestCloudProjectId()).build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)trackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add("successful_self_healing");
            properties.add(trackingInfo.getHealingInfo());
        }
        for (Map.Entry<String, Object> entry : trackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        Trackings.addTrackingAppiumVersionForExecuting(trackingInfo, properties);
        Trackings.trackUserAction("executeTestSuiteCollection", properties.toArray());
    }

    public static void trackExecuteSequentialTestSuiteCollectionInConsoleMode(TestSuiteCollectionTrackingInfo trackingInfo) {
        List<Object> properties = TrackPropertyBuilder.create().addProperty("runningMode", "console").addProperty("total_test_suites", (String)((Object)Integer.valueOf(trackingInfo.getTotalRunTestSuite()))).addProperty("executionResult", trackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(trackingInfo.getDuration()))).addProperty("executionMode", "Sequential").addProperty("numberOfRerun", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isTriggerSelfHealing()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(trackingInfo.isEnableHideHostname()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)trackingInfo.getOrgId())).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(trackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(trackingInfo.isEnableVideo()))).addProperty("support_level", trackingInfo.getVideoRecordingLevel()).addProperty("maxFailedTest", (String)((Object)Boolean.valueOf(trackingInfo.isUsedMaxFailedTestParam()))).addProperty("number_of_emails_sent", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfEmailsSent()))).addProperty("test_suite_collection_id", trackingInfo.getTestSuiteCollectionId()).addProperty("testcloud_recorder_test_case_count", (String)((Object)Integer.valueOf(trackingInfo.getTestcloudRecorderTestCaseCount()))).addProperty("ai_api_test_case_count", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfAIAPITestCase()))).addProperty("cicd_integration", trackingInfo.getCicdIntegration()).addProperty("report_generated", trackingInfo.getReportGenerationTypes()).addProperty("testops_accountId", trackingInfo.getTestOpsAccountId()).addProperty("testops_projectId", trackingInfo.getTestOpsProjectId()).addProperty("testcloud_accountId", trackingInfo.getTestCloudAccountId()).addProperty("testcloud_projectId", trackingInfo.getTestCloudProjectId()).build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)trackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add("successful_self_healing");
            properties.add(trackingInfo.getHealingInfo());
        }
        for (Map.Entry<String, Object> entry : trackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)trackingInfo.getRemoteDomain())) {
            properties.add("remote_domain");
            properties.add(trackingInfo.getRemoteDomain());
        }
        Trackings.addTrackingAppiumVersionForExecuting(trackingInfo, properties);
        Trackings.trackAction("executeTestSuiteCollection", trackingInfo.isAnonymous(), properties.toArray());
    }

    public static void trackExecuteParallelTestSuiteCollectionInConsoleMode(TestSuiteCollectionTrackingInfo trackingInfo) {
        List<Object> properties = TrackPropertyBuilder.create().addProperty("runningMode", "console").addProperty("total_test_suites", (String)((Object)Integer.valueOf(trackingInfo.getTotalRunTestSuite()))).addProperty("executionResult", trackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(trackingInfo.getDuration()))).addProperty("executionMode", "Parallel").addProperty("maxConcurrent", (String)((Object)Integer.valueOf(trackingInfo.getMaxConcurrentInstances()))).addProperty("numberOfRerun", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isTriggerSelfHealing()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(trackingInfo.isEnableHideHostname()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)trackingInfo.getOrgId())).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(trackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(trackingInfo.isEnableVideo()))).addProperty("support_level", trackingInfo.getVideoRecordingLevel()).addProperty("maxFailedTest", (String)((Object)Boolean.valueOf(trackingInfo.isUsedMaxFailedTestParam()))).addProperty("number_of_emails_sent", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfEmailsSent()))).addProperty("test_suite_collection_id", trackingInfo.getTestSuiteCollectionId()).addProperty("testcloud_recorder_test_case_count", (String)((Object)Integer.valueOf(trackingInfo.getTestcloudRecorderTestCaseCount()))).addProperty("ai_api_test_case_count", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfAIAPITestCase()))).addProperty("cicd_integration", trackingInfo.getCicdIntegration()).addProperty("report_generated", trackingInfo.getReportGenerationTypes()).addProperty("testops_accountId", trackingInfo.getTestOpsAccountId()).addProperty("testops_projectId", trackingInfo.getTestOpsProjectId()).addProperty("testcloud_accountId", trackingInfo.getTestCloudAccountId()).addProperty("testcloud_projectId", trackingInfo.getTestCloudProjectId()).build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)trackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add("successful_self_healing");
            properties.add(trackingInfo.getHealingInfo());
        }
        for (Map.Entry<String, Object> entry : trackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)trackingInfo.getRemoteDomain())) {
            properties.add("remote_domain");
            properties.add(trackingInfo.getRemoteDomain());
        }
        Trackings.addTrackingAppiumVersionForExecuting(trackingInfo, properties);
        Trackings.trackAction("executeTestSuiteCollection", trackingInfo.isAnonymous(), properties.toArray());
    }

    public static void trackExecuteFeatureFile(String launchMode, String driverType, String result, long duration, boolean isEnableSelfHealing, boolean isTriggerSelfHealing, String healingInfo, Map<String, Boolean> keywordsUsage) {
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)healingInfo);
        ArrayList<Object> properties = new ArrayList<Object>(Arrays.asList("launchMode", launchMode, "driver", driverType, "executionResult", result, "duration", duration, "enable_self_healing", isEnableSelfHealing, "trigger_self_healing", isTriggerSelfHealing, "executed_keyword_types", keywordsUsage));
        if (hasAnySuccessfulSelfHealed) {
            properties.add("successful_self_healing");
            properties.add(healingInfo);
        }
        Trackings.trackUserAction("executeFeatureFile", properties.toArray());
    }

    public static void trackGenerateCmd() {
        Trackings.trackUserAction("generateCmd", new Object[0]);
    }

    public static void trackQuickOverview(String userClick) {
        Trackings.trackUserAction("quickOverview", "userClick", userClick);
    }

    public static void trackCreatingObject(String objectType, Object ... properties) {
        String action = "new" + StringUtils.capitalize((String)objectType);
        Trackings.trackUserAction(action, properties);
    }

    public static void trackCreatingProject(String newProjectId, ProjectType newProjectType) {
        Trackings.trackUserAction("newProject", "newProjectId", newProjectId, "newProjectType", newProjectType.toString());
    }

    public static void trackCreatingSampleProject(String sampleProjectType, String newProjectId, ProjectType newProjectType) {
        Trackings.trackUserAction("newProject", "sampleProjectType", sampleProjectType, "newProjectId", newProjectId, "newProjectType", newProjectType.toString());
    }

    public static void trackCreatingSampleProject(String sampleProjectType) {
        Trackings.trackUserAction("newProject", "sampleProjectType", sampleProjectType);
    }

    public static void trackOpenDraftRequest(String webServiceType, String openBy) {
        Trackings.trackUserAction("openDraftRequest", "requestType", webServiceType, "openBy", openBy);
    }

    public static void trackOpenObject(String objectType, Object ... properties) {
        String action = "open" + StringUtils.capitalize((String)objectType);
        Trackings.trackUserAction(action, properties);
    }

    public static void trackOpenTestCase(String defaultOpenView) {
        Trackings.trackUserAction("openTestCase", "defaultOpenView", defaultOpenView);
    }

    public static void trackOpenSetDefaultTestCaseView() {
        Trackings.trackOpenObject("SetDefaultTestCaseViewFromTestCase", new Object[0]);
    }

    public static void trackSetDefaultTestCaseView(String defaultView) {
        Trackings.trackUserAction("setDefaultTestCaseView", "defaultView", defaultView);
    }

    public static void trackSaveObject(String objectType) {
        String action = "save" + StringUtils.capitalize((String)objectType);
        Trackings.trackUserAction(action, new Object[0]);
    }

    public static void trackSaveTestCase(String action, boolean isAPITestCase) {
        Trackings.trackUserAction("saveTestCase", "action", action, "ai_api_test_case", isAPITestCase);
    }

    public static void trackSaveTestSuite(int numberOfAiAPITestCase) {
        Trackings.trackUserAction("saveTestSuite", "ai_api_test_case_count", numberOfAiAPITestCase);
    }

    public static void trackEditObject(String objectName, String objectType) {
        String action = "edit" + StringUtils.capitalize((String)objectName);
        if (StringUtils.isNotBlank((CharSequence)objectType)) {
            Trackings.trackUserAction(action, "objectType", objectType);
        } else {
            Trackings.trackUserAction(action, new Object[0]);
        }
    }

    public static void trackOpenHelp(String url) {
        Trackings.trackUserAction("openHelp", "url", url);
    }

    public static void trackOpenWebSpy() {
        Trackings.trackUserAction("openWebSpy", new Object[0]);
    }

    public static void trackOpenMobileSpy(String deviceType, String appiumVersion, String deviceOption) {
        Trackings.trackUserAction("openMobileSpy", "deviceType", deviceType, "appiumVersion", appiumVersion, "deviceOption", deviceOption);
    }

    public static void trackOpenWindowsSpy() {
        Trackings.trackUserAction("openWindowsSpy", new Object[0]);
    }

    public static void trackSaveWebSpy(int numberOfSavedObjects) {
        Trackings.trackUserAction("saveWebSpy", "numberOfSavedObjects", numberOfSavedObjects);
    }

    public static void trackSaveWebSpy(int capturedObjectsNumber, int savedObjectsNumber, int duplicatedObjectsNumber, int duplicatedByObjectsID, int duplicatedByHashedAttributes, String chosenConflictOption, String capturedBy) {
        Trackings.trackUserAction("save_captured_web_object", "capturedObjectsNumber", capturedObjectsNumber, "savedObjectsNumber", savedObjectsNumber, "duplicatedObjectsNumber", duplicatedObjectsNumber, "duplicatedByObjectsID", duplicatedByObjectsID, "duplicatedByHashedAttributes", duplicatedByHashedAttributes, "chosenConflictOption", chosenConflictOption, "capturedBy", capturedBy);
    }

    public static void trackSaveMobileSpy(String deviceType, int numberOfSavedObjects) {
        Trackings.trackUserAction("saveMobileSpy", "deviceType", deviceType, "numberOfSavedObjects", numberOfSavedObjects);
    }

    public static void trackSaveWindowsSpy(int numberOfSavedObjects) {
        Trackings.trackUserAction("saveWindowsSpy", "numberOfSavedObjects", numberOfSavedObjects);
    }

    public static void trackCloseWebSpy() {
        Trackings.trackUserAction("closeWebSpy", new Object[0]);
    }

    public static void trackCloseMobileSpy(String deviceType) {
        Trackings.trackUserAction("closeMobileSpy", "deviceType", deviceType);
    }

    public static void trackCloseWindowsSpy(boolean isCancelled) {
        Trackings.trackUserAction("closeWindowsSpy", "isCancelled", isCancelled);
    }

    public static void trackOpenWebRecord(boolean continueRecording, String webLocatorConfig) {
        Trackings.trackUserAction("openWebRecord", "continue", continueRecording, "webLocatorConfig", webLocatorConfig);
    }

    public static void trackWebRecordStepByContextMenu(String keyword) {
        Trackings.trackUserAction("recordStepByContextMenu", "keyword", keyword);
    }

    public static void trackOpenMobileRecord(String deviceType, String appiumVersion, String deviceOption) {
        Trackings.trackUserAction("openMobileRecord", "deviceType", deviceType, "appiumVersion", appiumVersion, "deviceOption", deviceOption);
    }

    public static void trackOpenWindowsRecord() {
        Trackings.trackUserAction("openWindowsRecord", new Object[0]);
    }

    public static void trackOpenWindowsNativeRecord() {
        Trackings.trackUserAction("openWindowsNativeRecord", new Object[0]);
    }

    public static void trackOpenSelfHealingInsights() {
        Trackings.trackUserAction("openSelfHealingInsights", new Object[0]);
    }

    public static void trackApproveSelfHealingTestObjects(String approvedProposals) {
        Trackings.trackUserAction("approveSelfHealingProposals", "approvedProposals", approvedProposals);
    }

    public static void trackDiscardSelfHealingTestObjects(String discardedProposals) {
        Trackings.trackUserAction("discardSelfHealingProposals", "discardedProposals", discardedProposals);
    }

    public static void trackClickOnSelfHealingInsightsConfigure() {
        Trackings.trackUserAction("ksu_self_healing_insights_configure_click", new Object[0]);
    }

    public static void trackClickOnSelfHealingInsightsHelp() {
        Trackings.trackUserAction("ksu_self_healing_insights_help_click", new Object[0]);
    }

    public static void trackCloseWebRecordByOk(int numberOfTestSteps, String webLocatorConfig) {
        Trackings.trackUserAction("closeWebRecord", "isCancelled", false, "numberOfTestSteps", String.valueOf(numberOfTestSteps), "webLocatorConfig", webLocatorConfig);
    }

    public static void trackCloseWebRecordByCancel(String webLocatorConfig) {
        Trackings.trackUserAction("closeWebRecord", "isCancelled", true, "webLocatorConfig", webLocatorConfig);
    }

    public static void trackCloseMobileRecordByOk(String deviceType, int numberOfTestSteps) {
        Trackings.trackUserAction("closeMobileRecord", "deviceType", deviceType, "isCancelled", false, "numberOfTestSteps", numberOfTestSteps);
    }

    public static void trackCloseMobileRecordByCancel(String deviceType) {
        Trackings.trackUserAction("closeMobileRecord", "deviceType", deviceType, "isCancelled", true);
    }

    public static void trackCloseWindowsRecordByOk(int numberOfRecordedSteps) {
        Trackings.trackUserAction("closeWindowsRecord", "isCancelled", false, "numberOfRecordedSteps", numberOfRecordedSteps);
    }

    public static void trackCloseWindowsRecordByCancel() {
        Trackings.trackUserAction("closeWindowsRecord", "isCancelled", true);
    }

    public static void trackCloseWindowsNativeRecordByOk(int numberOfRecordedSteps) {
        Trackings.trackUserAction("closeWindowsNativeRecord", "isCancelled", false, "numberOfRecordedSteps", numberOfRecordedSteps);
    }

    public static void trackCloseWindowsNativeRecordByCancel() {
        Trackings.trackUserAction("closeWindowsNativeRecord", "isCancelled", true);
    }

    public static void trackWebRecordRunSteps(String type) {
        Trackings.trackUserAction("recordRunSteps", "type", type);
    }

    public static void trackImportKeywords(String type) {
        Trackings.trackUserAction("importKeywords", "type", type);
    }

    public static void trackExportKeywords() {
        Trackings.trackUserAction("exportKeywords", new Object[0]);
    }

    public static void trackForumSearch(String keyword) {
        Trackings.trackUserAction("forumSearch", "keyword", keyword);
    }

    public static void trackQuickDiscussion(String option) {
        Trackings.trackUserAction("quickDiscussion", "quickDiscussionOption", option);
    }

    public static void trackOpenKAIntegration(String objectType) {
        Trackings.trackUserAction("openKAIntegration", "type", objectType);
    }

    public static void trackAddNewTestStep(String stepType) {
        Trackings.trackUserAction("newTestStep", "type", stepType);
    }

    public static void trackTestWebServiceObject(boolean withVerification, boolean isDraftRequest, String authorizationType, boolean isValidatedJsonAgainstSchema, boolean isValidatedXMLAgainstSchema, boolean isValidatedGraphQLAgainstSchema, boolean isValidatedOpenApiAgainstSpecification, String requestType) {
        Trackings.trackUserAction("testWebServiceObject", "verify", withVerification, "isDraft", isDraftRequest, "authorization_type", authorizationType, "validated_json_against_schema", isValidatedJsonAgainstSchema, "validated_xml_against_schema", isValidatedXMLAgainstSchema, "validated_graphql_request_against_schema", isValidatedGraphQLAgainstSchema, "validated_open_api_against_specification", isValidatedOpenApiAgainstSpecification, "request_type", requestType);
    }

    public static void trackAddApiVariable() {
        Trackings.trackUserAction("addApiVariable", new Object[0]);
    }

    public static void trackOpenImportingSwagger() {
        Trackings.trackUserAction("openImportingSwagger", new Object[0]);
    }

    public static void trackClickTestCloudConfiguration() {
        Trackings.trackUserAction("ksu_click_testcloud_configuration", new Object[0]);
    }

    public static void trackClickExecuteTestSuiteWithTestCloud() {
        Trackings.trackUserAction("ksu_click_execute_test_suite_by_testcloud", new Object[0]);
    }

    public static void trackClickExecuteTestSuiteCollectionWithTestCloud() {
        Trackings.trackUserAction("ksu_click_execute_test_suite_collection_by_testcloud", new Object[0]);
    }

    public static void trackOpenImportingPostman() {
        Trackings.trackUserAction("openImportingPostman", new Object[0]);
    }

    public static void trackOpenImportingWsdl() {
        Trackings.trackUserAction("openImportingWSDL", new Object[0]);
    }

    public static void trackImportSwagger(String importType) {
        Trackings.trackUserAction("importSwagger", "type", importType);
    }

    public static void trackImportPostman(String importType) {
        Trackings.trackUserAction("importPostman", "type", importType);
    }

    public static void trackImportWSDL(String importType) {
        Trackings.trackUserAction("importWSDL", "type", importType);
    }

    public static void trackImportOpenApi3(String importType) {
        Trackings.trackUserAction("importOpenApi3", "type", importType);
    }

    public static void trackImportOpenApi(String importType, boolean importedSuccessfuly, String importError, String openApiVersion, boolean isUsedAI) {
        Trackings.trackUserAction("importOpenApi", "type", importType, "imported_successfully", importedSuccessfuly, "import_error", importError, "import_open_api", openApiVersion, "ai_test_generation_enabled", isUsedAI);
    }

    public static void trackImportSoapUI(String importType) {
        Trackings.trackUserAction("importSoapUI", "type", importType);
    }

    public static void trackClickSavingDraftRequest() {
        Trackings.trackUserAction("clickSavingDraftRequest", new Object[0]);
    }

    public static void trackSaveDraftRequest() {
        Trackings.trackUserAction("saveDraftRequest", new Object[0]);
    }

    public static void trackClickDeletingDraftRequest() {
        Trackings.trackUserAction("clickDeletingDraftRequest", new Object[0]);
    }

    public static void trackDeleteDraftRequest(int numberOfDeletedRequests) {
        Trackings.trackUserAction("deleteDraftRequest", "deletedRequestCount", numberOfDeletedRequests);
    }

    public static void trackClickAddingRequestToTestCase(boolean addToNewTestCase) {
        Trackings.trackUserAction("clickAddingRequestToTestCase", "addType", addToNewTestCase ? "new" : "existing");
    }

    public static void trackAddRequestToTestCase(boolean addToNewTestCase) {
        Trackings.trackUserAction("addRequestToTestCase", "addType", addToNewTestCase ? "new" : "existing");
    }

    public static void trackOpenTwitterDialog() {
        Trackings.trackUserAction("openTwitterDialog", new Object[0]);
    }

    public static void trackUserResponseForTwitterDialog(String option) {
        Trackings.trackUserAction("responseTwitterDialog", "type", option);
    }

    public static void trackOpenLinkedJiraIssuesDialog() {
        Trackings.trackUserAction("openLinkedJiraIssuesDialog", new Object[0]);
    }

    public static void trackClickCreateNewJiraIssue() {
        Trackings.trackUserAction("clickCreateNewJiraIssue", new Object[0]);
    }

    public static void trackClickCreateJiraSubIssue() {
        Trackings.trackUserAction("clickCreateSubJiraIssue", new Object[0]);
    }

    public static void trackClickLinkToExistingJiraIssue() {
        Trackings.trackUserAction("clickLinkToExistingJiraIssue", new Object[0]);
    }

    public static void trackClickHarLink() {
        Trackings.trackUserAction("clickHarLink", new Object[0]);
    }

    public static void trackInAppSurveyRatingAndIdea(int numberOfStars, String userIdea) {
        Trackings.trackUserAction("katalonStudioSurvey", "star", numberOfStars, "content", userIdea);
    }

    public static void trackInAppSurveyWillContinueToUse(boolean willContinueToUse, String quitUsingReason) {
        Trackings.trackUserAction("willContinueToUseSurvey", "willContinueToUse", willContinueToUse, "quitUsingReason", quitUsingReason);
    }

    public static void trackQuitSurvey2Open() {
        Trackings.trackUserAction("quit_survey_version_2_opened", new Object[0]);
    }

    public static void trackQuitSurvey2Action(String action) {
        Trackings.trackUserAction("quit_survey_version_2_clicked", "userAction", action);
    }

    public static void trackQuitSurvey2Close() {
        Trackings.trackUserAction("quit_survey_version_2_close", new Object[0]);
    }

    public static void trackQuitSurvey2SendAnswer(String answer, String comment) {
        Trackings.trackUserAction("quit_survey_version_2_send", "answer", answer, "comment", comment);
    }

    public static void trackDownloadPlugin(String apiKey, long pluginId, String pluginName, String pluginVersion, RunningMode runningMode) {
        apiKey = StringUtils.isNotBlank((CharSequence)apiKey) ? apiKey : "";
        Trackings.trackUserAction("downloadPlugin", "apiKey", apiKey, "pluginId", pluginId, "pluginName", pluginName, "pluginVersion", pluginVersion, "runningMode", runningMode.toString());
    }

    public static void trackInstallPlugins(List<Long> installedPluginIds, String apiKey, RunningMode runningMode) {
        Trackings.trackUserAction("installPlugins", "pluginIdList", JsonUtil.toJson(installedPluginIds), "apiKey", StringUtils.isNotBlank((CharSequence)apiKey) ? apiKey : "", "runningMode", runningMode.toString());
    }

    public static void trackUsePrivatePlugins(int customKeywordPluginCount, int idePluginCount) {
        Trackings.trackUserAction("usePrivatePlugin", "customKeywordPluginsCount", customKeywordPluginCount, "idePluginsCount", idePluginCount);
    }

    public static void trackOpenExportTestArtifactsDialog() {
        Trackings.trackUserAction("openExportTestArtifactsDialog", new Object[0]);
    }

    public static void trackOpenImportTestArtifactsDialog() {
        Trackings.trackUserAction("openImportTestArtifactsDialog", new Object[0]);
    }

    public static void trackOpenConsoleView() {
        Trackings.trackUserAction("openConsoleView", new Object[0]);
    }

    public static void trackGitOperation(String operationName, String protocol) {
        Trackings.trackUserAction("performGitOperation", "operationName", operationName, "protocol", protocol);
    }

    public static void trackUseSourceCodeForDebugging(String className) {
        Trackings.trackUserAction("useSourceCodeForDebugging", "className", className);
    }

    public static void trackUseDatabaseConnectionForEnterpriseAccount(String dataSourceType) {
        Trackings.trackUserAction("useDatabaseConnectionForEnterpriseAccount", "type", dataSourceType);
    }

    public static void trackUseAdditionalTestDataSource() {
        Trackings.trackUserAction("useAdditionalTestDataSource", new Object[0]);
    }

    public static void trackUnauthorizedAccessOfKSEFeatures(ProductFeature feature) {
        Trackings.trackUserAction("unauthorizedAccessKSEFeature", "featureKey", feature.toString());
    }

    public static void trackOpenKSEBrochurePage() {
        Trackings.trackUserAction("openKSEBrochurePage", new Object[0]);
    }

    public static void trackFailedToSpyRecordDueToOutdatedChromeDriver() {
        Trackings.trackUserAction("failedToSpyRecordDueToOutdatedChromeDriver", new Object[0]);
    }

    public static void trackFailedToSpyRecordDueToOutdatedEdgeChromiumDriver() {
        Trackings.trackUserAction("failedToSpyRecordDueToOutdatedEdgeChromiumDriver", new Object[0]);
    }

    public static void trackUseAutoUpdateChromeDriver() {
        Trackings.trackUserAction("autoUpdateChromeDriver", new Object[0]);
    }

    public static void trackUseAutoUpdateEdgeChromiumDriver() {
        Trackings.trackUserAction("autoUpdateEdgeChromiumDriver", new Object[0]);
    }

    public static void trackClickOnExceptionDocInLogViewer(String link) {
        Trackings.trackUserAction("clickOnExceptionLinkInLogViewer", "link", link);
    }

    public static void trackTroubleshootFailedActivation(String email, String errorMessage) {
        Trackings.trackAction("troubleshoot-failed-activation", true, "email", email, "errorMessage", errorMessage);
    }

    public static void trackOpenDecompilerEditor() {
        Trackings.trackUserAction("open_decompiler_editor", new Object[0]);
    }

    public static void trackClickUseDefaultClassFileEditor() {
        Trackings.trackUserAction("click_use_default_class_file_editor", new Object[0]);
    }

    public static void trackClassFileEditorChanged(String classFileEditor, String classFileNoSourceEditor) {
        Trackings.trackUserAction("change_class_file_editor", "classFileEditor", classFileEditor, "classFileNoSourceEditor", classFileNoSourceEditor);
    }

    public static void trackStudioAssistFeedback(int numStars, String feedback) {
        Trackings.trackUserAction("studioassist_feedback", "num_of_stars", numStars, "feedback_text", feedback);
    }

    public static void trackStudioAssistUsage(String actionType, String configType) {
        Trackings.trackUserAction("ksu_click_studioassist", "studioassist_action", actionType, "studioassist_config", configType);
    }

    public static void trackStudioAssistConfig(List<Object> trackingData) {
        Trackings.trackUserAction("ksu_studioassist_configuration", trackingData.toArray());
    }

    public static void trackStudioAssistPromptLibraryConfig(List<Object> trackingData) {
        Trackings.trackUserAction("ksu_studioassist_prompt_library_configuration", trackingData.toArray());
    }

    public static void trackOpenStudioAssistChat(String triggerMethod, String pageState, String configType, String chatMode) {
        if (StudioAssistChatStatus.AVAILABLE.toString().equals(pageState)) {
            Trackings.trackUserAction("ksu_studioassist_chat", "studioassist_chat_action", "OPEN_CHAT", "studioassist_trigger", triggerMethod, "studioassist_chat_page_state", pageState, "studioassist_config", configType, "chat_mode", chatMode.toLowerCase());
        } else {
            Trackings.trackUserAction("ksu_studioassist_chat", "studioassist_chat_action", "OPEN_CHAT", "studioassist_trigger", triggerMethod, "studioassist_chat_page_state", pageState, "studioassist_config", configType);
        }
    }

    public static void trackCloseStudioAssistChat(List<Object> trackingData) {
        Trackings.trackUserAction("ksu_studioassist_chat", trackingData.toArray());
    }

    public static void trackStudioAssistChat(List<Object> trackingData) {
        Trackings.trackUserAction("ksu_studioassist_chat", trackingData.toArray());
    }

    public static void trackStudioAssistAgentSetting(List<Object> trackingData) {
        Trackings.trackUserAction("studioassist_mcp_setting", trackingData.toArray());
    }

    public static void trackMobileDefaultLocator(String mobileLocator) {
        Trackings.trackUserAction("ksu_mobile_default_locator", "default_mobile_locator", mobileLocator);
    }

    private static void trackUserAction(String actionName, Object ... properties) {
        Trackings.trackAction(actionName, false, properties);
    }

    private static void trackAction(String actionName, boolean isAnonymous, Object ... properties) {
        CompletableFuture.runAsync(() -> {
            if (!trackingService.canSubmitUsageTrackingData()) {
                return;
            }
            JsonObject propertiesObject = new JsonObject();
            propertiesObject.addProperty("action", actionName);
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            if (currentProject != null) {
                propertiesObject.addProperty("projectId", currentProject.getUUID());
                propertiesObject.addProperty("projectType", currentProject.getType().toString());
            }
            if (properties != null) {
                JsonUtil.mergeJsonObject((JsonObject)Trackings.createJsonObject(properties), (JsonObject)propertiesObject);
            }
            Session session = sessionController.getSession();
            JsonObject sessionObject = Trackings.collectSessionInfo();
            JsonUtil.mergeJsonObject((JsonObject)sessionObject, (JsonObject)propertiesObject);
            TrackingUsageInfo trackInfo = new TrackingUsageInfo.Builder().userId((String)StringUtils.defaultIfBlank((CharSequence)Trackings.getEmail(session), (CharSequence)"")).eventName("Katalon Studio Used").isAnonymous(isAnonymous).eventProperties(propertiesObject).build();
            trackingService.trackUsage(trackInfo);
        });
    }

    private static JsonObject createJsonObject(Object ... properties) {
        JsonObject jsonObject = new JsonObject();
        if (properties != null) {
            int i = 0;
            while (i < properties.length - 1) {
                String key = (String)properties[i];
                Object value = properties[i + 1];
                if (value instanceof Character) {
                    jsonObject.addProperty(key, (Character)value);
                } else if (value instanceof String) {
                    jsonObject.addProperty(key, (String)value);
                } else if (value instanceof Number) {
                    jsonObject.addProperty(key, (Number)value);
                } else if (value instanceof Boolean) {
                    jsonObject.addProperty(key, (Boolean)value);
                } else if (value instanceof Map) {
                    ArrayList mapAsProperties = new ArrayList();
                    Map valueAsMap = (Map)value;
                    valueAsMap.forEach((keyI, valueI) -> {
                        mapAsProperties.add(keyI);
                        mapAsProperties.add(valueI);
                    });
                    jsonObject.add(key, (JsonElement)Trackings.createJsonObject(mapAsProperties.toArray()));
                }
                i += 2;
            }
        }
        return jsonObject;
    }

    public static void trackClickOnTrialNotification(String message) {
        Trackings.trackUserAction("clickOnTrialNotification", "message", message);
    }

    public static void trackClickOnTrialNotificationButton() {
        Trackings.trackUserAction("clickOnTrialNotificationButton", new Object[0]);
    }

    public static void trackTriggerFixingBrokenTestObjectFromLogViewer() {
        Trackings.trackUserAction("fixBrokenTO_triggeredFromLogViewer", new Object[0]);
    }

    public static void trackTriggerFixingBrokenTestObjectFromReport() {
        Trackings.trackUserAction("fixBrokenTO_triggeredFromReport", new Object[0]);
    }

    public static void trackUsedSpyToFixBrokenTestObject() {
        Trackings.trackUserAction("fixBrokenTO_usingSpyToFixBrokenTestObject", new Object[0]);
    }

    public static void trackCaptureObjectWhenFixingBrokenTestObject() {
        Trackings.trackUserAction("fixBrokenTO_capturedObject", new Object[0]);
    }

    public static void trackUserCancelSaveObjectToRepositoryWhenFixingBrokenTestObjects() {
        Trackings.trackUserAction("fixBrokenTO_cancelSavingToObjectRepository", new Object[0]);
    }

    public static void trackUserSavedObjectToRepositoryWhenFixingBrokenTestObjects() {
        Trackings.trackUserAction("fixBrokenTO_savedToObjectRepository", new Object[0]);
    }

    public static void trackUsersFailedToFixBrokenTestObjectsFeedback(String userAnswer, String userChoiceText) {
        Trackings.trackUserAction("fixBrokenTO_failureSurvey", "userAnswer", userAnswer, "userChoiceText", userChoiceText);
    }

    public static void trackUsersSucceededInFixingBrokenTestObjectsFeedback(String userAnswer) {
        Trackings.trackUserAction("fixBrokenTO_successSurvey", "userAnswer", userAnswer);
    }

    public static void trackClickImportOpenApi3() {
        Trackings.trackUserAction("clickImportOpenApi3", new Object[0]);
    }

    public static void trackClickImportOpenAPI() {
        Trackings.trackUserAction("open_importing_open_api", new Object[0]);
    }

    public static void trackClickImportSeleniumIde() {
        Trackings.trackUserAction("clickImportSeleniumIde", new Object[0]);
    }

    public static void trackImportSeleniumIdeResult(int numTestCases, int numTestSuites) {
        Trackings.trackUserAction("importSeleniumIdeResult", "numOfImportedTestCases", numTestCases, "numOfImportedTestSuites", numTestSuites);
    }

    public static void trackEnableCoordinatesBasedRecording(boolean isEnabled) {
        Trackings.trackUserAction("windowscoordinate_enableCoordinatesBasedRecording", "isEnabled", isEnabled);
    }

    public static void trackCoordinateActionUsed(String actionName) {
        Trackings.trackUserAction("windowscoordinate_coordinateActionRecorded", "usedAction", actionName);
    }

    public static void trackUserSaveScriptWithCoordinatedAction() {
        Trackings.trackUserAction("windowscoordinate_saveScriptWithCoordinateAction", new Object[0]);
    }

    public static void trackTestExplorerActionUsed(String actionName) {
        Trackings.trackUserAction("ksu_testexplorer_clicked", "project_action", actionName);
    }

    public static void trackTestExplorerSampleProject(String projectName) {
        Trackings.trackUserAction("ksu_testexplorer_clicked", "project_action", "sample_project", "sample_project_name", projectName);
    }

    public static void trackStartPageAreaClicked(String area) {
        Trackings.trackUserAction("ksu_startpage_clicked", "area", area);
    }

    public static void trackStartPageLinkClicked(String area, String url) {
        Trackings.trackUserAction("ksu_startpage_clicked", "area", area, "url", url);
    }

    public static void trackClickProtectedGlobalVariable(boolean isProtected) {
        Trackings.trackUserAction("clickProtectedGlobalVariable", "protected", isProtected);
    }

    public static void trackTroubleshootOpenRecentProjectClicked(String cause) {
        Trackings.trackUserAction("openRecentProjectFailed", "cause", cause);
    }

    public static void trackInstallDependencies(boolean result, String step) {
        String sResult = result ? "passed" : "failed";
        List<String> properties = TrackPropertyBuilder.create().addProperty("result", sResult).addProperty("step", result ? null : step).build();
        Trackings.trackUserAction("ksu_install_dependencies", properties.toArray());
    }

    public static void trackInstallWebdriverAgent(boolean result, String step) {
        String sResult = result ? "passed" : "failed";
        List<String> properties = TrackPropertyBuilder.create().addProperty("result", sResult).addProperty("step", result ? null : step).build();
        Trackings.trackUserAction("ksu_install_webdriver_agent", properties.toArray());
    }

    public static void trackAiAPITestGenerationEndpointSelectionScreen(int totalAvaliableEndpoint, int totalSelectedEndpoint, String screenTitle, String action) {
        HashMap<String, String> screenAction = new HashMap<String, String>();
        screenAction.put("current_screen", screenTitle);
        screenAction.put("click", action);
        Trackings.trackUserAction("ksu_ai_api_test_generation", "total_available_endpoint", totalAvaliableEndpoint, "total_selected_endpoint", totalSelectedEndpoint, "screen_action", screenAction);
    }

    public static void trackAiAPITestGenerationGenerateTestCaseScreen(int totalAiApiTestCaseGenerated, int generationPercentage, String generationResult, String screenTitle, String action) {
        HashMap<String, String> screenAction = new HashMap<String, String>();
        screenAction.put("current_screen", screenTitle);
        screenAction.put("click", action);
        Trackings.trackUserAction("ksu_ai_api_test_generation", "total_ai_api_test_case_generated", totalAiApiTestCaseGenerated, "generation_percentage", generationPercentage, "generation_result", generationResult, "screen_action", screenAction);
    }

    public static void trackAiAPITestGenerationHideScreen(String screenTitle, String action) {
        HashMap<String, String> screenAction = new HashMap<String, String>();
        screenAction.put("current_screen", screenTitle);
        screenAction.put("click", action);
        Trackings.trackUserAction("ksu_ai_api_test_generation", "screen_action", screenAction);
    }

    public static void trackAiAPITestGenerationTestCaseSelectionScreen(int totalAiApiTestCaseGenerated, int totalSelectedTestCase, int totalRenamedTestCase, String screenTitle, String action) {
        HashMap<String, String> screenAction = new HashMap<String, String>();
        screenAction.put("current_screen", screenTitle);
        screenAction.put("click", action);
        Trackings.trackUserAction("ksu_ai_api_test_generation", "total_ai_api_test_case_generated", totalAiApiTestCaseGenerated, "total_selected_test_case", totalSelectedTestCase, "total_renamed_test_case", totalRenamedTestCase, "screen_action", screenAction);
    }

    public static void trackEnableFollowRedirectsConfiguration(boolean isFollowRedirectsEnabled) {
        Trackings.trackUserAction("follow_redirects_configuration", "enable_follow_redirect", isFollowRedirectsEnabled);
    }

    private static String getEmail(Session session) {
        KatOneJwtToken jwtToken;
        UserInfo userInfo = session.getUserInfo();
        if (Objects.nonNull(userInfo)) {
            return userInfo.getEmail();
        }
        AuthenticationToken token = session.getKatOneToken();
        if (Objects.nonNull(token) && Objects.nonNull(jwtToken = KatOneJwtToken.parseToken((String)token.getAccessToken()))) {
            return jwtToken.getEmail();
        }
        return "";
    }

    private static String getTrackingValueFromRecorderPlusSetting() {
        if (RecorderPlusSettingUtil.isNewBrowser()) {
            return "new_browser";
        }
        if (RecorderPlusSettingUtil.isActiveBrowser()) {
            return "active_browser";
        }
        return "disabled";
    }

    public static void trackingBetaFeaturesConfiguration() {
        Trackings.trackUserAction("beta_features_configuration", "recorder_plus_option", Trackings.getTrackingValueFromRecorderPlusSetting());
    }

    public static void trackReportConfigurationApply(ReportConfigurationTrackingInfo reportConfigurationTrackingInfo) {
        List<String> properties = TrackPropertyBuilder.create().addProperty("report_type", reportConfigurationTrackingInfo.getReportType()).addProperty("apply_new_template", (String)((Object)Optional.ofNullable(reportConfigurationTrackingInfo.isApplyNewTemplate()).orElse(false))).addProperty("split_html_report", (String)((Object)Optional.ofNullable(reportConfigurationTrackingInfo.isSplitHtmlReport()).orElse(false))).addProperty("split_image_html", (String)((Object)Optional.ofNullable(reportConfigurationTrackingInfo.isSplitImageHtml()).orElse(false))).addProperty("use_analyze_failed_reason_by_ai", (String)((Object)Optional.ofNullable(reportConfigurationTrackingInfo.isUseAnalyzeFailedReasonByAI()).orElse(false))).build();
        Trackings.trackUserAction("report_configuration", properties.toArray());
    }

    public static void trackTestOpsIntegrationSetting(Boolean testopsIntegrationEnabled, Boolean isOverrideAuthentication, Boolean autoUploadReportEnabled, String projectId, String accountId) {
        List<Boolean> properties = TrackPropertyBuilder.create().addProperty("platform_integration_enabled", testopsIntegrationEnabled).addProperty("testops_accountId", (Boolean)((Object)accountId)).addProperty("testops_projectId", (Boolean)((Object)projectId)).addProperty("override_authentication", isOverrideAuthentication).addProperty("auto_upload_report", autoUploadReportEnabled).build();
        Trackings.trackUserAction("testops_integration", properties.toArray());
    }

    public static void trackTestCloudIntegrationSetting(Boolean testopsIntegrationEnabled, Boolean isOverrideAuthentication, Boolean testcloudIntegrationEnabled, String projectId, String accountId) {
        List<Boolean> properties = TrackPropertyBuilder.create().addProperty("platform_integration_enabled", testopsIntegrationEnabled).addProperty("testcloud_integration_enabled", testcloudIntegrationEnabled).addProperty("testcloud_accountId", (Boolean)((Object)accountId)).addProperty("testcloud_projectId", (Boolean)((Object)projectId)).addProperty("override_authentication", isOverrideAuthentication).build();
        Trackings.trackUserAction("testcloud_integration", properties.toArray());
    }

    public static void trackOnboardingTourFeedback(String tourId, int rating, String feedback) {
        Trackings.trackUserAction("knowledgeHub_onboarding_survey: " + tourId + "feedback: " + feedback + "rating: " + rating, new Object[0]);
    }

    public static void trackOnboardingTourStart(String tourId) {
        Trackings.trackUserAction("knowledgeHub_onboarding_tour_start", "tourId", tourId);
    }

    public static void trackOnboardingTourComplete(String tourId) {
        Trackings.trackUserAction("knowledgeHub_onboarding_tour_completed", "tourId", tourId);
    }

    public static void trackOnboardingTourExit(String tourId, boolean isExited) {
        String action = isExited ? "exit_tour" : "resume";
        Trackings.trackUserAction("knowledgeHub_onboarding_tour_exit", "tourId", tourId, "user_selection", action);
    }

    public static void trackOnboardingTourCompletedStep(String stepId, String tourId) {
        Trackings.trackUserAction("knowledgeHub_onboarding_tour_completed_step", "step", stepId, "tourId", tourId);
    }

    public static void trackNavigateToTour(String tourId) {
        Trackings.trackUserAction("knowledgeHub", "tourId", tourId);
    }

    public static void trackEmailConfiguration(EmailConfigurationTrackingInfo emailConfigurationTrackingInfo) {
        List<Boolean> properties = TrackPropertyBuilder.create().addProperty("send_email_enabled", emailConfigurationTrackingInfo.isSendEmailEnabled()).addProperty("email_attachment", (Boolean)((Object)emailConfigurationTrackingInfo.getEmail_attachment())).addProperty("use_analyze_failed_reason_by_ai", Optional.ofNullable(emailConfigurationTrackingInfo.isUseAnalyzeFailedReasonByAI()).orElse(false)).build();
        Trackings.trackUserAction("email_configuration", properties.toArray());
    }

    private static void trackEmailTemplateConfiguration(EmailTemplateConfigurationTrackingInfo trackingInfo, String eventName) {
        List<Boolean> properties = TrackPropertyBuilder.create().addProperty("modify_email_template", trackingInfo.isModifyEmailTemplate()).addProperty("restore_default", trackingInfo.isRetoreDefault()).addProperty("email_variables_used", (Boolean)((Object)trackingInfo.getEmailVariablesUsed())).addProperty("preview_clicked", trackingInfo.isPreviewClicked()).build();
        Trackings.trackUserAction(eventName, properties.toArray());
    }

    public static void trackTestSuiteEmailTemplateConfiguration(EmailTemplateConfigurationTrackingInfo trackingInfo) {
        Trackings.trackEmailTemplateConfiguration(trackingInfo, "email_test_suite_template");
    }

    public static void trackTestSuiteCollectionEmailTemplateConfiguration(EmailTemplateConfigurationTrackingInfo trackingInfo) {
        Trackings.trackEmailTemplateConfiguration(trackingInfo, "email_test_suite_collection_template");
    }

    public static void trackSmartWaitConfiguration(boolean isSmartWaitEnabled) {
        List<Boolean> properties = TrackPropertyBuilder.create().addProperty("smart_wait_enabled", isSmartWaitEnabled).build();
        Trackings.trackUserAction("smart_wait_configuration", properties.toArray());
    }

    public static void trackOpenSuiteTestCaseDataBinding() {
        Trackings.trackUserAction("open_suite_test_case_data_binding", new Object[0]);
    }

    public static void trackAutoMigrateSelectRecipes(String recipes) {
        Trackings.trackUserAction("automigrate_script", "automigrate_script_action", "select_recipes", "recipes", recipes);
    }

    public static void trackAutoMigrateCompleted(boolean success, Map<String, Integer> props) {
        HashMap<String, Object> finalProps = new HashMap<String, Object>();
        finalProps.put("automigrate_script_action", "migration_completed");
        finalProps.put("migrate_success", success);
        if (props != null) {
            finalProps.putAll(props);
        }
        Trackings.trackUserAction("automigrate_script", Trackings.buildPropertiesArray(finalProps));
    }

    public static void trackAutoMigrateCancelled(Map<String, Integer> props) {
        HashMap<String, Object> finalProps = new HashMap<String, Object>();
        finalProps.put("automigrate_script_action", "stop");
        if (props != null) {
            finalProps.putAll(props);
        }
        Trackings.trackUserAction("automigrate_script", Trackings.buildPropertiesArray(finalProps));
    }

    public static void trackAutoMigrateReverted(int nRevertedFiles) {
        Trackings.trackUserAction("automigrate_script", "automigrate_script_action", "revert", "reverted_files", nRevertedFiles);
    }

    private static Object[] buildPropertiesArray(Map<String, Object> map) {
        TrackPropertyBuilder<String, Object> builder = TrackPropertyBuilder.create();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            builder.addProperty(entry.getKey(), entry.getValue());
        }
        return builder.build().toArray();
    }
}

