/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.discovery.services;

import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.model.exception.DiscoveryException;
import com.kms.katalon.discovery.core.services.IDiscoveryManager;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.core.model.config.ServerConfig;
import com.kms.katalon.network.core.services.INetworkPreferences;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class DiscoveryManager
implements IDiscoveryManager {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryManager.class);
    @Inject
    IDiscoveryService discoveryService;
    @Inject
    INetworkPreferences networkPreferences;
    boolean isDiscovered = false;

    public Map<ServerType, String> getServerInfo(String serverUrl) throws DiscoveryException {
        return this.discoveryService.getServerInfo(serverUrl);
    }

    public boolean discover(String serverUrl) {
        try {
            ServerConfig serverConfig;
            if (StringUtils.isBlank((CharSequence)serverUrl) && (serverConfig = this.networkPreferences.getServerConfig()) != null) {
                serverUrl = serverConfig.getServerUrl();
            }
            if (StringUtils.isBlank((CharSequence)serverUrl)) {
                serverUrl = "https://testops.katalon.io";
            }
            Map serverUrls = this.discoveryService.getServerInfo(serverUrl);
            this.discoveryService.setServerUrls(serverUrls);
            this.isDiscovered = true;
        }
        catch (DiscoveryException e) {
            logger.error(String.format("Failed to connect to your configured license server address. Temporarily fallen back to the default license server address: %s", serverUrl));
            LogUtil.logError((Throwable)e);
            this.setDefaultUrls(serverUrl);
            this.isDiscovered = false;
        }
        return this.isDiscovered;
    }

    public String getServerUrl(ServerType serverType) {
        return this.discoveryService.getServerUrl(serverType);
    }

    public boolean isDiscovered() {
        return this.isDiscovered;
    }

    public void setServerUrl(ServerType serverType, String serverUrl) {
        this.discoveryService.setServerUrl(serverType, serverUrl);
    }

    public String getDiscoveryServerUrl() {
        String discoveryServerUrl = "https://testops.katalon.io";
        ServerConfig serverConfig = this.networkPreferences.getServerConfig();
        if (serverConfig != null && StringUtils.isNotBlank((CharSequence)serverConfig.getServerUrl())) {
            discoveryServerUrl = serverConfig.getServerUrl();
        }
        return discoveryServerUrl;
    }

    public void setDiscoveryServerUrl(String serverUrl) {
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.setServerUrl(serverUrl);
        try {
            this.networkPreferences.setServerConfig(serverConfig);
        }
        catch (IOException e) {
            logger.error("Failed to save server URL!", (Throwable)e);
        }
    }

    public boolean isOnline() {
        return this.isOnline(this.getDiscoveryServerUrl());
    }

    public boolean isOnline(String serverUrl) {
        if (StringUtils.isNotBlank((CharSequence)serverUrl)) {
            return this.discoveryService.isOnline(serverUrl);
        }
        return false;
    }

    private void setDefaultUrls(String serverUrl) {
        this.discoveryService.setServerUrl(ServerType.ADMIN, serverUrl);
        this.discoveryService.setServerUrl(ServerType.TESTOPS, serverUrl);
        this.discoveryService.setServerUrl(ServerType.TESTCLOUD, "https://testcloud.katalon.com");
        this.discoveryService.setServerUrl(ServerType.PLUGIN_STORE, "https://store.katalon.com");
        this.discoveryService.setServerUrl(ServerType.DOWNLOAD, "https://download.katalon.com");
        this.discoveryService.setServerUrl(ServerType.TRACKING, "https://update.katalon.com");
    }
}

