/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.internal.console;

import com.katalon.platform.api.controller.TestCaseController;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.extension.LauncherOptionParserDescription;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.LauncherOptionParser;
import com.kms.katalon.execution.console.entity.TestSuiteLauncherOptionParser;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.ConsoleLauncher;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.platform.PlatformLauncherOptionParserBuilder;
import com.kms.katalon.execution.util.ConsoleAdapter;
import com.kms.katalon.logging.LogUtil;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class LauncherOptionParserPlatformBuilderImpl
implements PlatformLauncherOptionParserBuilder {
    public LauncherOptionParser getPluginLauncherOptionParser() {
        List<LauncherOptionParserDescription> launcherOptionParserDescriptions = ApplicationManager.getInstance().getExtensionManager().getExtensions("com.katalon.platform.api.extension.launcherOptionParserDescription").stream().filter(a -> a.getImplementationClass() instanceof LauncherOptionParserDescription).map(b -> (LauncherOptionParserDescription)b.getImplementationClass()).collect(Collectors.toList());
        if (launcherOptionParserDescriptions != null && !launcherOptionParserDescriptions.isEmpty()) {
            return new PluginTestSuiteLauncherOptionParser(launcherOptionParserDescriptions);
        }
        return new TestSuiteLauncherOptionParser();
    }

    public class PluginTestSuiteLauncherOptionParser
    extends TestSuiteLauncherOptionParser {
        private List<LauncherOptionParserDescription> pluginLauncherOptionParserDescriptions;

        public PluginTestSuiteLauncherOptionParser(List<LauncherOptionParserDescription> pluginLauncherOptionParserDescriptions) {
            this.pluginLauncherOptionParserDescriptions = pluginLauncherOptionParserDescriptions;
        }

        public List<ConsoleOption<?>> getConsoleOptionList() {
            List allOptions = super.getConsoleOptionList();
            allOptions.addAll(this.pluginLauncherOptionParserDescriptions.stream().map(a -> a.getConsoleOptionList()).map(b -> ConsoleAdapter.adapt((List)b)).flatMap(Collection::stream).collect(Collectors.toList()));
            return allOptions;
        }

        public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
            super.setArgumentValue(consoleOption, argumentValue);
            Optional<LauncherOptionParserDescription> matched = this.pluginLauncherOptionParserDescriptions.stream().filter(b -> b.getConsoleOptionList().stream().map(c -> c.getOption()).collect(Collectors.toList()).contains(consoleOption.getOption())).findFirst();
            if (matched.isPresent()) {
                consoleOption.setValue(argumentValue);
                matched.get().onConsoleOptionDetected(ConsoleAdapter.adapt(consoleOption));
            }
        }

        public IConsoleLauncher getConsoleLauncher(ProjectEntity project, LauncherManager manager) throws InvalidConsoleArgumentException, ExecutionException {
            try {
                TestSuiteEntity clonedTestSuite = TestSuiteLauncherOptionParser.getTestSuite((ProjectEntity)project, (String)((String)this.testSuitePathOption.getValue())).clone();
                clonedTestSuite = this.preExecution(clonedTestSuite);
                AbstractRunConfiguration runConfig = super.internallyBuildRunConfig(project, clonedTestSuite, manager);
                this.notifyRerunSetting(runConfig.getExecutionSetting().getExecutedEntity());
                return new ConsoleLauncher(manager, (IRunConfiguration)runConfig);
            }
            catch (Exception e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        private void notifyRerunSetting(IExecutedEntity executedEntity) {
            TestSuiteExecutedEntity tsExecutedEntity = (TestSuiteExecutedEntity)executedEntity;
            int consoleWidth = 80;
            String retryLabel = ExecutionMessageConstants.MSG_INFO_RETRY_EXECUTION_INFO_LABEL;
            String dashForLabel = StringUtils.repeat((String)"-", (int)((consoleWidth - retryLabel.length()) / 2));
            StringBuilder builder = new StringBuilder().append("\n").append(dashForLabel).append(retryLabel).append(dashForLabel).append("\n");
            builder.append(MessageFormat.format(ExecutionMessageConstants.MSG_INFO_TEST_SUITE, tsExecutedEntity.getEntity().getName()));
            builder.append("\n").append(MessageFormat.format(ExecutionMessageConstants.MSG_INFO_TS_RETRY, tsExecutedEntity.getEntity().getName(), tsExecutedEntity.getRetryStrategy().toString(), tsExecutedEntity.getRemainingRerunTimes()));
            builder.append("\n").append(StringUtils.repeat((String)"-", (int)consoleWidth)).append("\n");
            LogUtil.logInfo((String)builder.toString());
        }

        private TestSuiteEntity preExecution(TestSuiteEntity testSuite) {
            if (testSuite instanceof FilteringTestSuiteEntity) {
                return testSuite;
            }
            TestCaseController testCaseController = (TestCaseController)ApplicationManager.getInstance().getControllerManager().getController(TestCaseController.class);
            com.katalon.platform.api.model.ProjectEntity currentProject = ApplicationManager.getInstance().getProjectManager().getCurrentProject();
            List testCases = testSuite.getTestSuiteTestCaseLinks().stream().map(a -> a.getTestCaseId()).map(b -> {
                try {
                    return testCaseController.getTestCase(currentProject, b);
                }
                catch (ResourceException e) {
                    LogUtil.logError((Throwable)e);
                    return null;
                }
            }).filter(c -> c != null).collect(Collectors.toList());
            List listOfSetsOfTestCases = this.pluginLauncherOptionParserDescriptions.stream().map(a -> a.onPreExecution(testCases)).map(b -> new HashSet(b)).collect(Collectors.toList());
            Set intersection = listOfSetsOfTestCases.stream().collect(() -> new HashSet((Collection)listOfSetsOfTestCases.get(0)), Set::retainAll, Set::retainAll).stream().map(b -> b.getId()).collect(Collectors.toSet());
            testSuite.setTestSuiteTestCaseLinks(testSuite.getTestSuiteTestCaseLinks().stream().filter(a -> intersection.contains(a.getTestCaseId())).collect(Collectors.toList()));
            return testSuite;
        }
    }
}

