/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.composer.core.webview.browserfunction;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.katalon.composer.core.webview.browserfunction.BiRpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.IRpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.JsonRpcRequest;
import com.katalon.composer.core.webview.browserfunction.NoArgRpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.QuadConsumer;
import com.katalon.composer.core.webview.browserfunction.QuadRpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.RpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.TriConsumer;
import com.katalon.composer.core.webview.browserfunction.TriRpcHandlerRegistry;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserFunctionUtil {
    private static final Logger logger = LoggerFactory.getLogger(BrowserFunctionUtil.class);
    private static final String RPC_CALL_FUNCTION_NAME = "onRpcCall";
    private static final int MAX_LOG_LENGTH = 255;
    private static final String EXTENDED_STRING = "...";
    protected static ObjectMapper OBJECT_MAPPER;
    private static final ConcurrentHashMap<String, IRpcHandlerRegistry> HANDLER_REGISTRY_MAP;

    static {
        HANDLER_REGISTRY_MAP = new ConcurrentHashMap();
    }

    protected static synchronized ObjectMapper getObjectMapper() {
        if (OBJECT_MAPPER == null) {
            OBJECT_MAPPER = new ObjectMapper();
            OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        }
        return OBJECT_MAPPER;
    }

    public static void bind(Browser browser) {
        if (browser != null) {
            new BrowserFunction(browser, RPC_CALL_FUNCTION_NAME){

                public Object function(Object[] arguments) {
                    logger.info("Received RPC call from browser | name = {} | arguments = {}", (Object)BrowserFunctionUtil.RPC_CALL_FUNCTION_NAME, (Object)Arrays.toString(arguments));
                    String jsonRpcDataStr = (String)arguments[0];
                    try {
                        JsonRpcRequest jsonRpcRequest = (JsonRpcRequest)BrowserFunctionUtil.getObjectMapper().readValue(jsonRpcDataStr, JsonRpcRequest.class);
                        String methodName = jsonRpcRequest.method();
                        ArrayNode params = jsonRpcRequest.params();
                        IRpcHandlerRegistry handlerRegistry = HANDLER_REGISTRY_MAP.get(methodName);
                        if (handlerRegistry == null) {
                            logger.warn("No handler found for RPC call | name = {} | jsonRpcDataStr = {}", (Object)BrowserFunctionUtil.RPC_CALL_FUNCTION_NAME, (Object)jsonRpcDataStr);
                            return false;
                        }
                        logger.info("Invoking handler for RPC call | name = {} | jsonRpcDataStr = {}", (Object)methodName, (Object)jsonRpcDataStr);
                        handlerRegistry.invoke(params);
                    }
                    catch (JsonProcessingException e) {
                        logger.error("Failed to parse data from browser function | name = %s | jsonRpcDataStr = %s".formatted(BrowserFunctionUtil.RPC_CALL_FUNCTION_NAME, jsonRpcDataStr), (Throwable)e);
                    }
                    return true;
                }
            };
        }
    }

    public static void registerBrowserFunction(String name, Runnable handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null | name = " + name);
        }
        HANDLER_REGISTRY_MAP.put(name, new NoArgRpcHandlerRegistry(name, handler));
    }

    public static <T> void registerBrowserFunction(String name, Class<T> clazzT, Consumer<T> handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (clazzT == null) {
            throw new IllegalArgumentException("clazzT must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        HANDLER_REGISTRY_MAP.put(name, new RpcHandlerRegistry<T>(name, clazzT, handler));
    }

    public static <T> void registerBrowserFunction(String name, TypeReference<T> typeRef, Consumer<T> handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (typeRef == null) {
            throw new IllegalArgumentException("typeRef must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        HANDLER_REGISTRY_MAP.put(name, new RpcHandlerRegistry<T>(name, typeRef, handler));
    }

    public static <T, U> void registerBrowserFunction(String name, Class<T> clazzT, Class<U> clazzU, BiConsumer<T, U> handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (clazzT == null) {
            throw new IllegalArgumentException("clazzT must not be null");
        }
        if (clazzU == null) {
            throw new IllegalArgumentException("clazzU must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        HANDLER_REGISTRY_MAP.put(name, new BiRpcHandlerRegistry<T, U>(name, clazzT, clazzU, handler));
    }

    public static <T, U, V> void registerBrowserFunction(String name, Class<T> clazzT, Class<U> clazzU, Class<V> clazzV, TriConsumer<T, U, V> handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (clazzT == null) {
            throw new IllegalArgumentException("clazzT must not be null");
        }
        if (clazzU == null) {
            throw new IllegalArgumentException("clazzU must not be null");
        }
        if (clazzV == null) {
            throw new IllegalArgumentException("clazzV must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        HANDLER_REGISTRY_MAP.put(name, new TriRpcHandlerRegistry<T, U, V>(name, clazzT, clazzU, clazzV, handler));
    }

    public static <T, U, V, W> void registerBrowserFunction(String name, Class<T> clazzT, Class<U> clazzU, Class<V> clazzV, Class<W> clazzW, QuadConsumer<T, U, V, W> handler) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (clazzT == null) {
            throw new IllegalArgumentException("clazzT must not be null");
        }
        if (clazzU == null) {
            throw new IllegalArgumentException("clazzU must not be null");
        }
        if (clazzV == null) {
            throw new IllegalArgumentException("clazzV must not be null");
        }
        if (clazzW == null) {
            throw new IllegalArgumentException("clazzW must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        HANDLER_REGISTRY_MAP.put(name, new QuadRpcHandlerRegistry<T, U, V, W>(name, clazzT, clazzU, clazzV, clazzW, handler));
    }

    public static void execute(Browser browser, String method, Object ... args) {
        if (browser != null) {
            String argsData = "";
            if (args.length > 0) {
                argsData = Arrays.stream(args).map(value -> {
                    try {
                        return BrowserFunctionUtil.getObjectMapper().writeValueAsString(value);
                    }
                    catch (JsonProcessingException e) {
                        logger.error("Failed to parse data from browser script called | name = %s | value = %s".formatted(method, value), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.joining(","));
            }
            String scriptContent = "%s(%s)".formatted(method, argsData);
            UISynchronizeService.asyncExec(() -> {
                if (!browser.isDisposed()) {
                    logger.info("Executing browser script | scriptContent = {} ", (Object)BrowserFunctionUtil.trimLog(scriptContent));
                    browser.evaluate(scriptContent);
                }
            });
        }
    }

    private static String trimLog(String message) {
        if (message == null) {
            return null;
        }
        if (message.length() <= 255) {
            return message;
        }
        return message.substring(0, 255 - EXTENDED_STRING.length()) + EXTENDED_STRING;
    }
}

