/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.kms.katalon.logging.LogConfigurator;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ActiveEventLogPartHandler {
    private Consumer<ILoggingEvent> logConsumer;
    @Inject
    private IEventBroker eventBroker;
    private Collection<ColorString> bufferredStrings = new ConcurrentLinkedQueue<ColorString>();
    private static ActiveEventLogPartHandler instance;

    @PostConstruct
    public void registerWorkbenchCreated() {
        instance = this;
        this.logConsumer = new Consumer<ILoggingEvent>(){

            @Override
            public void accept(ILoggingEvent event) {
                ActiveEventLogPartHandler.this.onLogEvent(event);
            }
        };
        LogConfigurator.addConsoleLogEventConsumer(this.logConsumer);
        this.eventBroker.subscribe("KATALON_STUDIO/EVENT_LOG/CLEAR_LOG", new EventHandler(){

            public void handleEvent(Event event) {
                ActiveEventLogPartHandler.this.bufferredStrings.clear();
            }
        });
    }

    @PreDestroy
    public void onDestroy() {
        LogConfigurator.removeConsoleLogEventConsumer(this.logConsumer);
    }

    private void onLogEvent(ILoggingEvent event) {
        boolean isError = event.getLevel().isGreaterOrEqual(Level.ERROR);
        this.bufferredStrings.add(new ColorString(event.getFormattedMessage() + "\n", isError));
        this.truncateIfReachMaxSize();
    }

    private void truncateIfReachMaxSize() {
        if (this.bufferredStrings.size() > 1000) {
            ColorString[] bufferredStringAsArray = this.bufferredStrings.toArray(new ColorString[0]);
            bufferredStringAsArray = Arrays.copyOf(bufferredStringAsArray, 1000);
            this.bufferredStrings.clear();
            this.bufferredStrings.addAll(Arrays.asList(bufferredStringAsArray));
        }
    }

    public static ActiveEventLogPartHandler getInstance() {
        return instance;
    }

    public List<ColorString> getBufferredStrings() {
        return new ArrayList<ColorString>(this.bufferredStrings);
    }

    public void clearBufferredStrings() {
        this.bufferredStrings.clear();
    }

    public static class ColorString {
        private final boolean isError;
        private final String string;

        public ColorString(String string, boolean isError) {
            this.string = string;
            this.isError = isError;
        }

        public boolean isError() {
            return this.isError;
        }

        public String getString() {
            return this.string;
        }
    }
}

