/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.impl.handler.AbstractHandler;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.quickstart.QuickStartDialogV3;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.marketing.core.model.G2ReviewSurveyContext;
import com.kms.katalon.marketing.core.model.MarketingSurvey;
import com.kms.katalon.marketing.core.model.SurveyContext;
import com.kms.katalon.marketing.core.sevices.IMarketingService;
import jakarta.inject.Inject;
import java.net.URL;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class OpenG2ReviewDialogHandler
extends AbstractHandler {
    @Inject
    private IMarketingService marketingService;

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.openG2ReviewDialog();
    }

    public void openG2ReviewDialog() {
        if (this.marketingService == null) {
            return;
        }
        try {
            MarketingSurvey marketingSurvey = new MarketingSurvey();
            marketingSurvey = this.marketingService.getSurvey((SurveyContext)new G2ReviewSurveyContext());
            String surveyUrl = marketingSurvey.getSurveyURL();
            if (surveyUrl == null || !this.isValidUrl(surveyUrl)) {
                LogUtil.logInfo((String)"Invalid or missing survey URL.");
                return;
            }
            QuickStartDialogV3 g2ReviewDialog = new QuickStartDialogV3(ShellManager.getMainShell(), marketingSurvey.getDialogWidth(), marketingSurvey.getDialogHeight(), marketingSurvey.isCloseable());
            g2ReviewDialog.create();
            g2ReviewDialog.setUrl(surveyUrl);
            g2ReviewDialog.open();
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Error when start g2 review survey");
            return;
        }
    }

    private boolean isValidUrl(String url) {
        if (url == null || url.trim().isEmpty()) {
            return false;
        }
        try {
            new URL(url);
            return true;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)("Invalid url: " + url));
            return false;
        }
    }
}

