/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.handler.AbstractHandler;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuitHandler
extends AbstractHandler {
    private Logger logger = LoggerFactory.getLogger(QuitHandler.class);

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.execute(null);
    }

    public Object execute(ExecutionEvent executionEvent) {
        return this.openConfirmMessageDialog();
    }

    @Execute
    public boolean openConfirmMessageDialog() {
        boolean confirmed;
        BooleanSupplier closingHook = ProjectController.getInstance().getClosingHook();
        if (closingHook != null && !(confirmed = closingHook.getAsBoolean())) {
            return false;
        }
        ScopedPreferenceStore prefs = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
        MessageDialogWithToggle confirm = MessageDialogWithToggle.open((int)5, (Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.HAND_QUIT_DIA_TITLE, (String)StringConstants.HAND_QUIT_DIA_MSG, (String)StringConstants.HAND_QUIT_DIA_MSG_AUTO_RESTORE_SESSION, (boolean)prefs.getBoolean("general.autoRestorePreviousSession"), (IPreferenceStore)prefs, (String)"general.autoRestorePreviousSession", (int)0);
        if (confirm.getReturnCode() != 0) {
            return false;
        }
        if (this.getPartService() != null && this.getPartService().saveAll(true)) {
            try {
                prefs.setValue("general.autoRestorePreviousSession", confirm.getToggleState());
                ((IPersistentPreferenceStore)prefs).save();
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
            try {
                ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                String projectLoc = project != null ? project.getId() : "";
                ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.project");
                store.setValue("project.latestOpened", projectLoc);
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
        }
        EventBrokerSingleton.getInstance().getEventBroker().send("DEACTIVATION", null);
        EventBrokerSingleton.getInstance().getEventBroker().send("WORKSPACE/CLOSE", null);
        return true;
    }
}

