/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.Collection;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SaveAllHandler {
    @CanExecute
    private boolean canExecute(@Optional EPartService partService) {
        if (partService != null) {
            return !partService.getDirtyParts().isEmpty();
        }
        return false;
    }

    private SavableCompositePart getCompositeParentPart(MPart part, EPartService partService) {
        SavableCompositePart parentCompositePart = null;
        for (MPart dirtyPart : partService.getDirtyParts()) {
            SavableCompositePart compositePart;
            if (!(dirtyPart.getObject() instanceof SavableCompositePart) || (compositePart = (SavableCompositePart)dirtyPart.getObject()).getChildParts() == null || !compositePart.getChildParts().contains(part)) continue;
            return compositePart;
        }
        return parentCompositePart;
    }

    @Execute
    void execute(EPartService partService) {
        try {
            Collection partsToPersist = partService.getDirtyParts();
            for (MPart part : partsToPersist) {
                if (!part.isDirty()) continue;
                if (part.getObject() instanceof SavableCompositePart) {
                    ((SavableCompositePart)part.getObject()).save();
                    continue;
                }
                SavableCompositePart compositeParentPart = this.getCompositeParentPart(part, partService);
                if (compositeParentPart != null) {
                    compositeParentPart.save();
                    continue;
                }
                if (GroovyEditorUtil.isGroovyEditorPart((MPart)part) || GroovyEditorUtil.isJavaEditorPart((MPart)part) || GroovyEditorUtil.isFeatureFileEditorPart((MPart)part)) {
                    GroovyEditorUtil.saveEditor((MPart)part);
                    EventBrokerSingleton.getInstance().getEventBroker().post("EDITORS_SAVED", (Object)part);
                    continue;
                }
                partService.savePart(part, false);
            }
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            project.setModifiedVersion(ApplicationInfo.versionNo());
            project.setModifiedEdition(ApplicationEdition.get());
            ProjectController.getInstance().updateProject(project);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_SAVE_ALL_DIA_MSG);
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

