/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.helpers;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.core.util.ObjectUtil;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PartHelper {
    private PartHelper() {
    }

    private static MApplication getApplication() {
        return ApplicationSingleton.getInstance().getApplication();
    }

    private static EModelService getModelService() {
        return ModelServiceSingleton.getInstance().getModelService();
    }

    public static EPartService getPartService() {
        return PartServiceSingleton.getInstance().getPartService();
    }

    public static String getURI(Class<?> partClass) {
        if (partClass == null) {
            return "";
        }
        Bundle partBundle = FrameworkUtil.getBundle(partClass);
        if (partBundle == null) {
            return "";
        }
        String bundleSymbolicName = partBundle.getSymbolicName();
        String partClassName = partClass.getName();
        return MessageFormat.format("bundleclass://{0}/{1}", bundleSymbolicName, partClassName);
    }

    public static MPart newPart() {
        return (MPart)PartHelper.getModelService().createModelElement(MPart.class);
    }

    public static MPart showPart(String partId) {
        return PartHelper.showPart(partId, EPartService.PartState.ACTIVATE);
    }

    public static MPart showPart(String partId, EPartService.PartState partState) {
        return PartHelper.showPart(PartHelper.findPart(partId), partState);
    }

    public static MPart showPart(MPart part) {
        return PartHelper.showPart(part, EPartService.PartState.ACTIVATE);
    }

    public static MPart showPart(MPart part, EPartService.PartState partState) {
        return PartHelper.getPartService().showPart(part, partState);
    }

    public static void hidePart(String partId) {
        PartHelper.hidePart(partId, false);
    }

    public static void hidePart(String partId, boolean force) {
        PartHelper.hidePart(PartHelper.findPart(partId), force);
    }

    public static void hidePart(MPart part) {
        PartHelper.hidePart(part, false);
    }

    public static void hidePart(MPart part, boolean force) {
        PartHelper.getPartService().hidePart(part, force);
    }

    public static void activatePart(String partId) {
        PartHelper.activatePart(PartHelper.findPart(partId));
    }

    public static void activatePart(MPart part) {
        PartHelper.getPartService().activate(part, true);
    }

    public static void deactivatePart(String partId) {
        PartHelper.getPartService().activate(PartHelper.findPart(partId), false);
    }

    public static void removePart(String partId) {
        PartHelper.removePart(PartHelper.findPart(partId));
    }

    public static void removePart(MPart part) {
        if (part != null && part.getParent() != null) {
            part.getParent().getChildren().remove(part);
            PartHelper.hidePart(part, true);
        }
    }

    public static MPart findPart(String partId, String stackId) {
        MPartStack stack = PartHelper.findStack(stackId);
        return PartHelper.findPart(partId, stack);
    }

    public static MPart findPart(String partId, MPartStack stack) {
        return stack != null ? PartHelper.getModelService().find(partId, (MUIElement)stack) : PartHelper.findPart(partId);
    }

    public static MPart findPart(String partId) {
        return PartHelper.getPartService().findPart(partId);
    }

    public static MPartStack findStack(String stackId) {
        if (StringUtils.isBlank((CharSequence)stackId)) {
            return null;
        }
        return (MPartStack)PartHelper.getModelService().find(stackId, (MUIElement)PartHelper.getApplication());
    }

    public static void appendPart(MPartStack stack, MPart part) {
        if (stack == null || part == null) {
            return;
        }
        stack.getChildren().add(part);
    }

    public static void saveEditorPart(Composite partRenderer) {
        PartHelper.saveEditorPart(partRenderer, "save");
    }

    public static void saveEditorPart(Composite partRenderer, String savingMethodName) {
        Object editorPart = PartHelper.getPartFromRenderer(partRenderer);
        Method method = ObjectUtil.findMethod((Object)editorPart, (String)savingMethodName);
        ObjectUtil.safeInvoke((Object)editorPart, (Method)method);
    }

    public static Object getPartFromRenderer(Composite partRenderer) {
        return ObjectUtil.getField((Object)partRenderer.getData("modelElement"), (String)"object");
    }
}

