/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.helpers;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.util.CommandUtil;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class PerspectiveHelper {
    private static EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
    private static MApplication application = ApplicationSingleton.getInstance().getApplication();
    private static IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();

    public static void switchToPerspective(String perspectiveId) {
        if (application == null || application.getChildren().isEmpty()) {
            LoggerSingleton.logWarn((String)StringConstants.APPLICATION_WINDOW_NOT_FOUND);
            return;
        }
        MWindow window = (MWindow)application.getChildren().get(0);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)modelService.find("com.kms.katalon.composer.perspectiveStack", (MUIElement)window);
        if (perspectiveStack == null) {
            LoggerSingleton.logWarn((String)StringConstants.PERSPECTIVE_STACK_NOT_FOUND);
            return;
        }
        MUIElement currentPerspective = perspectiveStack.getSelectedElement();
        if (currentPerspective != null && perspectiveId.equals(currentPerspective.getElementId())) {
            return;
        }
        MPerspective targetPerspective = (MPerspective)modelService.find(perspectiveId, (MUIElement)window);
        if (targetPerspective == null) {
            LoggerSingleton.logWarn((String)MessageFormat.format(StringConstants.TARGET_PERSPECTIVE_NOT_FOUND, perspectiveId));
            return;
        }
        perspectiveStack.setSelectedElement((MUIElement)targetPerspective);
        if ("com.kms.katalon.composer.perspective.keyword".equals(perspectiveId)) {
            eventBroker.post("EXPLORER/RELOAD_DATA", (Object)false);
        }
        LoggerSingleton.logInfo((String)MessageFormat.format(StringConstants.SWITCH_PERSPECTIVE_SUCCESS, perspectiveId));
    }

    public static void resetPerspective() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        CommandUtil.executeCommand("com.kms.katalon.composer.command.window.resetPerspective");
    }
}

