/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.quickstart;

import com.kms.katalon.composer.components.impl.control.Dropdown;
import com.kms.katalon.composer.components.impl.control.DropdownGroup;
import com.kms.katalon.composer.components.impl.control.DropdownItemSelectionListener;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BrowserSelect
extends ToolBar {
    private WebUIDriverType preferredBrowser = WebUIDriverType.CHROME_DRIVER;
    private ToolItem dropdownSelectedItem;

    public WebUIDriverType getInput() {
        return this.preferredBrowser;
    }

    public void setInput(WebUIDriverType preferredBrowser) {
        this.preferredBrowser = preferredBrowser;
        this.dropdownSelectedItem.setImage(this.getBrowserIcon(preferredBrowser));
    }

    public BrowserSelect(Composite parent, int style) {
        super(parent, style | 0x800000 | 0x20000);
        this.createBrowserSelect(this);
    }

    private void createBrowserSelect(final ToolBar toolbar) {
        toolbar.setBackground(ColorUtil.getToolBarBackgroundColor());
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        toolbar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        final Dropdown dropdown = new Dropdown(toolbar.getShell());
        this.dropdownSelectedItem = new ToolItem(toolbar, 4);
        this.dropdownSelectedItem.setToolTipText("");
        this.dropdownSelectedItem.setImage(this.getBrowserIcon(this.preferredBrowser));
        this.createDropdownContent(dropdown, this.dropdownSelectedItem, browser -> this.dropdownSelectedItem.setImage(this.getBrowserIcon(browser)));
        this.dropdownSelectedItem.addSelectionListener((SelectionListener)new DropdownItemSelectionListener(dropdown){

            public void itemSelected(SelectionEvent event) {
                Point pos = toolbar.toDisplay(0, 0);
                Rectangle rect = toolbar.getBounds();
                dropdown.setLocation(pos.x, pos.y + rect.height);
                dropdown.resizeToFitContent();
                dropdown.setVisible(true);
            }
        });
    }

    private void createDropdownContent(Dropdown dropdown, ToolItem selectedItem, BrowserSelectionCallback itemSelectionListener) {
        DropdownGroup newBrowser = dropdown.addDropdownGroupItem("Browsers", ImageManager.getImage((String)"execution/new_browser_24.png"));
        this.addNewBrowserItem(newBrowser, WebUIDriverType.CHROME_DRIVER, itemSelectionListener);
        this.addNewBrowserItem(newBrowser, WebUIDriverType.FIREFOX_DRIVER, itemSelectionListener);
        this.addNewBrowserItem(newBrowser, WebUIDriverType.EDGE_CHROMIUM_DRIVER, itemSelectionListener);
    }

    private void addNewBrowserItem(DropdownGroup newBrowserGroup, final WebUIDriverType webUIDriverType, final BrowserSelectionCallback itemSelectionListener) {
        Object itemText = webUIDriverType == WebUIDriverType.CHROME_DRIVER ? webUIDriverType.toString() + " (Recommended)" : webUIDriverType.toString();
        newBrowserGroup.addItem((String)itemText, this.getBrowserIcon(webUIDriverType), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserSelect.this.preferredBrowser = webUIDriverType;
                itemSelectionListener.call(webUIDriverType);
            }
        });
    }

    private Image getBrowserIcon(WebUIDriverType webUIDriverType) {
        if (webUIDriverType == null) {
            return ImageManager.getImage((String)"execution/chrome_24.png");
        }
        switch (webUIDriverType) {
            case CHROME_DRIVER: {
                return ImageManager.getImage((String)"execution/chrome_24.png");
            }
            case FIREFOX_DRIVER: {
                return ImageManager.getImage((String)"execution/firefox_24.png");
            }
            case EDGE_CHROMIUM_DRIVER: {
                return ImageManager.getImage((String)"execution/edge_chromium_24.png");
            }
        }
        return null;
    }

    protected void checkSubclass() {
    }

    static interface BrowserSelectionCallback {
        public void call(WebUIDriverType var1);
    }
}

