/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.toolbar;

import com.kms.katalon.composer.components.impl.overlay.ContextMenu;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.handlers.OnboardingHubHandler;
import com.kms.katalon.composer.intro.SupportPortal;
import com.kms.katalon.composer.toolbar.ForumSearchToolControl;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CommunityContextMenuPopover
extends ContextMenu {
    @Inject
    private ISessionController sessionController;
    private static LicenseType licenseType;

    public CommunityContextMenuPopover(Shell parent, Widget target, int style, int preferedPosition) {
        super(parent, target, style, preferedPosition, true);
    }

    protected void createInnerContent(Composite parent) {
        Session session = this.sessionController.getSession();
        License license = session.getLicense();
        licenseType = license.getLicenseType();
        Composite menu = (Composite)ComponentBuilder.menuContainer((Composite)parent).build();
        if (licenseType != LicenseType.FREE) {
            ComponentBuilder.menuItem((Composite)menu).image(ImageConstants.KATALON_SUPPORT_PORTAL_24).text("Support Portal").onClick(event -> {
                new SupportPortal().execute();
                this.fakeClose();
            }).build();
        }
        ComponentBuilder.menuItem((Composite)menu).image(ImageConstants.KATALON_FORUM_24).text("Forum").onClick(event -> {
            new ForumSearchToolControl().execute();
            this.fakeClose();
        }).build();
        if (ApplicationEdition.getOrElse((KatalonEdition)KatalonEdition.FREE).equals((Object)KatalonEdition.ENTERPRISE)) {
            ComponentBuilder.menuItem((Composite)menu).image(ImageConstants.KATALON_ONBOARDING_HUB_48).text("Onboarding Hub").onClick(event -> {
                new OnboardingHubHandler().execute();
                this.fakeClose();
            }).build();
        }
        ComponentUtil.adjustChildrenWidth((Composite)menu, (boolean)false);
    }
}

