/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.update;

import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.components.impl.util.PlatformUtil;
import com.kms.katalon.composer.update.models.AppInfo;
import com.kms.katalon.composer.update.models.ExecInfo;
import com.kms.katalon.composer.update.models.VersionInfo;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.util.internal.ProxyUtil;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.AdministrationManagedKsSetting;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.session.services.SessionController;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;

public class UpdateManager {
    private static final String UPDATE_SITE_ARGUMENT = "updateSite";
    private static final String SERVER_UPDATE_URL = "https://download.katalon.com/update/";
    private static final String LATEST_V10_VERSION_INFO = "latest_v10_version.json";
    private static final String LATEST_FREE_V10_VERSION_INFO = "free/latest_v10_version.json";
    private static final String APP_INFO = "app_info.json";
    private static final String EXEC_INFO = "exec_info.json";
    private static UpdateManager instance;
    private ISessionController sessionController = SessionController.getInstance();

    private UpdateManager() {
    }

    public static UpdateManager getInstance() {
        if (instance == null) {
            instance = new UpdateManager();
        }
        return instance;
    }

    public File getApplicationDir() throws IOException {
        File installLoc = new File(FileLocator.resolve((URL)Platform.getInstallLocation().getURL()).getFile());
        if (PlatformUtil.isMacOS()) {
            return installLoc.getParentFile().getParentFile();
        }
        return installLoc;
    }

    public File getApplicationExecFile() throws IOException {
        File parent = new File(FileLocator.resolve((URL)Platform.getInstanceLocation().getURL()).getFile()).getParentFile();
        String execFileName = PlatformUtil.isWindows() ? "katalon.exe" : "katalon";
        return new File(parent, execFileName);
    }

    public File getUpdateResourcesDir() throws IOException {
        String configurationDir = FileLocator.resolve((URL)Platform.getConfigurationLocation().getURL()).getFile();
        return new File(configurationDir, "resources/update");
    }

    public File getLocalLatestVersionInfoFile() throws IOException {
        String latestVersion = KatalonEdition.ENTERPRISE == ApplicationEdition.get() ? LATEST_V10_VERSION_INFO : LATEST_FREE_V10_VERSION_INFO;
        return new File(this.getUpdateResourcesDir(), latestVersion);
    }

    public VersionInfo getLocalLatestVersion() throws IOException {
        File localLatestVersion = this.getLocalLatestVersionInfoFile();
        if (localLatestVersion.exists()) {
            return (VersionInfo)JsonUtil.fromJson((String)FileUtils.readFileToString((File)localLatestVersion), VersionInfo.class);
        }
        VersionInfo latestVersionInfo = new VersionInfo();
        latestVersionInfo.setLatestVersion(VersionUtil.getCurrentVersion().getVersion());
        return latestVersionInfo;
    }

    public File saveLocalLatestVersionInfo(VersionInfo latestVersion) throws IOException {
        File localLatestVersionFile = this.getLocalLatestVersionInfoFile();
        FileUtils.write((File)localLatestVersionFile, (CharSequence)JsonUtil.toJson((Object)latestVersion));
        return localLatestVersionFile;
    }

    public File getVersionUpdateDir(String version) throws IOException {
        return new File(this.getUpdateResourcesDir(), version);
    }

    private File getUpdaterJarDir() throws IOException {
        return new File(this.getUpdateResourcesDir(), "updater");
    }

    public File getUpdateJar() throws IOException {
        File parentDir = this.getUpdaterJarDir();
        String updaterJarpath = parentDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("updater-") && name.endsWith(".jar");
            }
        })[0];
        return new File(parentDir, updaterJarpath);
    }

    public String getUpdateSiteArgument() {
        String[] args = Platform.getApplicationArgs();
        OptionParser parser = new OptionParser(false);
        parser.allowsUnrecognizedOptions();
        parser.accepts(UPDATE_SITE_ARGUMENT).withOptionalArg();
        OptionSet options = parser.parse(args);
        if (options.has(UPDATE_SITE_ARGUMENT)) {
            return (String)options.valueOf(UPDATE_SITE_ARGUMENT);
        }
        return "";
    }

    public String getServerUrl() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getUpdateSiteArgument(), (CharSequence)SERVER_UPDATE_URL);
    }

    private String addLatestSlash(String rawUrl) {
        return rawUrl.endsWith("/") ? rawUrl : rawUrl + "/";
    }

    public String getLatestVersionUrl() {
        String latestVersion = KatalonEdition.ENTERPRISE == ApplicationEdition.get() ? LATEST_V10_VERSION_INFO : LATEST_FREE_V10_VERSION_INFO;
        return this.addLatestSlash(this.getServerUrl()) + latestVersion;
    }

    public String getVersionUrl(String versionLocation, String platform) {
        return this.addLatestSlash(versionLocation) + platform;
    }

    public String getAppInfoVersionUrl(String versionLocation, String platform) {
        return this.addLatestSlash(this.getVersionUrl(versionLocation, platform)) + APP_INFO;
    }

    public String getFileInfoVersionUrl(String versionLocation, String platform, String fileName) {
        return this.addLatestSlash(this.getVersionUrl(versionLocation, platform)) + fileName;
    }

    public Proxy getProxy() throws URISyntaxException, IOException {
        return ProxyUtil.getProxy((ProxyInformation)ProxyPreferences.getAuthProxyInformation());
    }

    public AppInfo getCurrentVersionLocalAppInfo() throws IOException {
        return this.getLocalAppInfo(VersionUtil.getCurrentVersion().getVersion());
    }

    public AppInfo getLocalAppInfo(String version) throws IOException {
        File appInfoOfVersion = this.getLocalAppInfoFile(version);
        if (appInfoOfVersion.exists()) {
            String appInfoContent = FileUtils.readFileToString((File)appInfoOfVersion);
            return (AppInfo)JsonUtil.fromJson((String)appInfoContent, AppInfo.class);
        }
        AppInfo appInfo = new AppInfo();
        appInfo.setPlatform(Platform.getOS());
        appInfo.setVersion(version);
        this.saveAppInfo(appInfo);
        return appInfo;
    }

    public File getLocalExtractDir(String version) throws IOException {
        return new File(this.getUpdateResourcesDir(), version + "/extract");
    }

    public File getLocalDownloadDir(String version) throws IOException {
        return new File(this.getUpdateResourcesDir(), version + "/download");
    }

    public File getLocalDownloadFileInfo(String version, String fileName) throws IOException {
        return new File(this.getLocalDownloadDir(version), fileName);
    }

    private File getLocalAppInfoFile(String version) throws IOException {
        File updateFolderInfoInLocal = new File(this.getUpdateResourcesDir(), version);
        File appInfoOfVersion = new File(updateFolderInfoInLocal, APP_INFO);
        return appInfoOfVersion;
    }

    public File saveAppInfo(AppInfo appInfo) throws IOException {
        File localAppInfoFile = this.getLocalAppInfoFile(appInfo.getVersion());
        String appInfoContent = JsonUtil.toJson((Object)appInfo, AppInfo.class, (boolean)true);
        FileUtils.writeStringToFile((File)localAppInfoFile, (String)appInfoContent, (Charset)StandardCharsets.UTF_8);
        return localAppInfoFile;
    }

    public File saveExecInfo(ExecInfo execInfo) throws IOException {
        File execInfoFile = new File(this.getUpdaterJarDir(), EXEC_INFO);
        String execInfoContent = JsonUtil.toJson((Object)execInfo, ExecInfo.class, (boolean)true);
        FileUtils.writeStringToFile((File)execInfoFile, (String)execInfoContent, (Charset)StandardCharsets.UTF_8);
        return execInfoFile;
    }

    public boolean isKsNewVersionNotification() {
        try {
            return Optional.ofNullable(this.sessionController.getAdministrationManagedKsSetting()).map(AdministrationManagedKsSetting::isKsNewVersionNotification).orElse(false);
        }
        catch (Exception e) {
            LogUtil.logError((String)"Failed to retrieve isKsNewVersionNotification from Admin in UpdateManager");
            LogUtil.logError((Throwable)e);
            LogUtil.logError((String)"Fallback to default value: FALSE");
            return false;
        }
    }
}

