/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.application;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.core.application.ApplicationActionBarAdvisor;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.ide.EditorAreaDropAdapter;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    @Inject
    ISessionController sessionController;
    private static final String[] ECLIPSE_DEFAULT_ACTION_SET_IDS = new String[]{"org.codehaus.groovy.eclipse.ui.groovyElementCreation", "org.eclipse.search.searchActionSet", "org.eclipse.ui.edit.text.actionSet.annotationNavigation", "org.eclipse.ui.edit.text.actionSet.navigation"};
    private IWorkbenchWindowConfigurer fConfigurer;
    private MApplication application;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        this.fConfigurer = configurer;
        this.application = ApplicationSingleton.getInstance().getApplication();
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        this.fConfigurer.setShowProgressIndicator(true);
        this.fConfigurer.configureEditorAreaDropListener((DropTargetListener)new EditorAreaDropAdapter(this.fConfigurer.getWindow()));
    }

    public void postWindowClose() {
        Map appPersistedState;
        if (PlatformUI.getPreferenceStore().getBoolean("general.autoRestorePreviousSession") && (appPersistedState = this.application.getPersistedState()) != null) {
            appPersistedState.remove("memento");
        }
    }

    public boolean preWindowShellClose() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
        try {
            boolean confirmed = (Boolean)handlerService.executeCommand("com.kms.katalon.composer.quit", null);
            return confirmed;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    public void postWindowCreate() {
        this.hideUnwantedActionSets();
        EPartService partService = (EPartService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(EPartService.class);
        this.selectAndActivateChildPart(partService, "com.kms.katalon.partstack.outline", 0);
        this.selectAndActivateChildPart(partService, "com.kms.katalon.partstack.left.outline", 0);
    }

    private void selectAndActivateChildPart(EPartService partService, String partStackId, int selectIndex) {
        MPartStack partStack = (MPartStack)ModelServiceSingleton.getInstance().getModelService().find(partStackId, (MUIElement)this.application);
        if (partStack == null) {
            return;
        }
        List leftOutlineChildren = partStack.getChildren();
        if (leftOutlineChildren.isEmpty()) {
            return;
        }
        MStackElement part = (MStackElement)leftOutlineChildren.get(selectIndex);
        partStack.setSelectedElement((MUIElement)part);
        partService.activate((MPart)part);
    }

    private void hideUnwantedActionSets() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            String[] stringArray = ECLIPSE_DEFAULT_ACTION_SET_IDS;
            int n = ECLIPSE_DEFAULT_ACTION_SET_IDS.length;
            int n2 = 0;
            while (n2 < n) {
                String actionSet = stringArray[n2];
                activePage.hideActionSet(actionSet);
                ++n2;
            }
        }
    }
}

