/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.handlers.SystemBrowserLoginHandler;
import com.kms.katalon.composer.helpers.SSOController;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.core.util.EncodingUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.webserver.WebViewServer;
import com.kms.katalon.webserver.handlers.RemoteFileHandler;
import com.kms.katalon.webserver.handlers.StaticFileHandler;
import com.kms.katalon.webserver.handlers.StudioAssistChatHandler;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsServer;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class WebViewController {
    private static final String DEFAULT_WEBVIEW_BUILD_DIR = "resources/webview";
    private static final String KNOWLEDGE_HUB_WEBVIEW_BUILD_DIR = "resources/onboarding";
    private static WebViewController _instance;
    @Inject
    INetworkPreferences networkPreferences;
    @Inject
    IHttpClient httpClient;
    @Inject
    private ISessionController sessionController;
    private WebViewServer webViewServer;
    private WebViewServer remoteAssetsServer;
    private URL remoteWebAssetServerUrl;

    public WebViewServer getWebViewServer() {
        return this.webViewServer;
    }

    public static WebViewController getInstance() {
        if (_instance == null) {
            _instance = new WebViewController();
        }
        return _instance;
    }

    private WebViewController() {
    }

    public URIBuilder buildURIBuilder(String path) throws URISyntaxException {
        URI baseUri = new URI(MessageFormat.format("http://{0}", this.getHost()));
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(path);
        return uriBuilder;
    }

    public void startAsync() {
        UISynchronizeService.asyncExec(() -> this.start());
    }

    public void start() {
        BundleContext bundleContext = FrameworkUtil.getBundle(WebViewController.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        try {
            this.webViewServer = new WebViewServer().create().use("/auth", (HttpHandler)ContextInjectionFactory.make(SystemBrowserLoginHandler.class, (IEclipseContext)context)).use("/KnowledgeHub", new StaticFileHandler(KNOWLEDGE_HUB_WEBVIEW_BUILD_DIR)).use("/", new StaticFileHandler(DEFAULT_WEBVIEW_BUILD_DIR));
            SSOController.getInstance().setRedirectServer(this.getPage(""));
            if (ApplicationEdition.get() == KatalonEdition.ENTERPRISE) {
                this.webViewServer.use("/studio-assist-chat", new StudioAssistChatHandler(context));
            }
            this.webViewServer.start();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException error) {
            LogUtil.logError((Throwable)error);
        }
    }

    public void startRemoteAssetServer() {
        if (this.canStartRemoteAssetServer()) {
            BundleContext bundleContext = FrameworkUtil.getBundle(WebViewController.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            try {
                RemoteFileHandler handler = (RemoteFileHandler)ContextInjectionFactory.make(RemoteFileHandler.class, (IEclipseContext)context);
                handler.setRemoteUrl(this.remoteWebAssetServerUrl);
                this.remoteAssetsServer = new WebViewServer().create().use("/", handler).start();
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InjectionException error) {
                LogUtil.logError((Throwable)error);
            }
        }
    }

    private boolean canStartRemoteAssetServer() {
        return Objects.nonNull(this.remoteWebAssetServerUrl) && !this.isRemoteAssetServerStarted();
    }

    public boolean isRemoteAssetServerStarted() {
        return this.remoteAssetsServer != null && this.remoteAssetsServer.isStarted();
    }

    private void stopRemoteAssetServer() {
        if (this.isRemoteAssetServerStarted()) {
            this.remoteAssetsServer.stop();
        }
    }

    public void ensureStarted() {
        if (this.webViewServer == null || !this.webViewServer.isStarted()) {
            this.start();
        }
        this.startRemoteAssetServer();
    }

    public void stop() {
        this.webViewServer.stop();
        this.stopRemoteAssetServer();
    }

    public void stopAsync() {
        this.webViewServer.stopAsync();
        this.stopRemoteAssetServerAsync();
    }

    private void stopRemoteAssetServerAsync() {
        if (this.isRemoteAssetServerStarted()) {
            this.remoteAssetsServer.stopAsync();
        }
    }

    public String getHost() {
        return this.webViewServer.getHost();
    }

    public Integer getPort() {
        return this.webViewServer.getPort();
    }

    public String getPage(String path) {
        return MessageFormat.format("http://{0}/{1}", this.getHost(), path);
    }

    public String getMultiMediaPage(String mediaUrl) {
        return MessageFormat.format("{0}?url={1}", this.getPage("MultiMedia.html"), EncodingUtil.encodeURIComponent((String)mediaUrl));
    }

    public String getRemoteWebAssetServerHost() {
        String scheme = "http";
        if (this.webViewServer.getServer() instanceof HttpsServer) {
            scheme = "https";
        }
        return MessageFormat.format("{0}://{1}", scheme, this.remoteAssetsServer.getHost());
    }

    public String getLocalApiServerUrl() {
        String scheme = "http";
        if (this.webViewServer.getServer() instanceof HttpsServer) {
            scheme = "https";
        }
        return MessageFormat.format("{0}://{1}", scheme, this.webViewServer.getHost());
    }

    public URL getRemoteWebAssetServerUrl() {
        return this.remoteWebAssetServerUrl;
    }

    public String getRemotePage(String query) throws URISyntaxException {
        URI localProxyURI = new URI(this.getRemoteWebAssetServerHost());
        List<NameValuePair> userEngagementQueryParams = this.buildUserEngagementQueryParameters(query);
        return new URIBuilder(this.remoteWebAssetServerUrl.toURI()).setScheme(localProxyURI.getScheme()).setHost(localProxyURI.getHost()).setPort(localProxyURI.getPort()).setParameters(userEngagementQueryParams).build().toString();
    }

    private List<NameValuePair> buildUserEngagementQueryParameters(String query) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder("?" + StringUtils.stripStart((String)query, (String)"?"));
        List queryParameters = uriBuilder.getQueryParams();
        URIBuilder remoteUriBuilder = new URIBuilder("?" + StringUtils.stripStart((String)this.remoteWebAssetServerUrl.getQuery(), (String)"?"));
        List remoteParameters = remoteUriBuilder.getQueryParams();
        remoteParameters.add(new BasicNameValuePair("nocache", Long.toString(System.currentTimeMillis())));
        ArrayList<NameValuePair> userEngagementParameters = new ArrayList<NameValuePair>(queryParameters);
        userEngagementParameters.addAll(remoteParameters);
        return userEngagementParameters;
    }

    public void setRemoteServerForWebAssetReverseProxy(URL fullUrl) {
        this.remoteWebAssetServerUrl = fullUrl;
    }
}

