/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.katalon.composer.core.webview.browserfunction.BrowserFunctionBridge;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.core.util.JsonBuilder;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.exception.SessionException;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsTeam;
import com.kms.katalon.webserver.types.ProjectConfiguration;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.browser.Browser;

public class KatalonInfoRpcHandler {
    private static String EMPTY_JSON_OBJECT_STRING = "{}";
    private static String KSE_EXPIRATION_DATE_KEY = "KSE";
    private static String KRE_EXPIRATION_DATE_KEY = "KRE";
    private ISessionController sessionController;
    private IDiscoveryController discoveryController;

    public KatalonInfoRpcHandler(ISessionController sessionController, IDiscoveryController discoveryController) {
        this.sessionController = sessionController;
        this.discoveryController = discoveryController;
    }

    public void registerBrowserfunctions(BrowserFunctionBridge browserFunctionHelper, Browser browser) {
        browserFunctionHelper.registerBrowserFunction("startPageView.fetchKSVersion", String.class, requestId -> browserFunctionHelper.sendRpcResponse(browser, requestId, (Object)this.getVersion()));
        browserFunctionHelper.registerBrowserFunction("startPageView.fetchKSBuildNumber", String.class, requestId -> browserFunctionHelper.sendRpcResponse(browser, requestId, (Object)this.getBuildNumber()));
        browserFunctionHelper.registerBrowserFunction("startPageView.fetchLicenseInfo", String.class, requestId -> browserFunctionHelper.sendRpcResponse(browser, requestId, (Object)this.getLicenseInfo()));
        browserFunctionHelper.registerBrowserFunction("startPageView.fetchProjectConfiguration", String.class, requestId -> {
            ProjectConfiguration projectConfiguration = this.getProjectConfiguration();
            browserFunctionHelper.sendRpcResponse(browser, requestId, (Object)projectConfiguration);
        });
        browserFunctionHelper.registerBrowserFunction("startPageView.fetchIsKSProjectOpened", String.class, requestId -> {
            boolean isOpenedProject = this.isOpenedProject();
            browserFunctionHelper.sendRpcResponse(browser, requestId, (Object)isOpenedProject);
        });
        browserFunctionHelper.registerBrowserFunction("startPageView.fetchUserProfile", String.class, requestId -> browserFunctionHelper.sendRpcResponse(browser, requestId, (Object)UserProfileHelper.getCurrentProfile()));
        browserFunctionHelper.registerBrowserFunction("startPageView.fetchKatalonEdition", String.class, requestId -> browserFunctionHelper.sendRpcResponse(browser, requestId, (Object)ApplicationEdition.get().name()));
        browserFunctionHelper.registerBrowserFunction("startPageView.fetchIsOnPremActivation", String.class, requestId -> browserFunctionHelper.sendRpcResponse(browser, requestId, (Object)false));
    }

    private String getVersion() {
        return ApplicationInfo.versionNo();
    }

    private int getBuildNumber() {
        return VersionUtil.getCurrentVersion().getBuildNumber();
    }

    private String getLicenseInfo() {
        Session session = this.sessionController.getSession();
        License license = session.getLicense();
        if (license == null) {
            return EMPTY_JSON_OBJECT_STRING;
        }
        LicenseType licenseType = license.getLicenseType();
        JsonBuilder jsonBuilder = JsonBuilder.object();
        jsonBuilder.property("type", (Object)licenseType.toString());
        if (license.isOffline()) {
            Long expirationDate = license.getExpirationDate();
            if (expirationDate == null) {
                return jsonBuilder.toJson();
            }
            jsonBuilder.property("expirationDate", Map.of(KSE_EXPIRATION_DATE_KEY, this.formatDate(new Date(expirationDate * 1000L))));
            return jsonBuilder.toJson();
        }
        if (licenseType == LicenseType.TRIAL || licenseType == LicenseType.FREE) {
            Date trialExpirationDate = ApplicationContext.getInstance().getExpirationTrial();
            jsonBuilder.property("expirationDate", Map.of(KSE_EXPIRATION_DATE_KEY, trialExpirationDate, KRE_EXPIRATION_DATE_KEY, trialExpirationDate));
            return jsonBuilder.toJson();
        }
        if (licenseType == LicenseType.ENTERPRISE || licenseType == LicenseType.EDUCATION) {
            String kre;
            HashMap<String, String> expirationDate = new HashMap<String, String>();
            String kse = this.getKSELicenseExpirationDate();
            if (StringUtils.isNotBlank((String)kse)) {
                expirationDate.put(KSE_EXPIRATION_DATE_KEY, kse);
            }
            if (StringUtils.isNotBlank((String)(kre = this.getKRELicenseExpirationDate()))) {
                expirationDate.put(KRE_EXPIRATION_DATE_KEY, kre);
            }
            if (!expirationDate.isEmpty()) {
                jsonBuilder.property("expirationDate", expirationDate);
            }
            return jsonBuilder.toJson();
        }
        return jsonBuilder.toJson();
    }

    private ProjectConfiguration getProjectConfiguration() {
        ProjectConfiguration projectConfiguration = new ProjectConfiguration();
        boolean isIntegrationEnabled = false;
        boolean isInKsProject = false;
        ProjectConfiguration.TestOpsProject testOpsProject = null;
        String testOpsServerUrl = this.discoveryController.getServerUrl(ServerType.TESTOPS);
        AnalyticsSettingStore analyticsSettingStore = AnalyticsSettingStore.getStore();
        if (analyticsSettingStore != null) {
            isInKsProject = true;
            isIntegrationEnabled = analyticsSettingStore.isIntegrationEnabled();
            if (isIntegrationEnabled) {
                AnalyticsTeam analyticsTeam;
                Organization analyticsOrganization;
                testOpsProject = new ProjectConfiguration.TestOpsProject();
                AnalyticsProject analyticsProject = analyticsSettingStore.getProject();
                if (analyticsProject != null) {
                    testOpsProject.setId(analyticsProject.getId());
                    testOpsProject.setName(analyticsProject.getName());
                }
                if ((analyticsOrganization = analyticsSettingStore.getOrganization()) != null) {
                    testOpsProject.setOrganizationId(analyticsOrganization.getId());
                    testOpsProject.setOrganizationName(analyticsOrganization.getName());
                }
                if ((analyticsTeam = analyticsSettingStore.getTeam()) != null) {
                    testOpsProject.setTeamId(analyticsTeam.getId());
                    testOpsProject.setTeamName(analyticsTeam.getName());
                }
                testOpsServerUrl = analyticsSettingStore.getServerEndpoint();
            }
        }
        projectConfiguration.setTestOpsProject(testOpsProject);
        projectConfiguration.setTestOpsServerUrl(testOpsServerUrl);
        projectConfiguration.setIntegrationEnabled(isIntegrationEnabled);
        projectConfiguration.setInKsProject(isInKsProject);
        return projectConfiguration;
    }

    private boolean isOpenedProject() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    private String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MMMMM dd, yyyy");
        return formatter.format(date);
    }

    private String getKRELicenseExpirationDate() {
        try {
            Date date = this.sessionController.getExpirationOnline("ENGINE");
            if (date != null) {
                return this.formatDate(date);
            }
        }
        catch (SessionException e) {
            LogUtil.logError((Throwable)e);
        }
        return "";
    }

    private String getKSELicenseExpirationDate() {
        Session session = this.sessionController.getSession();
        License license = session.getLicense();
        if (license.isOffline()) {
            Instant instant = Instant.ofEpochMilli(license.getExpirationDate());
            return Date.from(instant).toString();
        }
        try {
            Date date = this.sessionController.getExpirationOnline(session.getLicenseFeature());
            if (date != null) {
                return this.formatDate(date);
            }
        }
        catch (SessionException e) {
            LogUtil.logError((Throwable)e);
        }
        return "";
    }
}

