/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import com.kms.katalon.webserver.handlers.StudioAssistAgentSettingTrackingHandler;
import com.kms.katalon.webserver.handlers.StudioAssistSettingHandler;
import com.kms.katalon.webserver.handlers.StudioAssistToolCallHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class StudioAssistChatHandler
extends CustomHttpHandler {
    private static final String STUDIO_ASSIST_CHAT_BASE_PATH = "/studio-assist-chat";
    private final Map<String, Class<? extends CustomHttpHandler>> endpointHandlers = new HashMap<String, Class<? extends CustomHttpHandler>>();
    private IEclipseContext eclipseContext;

    public StudioAssistChatHandler() {
        this.initializeEndpointMappings();
    }

    public StudioAssistChatHandler(IEclipseContext context) {
        this();
        this.eclipseContext = context;
    }

    private void initializeEndpointMappings() {
        this.endpointHandlers.put("/mcp-settings", StudioAssistSettingHandler.class);
        this.endpointHandlers.put("/tool-calls", StudioAssistToolCallHandler.class);
        this.endpointHandlers.put("/track-mcp-settings", StudioAssistAgentSettingTrackingHandler.class);
    }

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        if (this.handlePrefightRequestAndCORS(req)) {
            return;
        }
        String requestPath = req.getURI().getPath();
        String endpointPath = requestPath.substring(STUDIO_ASSIST_CHAT_BASE_PATH.length());
        if (endpointPath.isEmpty() || "/".equals(endpointPath)) {
            req.send(MessageConstants.STUDIO_ASSIST_CHAT_HANDLER_RUNNING);
            return;
        }
        Class<? extends CustomHttpHandler> handlerClass = this.endpointHandlers.get(endpointPath);
        if (handlerClass == null) {
            req.send(404, MessageConstants.STUDIO_ASSIST_CHAT_ENDPOINT_NOT_FOUND + ": " + endpointPath);
            return;
        }
        try {
            CustomHttpHandler handler = (CustomHttpHandler)ContextInjectionFactory.make(handlerClass, (IEclipseContext)this.eclipseContext);
            handler.customHandle(req);
        }
        catch (Exception e) {
            req.send(500, MessageConstants.STUDIO_ASSIST_CHAT_INTERNAL_ERROR + ": " + e.getMessage());
        }
    }
}

