/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.legacy;

import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlValidationError;
import org.reficio.ws.legacy.SoapVersion11;
import org.reficio.ws.legacy.SoapVersion12;

interface SoapVersion {
    public static final SoapVersion11 Soap11 = SoapVersion11.instance;
    public static final SoapVersion12 Soap12 = SoapVersion12.instance;

    public QName getEnvelopeQName();

    public QName getBodyQName();

    public QName getHeaderQName();

    public void validateSoapEnvelope(String var1, List<XmlError> var2);

    public String getContentTypeHttpHeader(String var1, String var2);

    public String getEnvelopeNamespace();

    public String getFaultDetailNamespace();

    public String getEncodingNamespace();

    public XmlObject getSoapEncodingSchema() throws XmlException, IOException;

    public XmlObject getSoapEnvelopeSchema() throws XmlException, IOException;

    public boolean shouldIgnore(XmlValidationError var1);

    public String getContentType();

    public SchemaType getEnvelopeType();

    public SchemaType getFaultType();

    public String getName();

    public String getSoapActionHeader(String var1);

    public static class Utils {
        public static SoapVersion getSoapVersionForContentType(String contentType, SoapVersion def) {
            if (StringUtils.isBlank((CharSequence)contentType)) {
                return def;
            }
            SoapVersion11 soapVersion = contentType.startsWith(Soap11.getContentType()) ? Soap11 : null;
            soapVersion = soapVersion == null && contentType.startsWith(Soap12.getContentType()) ? Soap12 : soapVersion;
            return soapVersion == null ? def : soapVersion;
        }
    }
}

