/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.folder.handlers;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.ApiCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.folder.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.events.TestCaseUpdatedEvent;
import com.kms.katalon.entity.testdata.events.TestDataUpdatedEvent;
import com.kms.katalon.entity.testobject.events.TestObjectUpdatedEvent;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameFolderHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Named(value="activeShell")
    private Shell parentShell;
    @Inject
    private UISynchronize uiSynchronize;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof FolderTreeEntity) {
                    if (object instanceof ApiCollectionTreeEntity) {
                        return;
                    }
                    RenameFolderHandler.this.execute((FolderTreeEntity)object);
                }
            }
        });
    }

    private void execute(FolderTreeEntity folderTreeEntity) {
        block9: {
            try {
                FolderEntity oldFolder = folderTreeEntity.getObject();
                if (oldFolder == null) break block9;
                ArrayList<String> oldDescendantEntityIds = new ArrayList<String>();
                for (Object descendantEntity : FolderController.getInstance().getAllDescentdantEntities(oldFolder)) {
                    if (descendantEntity instanceof FolderEntity) continue;
                    oldDescendantEntityIds.add(((FileEntity)descendantEntity).getId());
                }
                if (oldFolder.getParentFolder() == null) {
                    this.renameRootFolder(folderTreeEntity);
                    return;
                }
                RenameWizard renameWizard = new RenameWizard((ITreeEntity)folderTreeEntity, FolderController.getInstance().getChildrenNames(oldFolder.getParentFolder()));
                CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
                int code = wizardDialog.open();
                if (code != 0) break block9;
                FolderEntity folder = folderTreeEntity.getObject();
                String oldName = folder.getName();
                try {
                    if (renameWizard.getNewNameValue() != null && !renameWizard.getNewNameValue().isEmpty() && !renameWizard.getNewNameValue().equals(oldName)) {
                        ArrayList<String> oldDescendantIdsSnapshot = new ArrayList<String>();
                        ArrayList<FileEntity> descendantEntitiesSnapshot = new ArrayList<FileEntity>();
                        for (Object descendant : FolderController.getInstance().getAllDescentdantEntities(folder)) {
                            if (!(descendant instanceof FileEntity) || descendant instanceof FolderEntity) continue;
                            FileEntity entity = (FileEntity)descendant;
                            oldDescendantIdsSnapshot.add(entity.getId());
                            descendantEntitiesSnapshot.add(entity);
                        }
                        this.scheduleFolderRenameJob(folderTreeEntity, oldName, renameWizard.getNewNameValue(), oldDescendantIdsSnapshot, descendantEntitiesSnapshot);
                    }
                }
                catch (Exception ex) {
                    folder.setName(oldName);
                    LoggerSingleton.logError((Throwable)ex);
                    if (ex instanceof InvocationTargetException && ex.getCause() instanceof Exception) {
                        ex = (Exception)ex.getCause();
                    }
                    String errorMessage = ex instanceof FilePathTooLongException ? ex.getMessage() : StringConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_FOLDER;
                    MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR_TITLE, (String)errorMessage);
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private void scheduleFolderRenameJob(FolderTreeEntity folderTreeEntity, String oldName, String newName, List<String> oldDescendantEntityIds, List<FileEntity> descendantEntities) throws Exception {
        FolderEntity folder = folderTreeEntity.getObject();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.parentShell);
        IRunnableWithProgress job = monitor -> {
            monitor.beginTask(StringConstants.JOB_RENAME_FOLDER, -1);
            monitor.subTask(StringConstants.JOB_TASK_RENAME_FOLDER);
            try {
                String folderParentPath = folder.getParentFolder().getRelativePathForUI().replace('\\', '/') + "/";
                if (monitor.isCanceled()) {
                    return;
                }
                try {
                    FolderController.getInstance().updateFolderName(folder, newName);
                    String eventTopic = null;
                    switch (folder.getFolderType()) {
                        case TESTCASE: {
                            eventTopic = "TESTCASE/UPDATED";
                            break;
                        }
                        case DATAFILE: {
                            eventTopic = "TESTDATA/UPDATE";
                            break;
                        }
                        case TESTSUITE: {
                            eventTopic = "TESTSUITE/UPDATED";
                            break;
                        }
                        case WEBELEMENT: {
                            eventTopic = "TESTOBJECT/UPDATED";
                            break;
                        }
                        case CHECKPOINT: {
                            eventTopic = "CHECKPOINT/UPDATED";
                            break;
                        }
                    }
                    String finalEventTopic = eventTopic;
                    this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{folderParentPath + oldName + "/", folderParentPath + newName + "/"});
                    folder.setName(newName);
                    if (finalEventTopic != null) {
                        int i = 0;
                        while (i < descendantEntities.size()) {
                            FileEntity entity = (FileEntity)descendantEntities.get(i);
                            String oldEntityId = (String)oldDescendantEntityIds.get(i);
                            Object eventArgs = finalEventTopic.equals("TESTCASE/UPDATED") ? new TestCaseUpdatedEvent(oldEntityId, entity, TestCaseUpdatedEvent.TriggeredBy.RENAME_FOLDER) : (finalEventTopic.equals("TESTOBJECT/UPDATED") ? new TestObjectUpdatedEvent(oldEntityId, entity, TestObjectUpdatedEvent.TriggeredBy.RENAME_FOLDER) : (finalEventTopic.equals("TESTDATA/UPDATE") ? new TestDataUpdatedEvent(oldEntityId, entity, TestDataUpdatedEvent.TriggeredBy.RENAME_FOLDER) : new Object[]{oldEntityId, entity}));
                            this.eventBroker.post(finalEventTopic, eventArgs);
                            ++i;
                        }
                    }
                    if (folderTreeEntity.getParent() != null) {
                        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)folderTreeEntity.getParent());
                        this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)folderTreeEntity);
                    }
                    this.uiSynchronize.asyncExec(() -> this.partService.saveAll(false));
                }
                catch (Exception ex) {
                    throw new InvocationTargetException(ex);
                }
            }
            finally {
                monitor.done();
            }
        };
        dialog.run(true, false, job);
    }

    private void renameRootFolder(FolderTreeEntity folderTreeEntity) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        List existingNames = FolderController.getInstance().getRootFileOrFolderNames(project);
        FolderEntity oldFolder = folderTreeEntity.getObject();
        RenameWizard renameWizard = new RenameWizard((ITreeEntity)folderTreeEntity, existingNames);
        CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
        if (wizardDialog.open() == 0) {
            String newNameValue = renameWizard.getNewNameValue();
            String oldName = oldFolder.getName();
            if (!StringUtils.isBlank((String)newNameValue) && !newNameValue.equalsIgnoreCase(oldName)) {
                File newFolder = new File(project.getFolderLocation(), newNameValue);
                oldFolder.toFile().renameTo(newFolder);
                folderTreeEntity.getObject().setName(newNameValue);
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)folderTreeEntity);
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)folderTreeEntity);
            }
        }
    }
}

