/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.dialogs;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.EntityNameController;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewTextFileDialog
extends CustomTitleAreaDialog {
    private List<String> siblingFileNames;
    private Text txtName;
    private String name;

    public NewTextFileDialog(Shell parentShell, List<String> siblingFileNames) {
        super(parentShell);
        this.siblingFileNames = siblingFileNames;
    }

    protected Composite createContentArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout(2, false));
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblName = new Label(body, 0);
        lblName.setLayoutData((Object)new GridData(16384, 128, false, false));
        lblName.setText(GlobalMessageConstants.NAME);
        this.txtName = new Text(body, 2048);
        this.txtName.setLayoutData((Object)new GridData(4, 128, true, false));
        return body;
    }

    protected void registerControlModifyListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewTextFileDialog.this.checkNewName(NewTextFileDialog.this.txtName.getText());
            }
        });
    }

    private void checkNewName(String newName) {
        if (this.isNameDuplicated(newName)) {
            this.setMessage(StringConstants.DIA_NAME_EXISTED, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        try {
            EntityNameController.getInstance().validateName(newName);
            this.setMessage(StringConstants.DIA_MSG_CREATE_NEW_FILE, 1);
            this.getButton(0).setEnabled(true);
        }
        catch (Exception e) {
            this.setMessage(e.getMessage(), 3);
            this.getButton(0).setEnabled(false);
        }
    }

    private boolean isNameDuplicated(String newName) {
        return this.siblingFileNames.stream().filter(f -> f.equalsIgnoreCase(newName)).findAny().isPresent();
    }

    protected void setInput() {
        this.txtName.setText(this.getSuggestion("New Text Document", "txt"));
        this.setMessage(StringConstants.DIA_MSG_CREATE_NEW_FILE, 1);
    }

    private String getSuggestion(String suggestion, String extension) {
        String newName = String.format("%s.%s", suggestion, extension);
        int index = 0;
        while (this.isNameDuplicated(newName)) {
            newName = String.format("%s %d.%s", suggestion, ++index, extension);
        }
        return newName;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.name = this.txtName.getText();
        super.okPressed();
    }

    public String getNewFileName() {
        return this.name;
    }

    protected Point getInitialSize() {
        return new Point(400, 250);
    }
}

