/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.handler.CommonExplorerHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.constants.StringConstants;
import com.kms.katalon.composer.explorer.handlers.deletion.AbstractDeleteReferredEntityHandler;
import com.kms.katalon.composer.explorer.handlers.deletion.DeleteEntityHandlerFactory;
import com.kms.katalon.composer.explorer.handlers.deletion.IDeleteEntityHandler;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteHandler
extends CommonExplorerHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canExecute() {
        if (!this.isExplorerPartActive()) {
            return false;
        }
        Object[] selectedObjects = this.getExplorerSelection();
        if (selectedObjects.length == 0) {
            return false;
        }
        try {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity && !((ITreeEntity)entity).isRemoveable()) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    public void execute() {
        Object[] selectedObjects = this.getExplorerSelection();
        if (selectedObjects.length == 0) {
            return;
        }
        this.delete(selectedObjects, true);
    }

    private void delete(Object[] objects, boolean needConfirm) {
        try {
            if (!needConfirm) {
                this.delete(objects);
                return;
            }
            String message = MessageFormat.format(StringConstants.HAND_MULTI_DELETE_CONFIRM_MSG, objects.length);
            if (objects.length == 1 && objects[0] instanceof ITreeEntity) {
                message = MessageFormat.format(StringConstants.HAND_DELETE_CONFIRM_MSG, ((ITreeEntity)objects[0]).getTypeName() + " '" + ((ITreeEntity)objects[0]).getText() + "'");
            }
            if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.HAND_DELETE_TITLE, (String)message)) {
                this.delete(objects);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void delete(final Object[] objects) throws InvocationTargetException, InterruptedException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        dialog.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Deleting items...", objects.length + 1);
                    HashSet<ITreeEntity> parentSetEntities = new HashSet<ITreeEntity>();
                    boolean showYesNoToAllOptions = objects.length > 1;
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block16: {
                            Object selectedItem = objectArray[n2];
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (selectedItem instanceof ITreeEntity) {
                                IDeleteEntityHandler handler;
                                SubProgressMonitor subMonitor;
                                ITreeEntity treeEntity;
                                block15: {
                                    treeEntity = (ITreeEntity)selectedItem;
                                    subMonitor = new SubProgressMonitor(monitor, 1, 4);
                                    try {
                                        if (parentSetEntities.contains(treeEntity)) {
                                            parentSetEntities.remove(treeEntity);
                                        }
                                        if (treeEntity.getParent() == null) break block15;
                                        parentSetEntities.add(treeEntity.getParent());
                                    }
                                    catch (Exception exception) {
                                        subMonitor.done();
                                        break block16;
                                    }
                                }
                                if ((handler = DeleteEntityHandlerFactory.getInstance().getDeleteHandler(treeEntity.getClass())) != null) {
                                    if (handler instanceof AbstractDeleteReferredEntityHandler) {
                                        ((AbstractDeleteReferredEntityHandler)handler).setNeedYesNoToAllButtons(showYesNoToAllOptions);
                                    }
                                    try {
                                        handler.execute(treeEntity, (IProgressMonitor)subMonitor);
                                    }
                                    catch (Exception e) {
                                        LoggerSingleton.logError((Throwable)e);
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                    monitor.subTask("Refreshing explorer");
                    for (ITreeEntity parentEntity : parentSetEntities) {
                        DeleteHandler.this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentEntity);
                    }
                    monitor.worked(1);
                }
                finally {
                    monitor.done();
                    DeleteHandler.this.eventBroker.post("EXPLORER/RESET_USER_RESPONSE_FOR_DELETION", (Object)StringConstants.EMPTY);
                }
            }
        });
    }
}

