/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.handler.CommonExplorerHandler;
import com.kms.katalon.composer.components.impl.tree.ApiCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.log.Logger;

public class OpenHandler
extends CommonExplorerHandler {
    @Inject
    private Logger logger;

    @CanExecute
    public boolean canExecute() {
        if (!this.isExplorerPartActive()) {
            return false;
        }
        Object[] selectedObjects = this.getExplorerSelection();
        if (selectedObjects.length == 0) {
            return false;
        }
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (!(item instanceof ITreeEntity)) {
                return false;
            }
            if (!(item instanceof ApiCollectionTreeEntity) && item instanceof FolderTreeEntity) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Execute
    public void execute() {
        try {
            for (ITreeEntity selectedItem : this.getElementSelection(ITreeEntity.class)) {
                this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", selectedItem.getObject());
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }
}

