/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.chooser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.prefs.BackingStoreException;

public class CompilerChooser
implements BundleActivator {
    public static final String PLUGIN_ID = "org.codehaus.groovy.eclipse.compilerResolver";
    private static final String ECLIPSE_COMMANDS = "eclipse.commands";
    private static final String GROOVY_PLUGIN_ID = "org.codehaus.groovy";
    private static final String GROOVY_COMPILER_LEVEL = "groovy.compiler.level";
    private static final String DASH_GROOVY_COMPILER_LEVEL = "-groovy.compiler.level";
    private static CompilerChooser instance;
    private int activeIndex = -1;
    private Version[] allVersions = new Version[0];
    private SpecifiedVersion[] allSpecifiedVersions = new SpecifiedVersion[0];
    private BundleContext bundleContext;
    private volatile boolean initialized;
    private ServiceListener serviceListener;

    public static CompilerChooser getInstance() {
        return instance;
    }

    public CompilerChooser() {
        instance = this;
    }

    public Bundle getActiveBundle() {
        if (this.activeIndex == -1) {
            Bundle[] bundleArray = Platform.getBundles((String)GROOVY_PLUGIN_ID, null);
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle.getState() == 32) {
                    return bundle;
                }
                ++n2;
            }
            return Platform.getBundle((String)GROOVY_PLUGIN_ID);
        }
        Bundle[] bundles = Platform.getBundles((String)GROOVY_PLUGIN_ID, (String)this.allVersions[this.activeIndex].toString());
        if (bundles != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public Version getActiveVersion() {
        if (this.activeIndex == -1) {
            Bundle bundle = this.getActiveBundle();
            return bundle == null ? null : bundle.getVersion();
        }
        return this.allVersions[this.activeIndex];
    }

    public Version getAssociatedVersion(SpecifiedVersion specifiedVersion) {
        int i = 0;
        int n = this.allSpecifiedVersions.length;
        while (i < n) {
            if (this.allSpecifiedVersions[i] == specifiedVersion) {
                return this.allVersions[i];
            }
            ++i;
        }
        return null;
    }

    public SpecifiedVersion[] getAllSpecifiedVersions() {
        return this.allSpecifiedVersions;
    }

    public SpecifiedVersion getActiveSpecifiedVersion() {
        if (this.activeIndex == -1) {
            return SpecifiedVersion.findVersion(this.getActiveVersion());
        }
        return this.allSpecifiedVersions[this.activeIndex];
    }

    private SpecifiedVersion getVersionFromProperties() {
        String property;
        SpecifiedVersion version = SpecifiedVersion.findVersionFromString(System.getProperty(GROOVY_COMPILER_LEVEL));
        if (version == SpecifiedVersion.UNSPECIFIED && (property = System.getProperty(ECLIPSE_COMMANDS)) != null) {
            String[] split = property.split("\\\n");
            int i = 0;
            int n = split.length;
            while (i < n) {
                if (DASH_GROOVY_COMPILER_LEVEL.equals(split[i]) && i < split.length - 1) {
                    version = SpecifiedVersion.findVersionFromString(split[i + 1]);
                    break;
                }
                ++i;
            }
        }
        return version;
    }

    private SpecifiedVersion getVersionFromPrefenences() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        String versionText = node.get(GROOVY_COMPILER_LEVEL, null);
        return SpecifiedVersion.findVersionFromString(versionText);
    }

    public void storeVersion(SpecifiedVersion version) throws BackingStoreException {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        node.put(GROOVY_COMPILER_LEVEL, version.versionName);
        node.flush();
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        String filter = "(objectClass=org.eclipse.core.resources.IWorkspace)";
        this.serviceListener = event -> {
            if (event.getType() == 1) {
                this.bundleContext.removeServiceListener(this.serviceListener);
                this.serviceListener = null;
                SafeRunner.run(this::initialize);
            }
        };
        bundleContext.addServiceListener(this.serviceListener, filter);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.serviceListener != null) {
            bundleContext.removeServiceListener(this.serviceListener);
        }
        this.bundleContext = null;
        this.serviceListener = null;
        this.initialized = false;
    }

    public boolean isInitiailzed() {
        return this.initialized;
    }

    public CompilerChooser initialize() throws BundleException {
        if (!this.initialized) {
            this.initialized = true;
            SpecifiedVersion specifiedVersion = this.getVersionFromProperties();
            if (specifiedVersion == SpecifiedVersion.UNSPECIFIED) {
                specifiedVersion = this.getVersionFromPrefenences();
            }
            System.out.println("Starting Groovy-Eclipse compiler resolver. Specified compiler level: " + specifiedVersion.toReadableVersionString());
            Bundle[] bundles = Platform.getBundles((String)GROOVY_PLUGIN_ID, null);
            if (bundles == null || bundles.length == 0) {
                System.out.println("No Groovy bundles found...this will cause some problems.");
                bundles = new Bundle[]{};
            } else {
                this.dump(Arrays.asList(bundles));
            }
            this.allVersions = new Version[bundles.length];
            this.allSpecifiedVersions = new SpecifiedVersion[bundles.length];
            int i = 0;
            int n = bundles.length;
            while (i < n) {
                Bundle bundle = bundles[i];
                this.allVersions[i] = bundle.getVersion();
                this.allSpecifiedVersions[i] = SpecifiedVersion.findVersion(bundle.getVersion());
                if (this.allSpecifiedVersions[i] == specifiedVersion && this.activeIndex == -1) {
                    this.activeIndex = i;
                }
                ++i;
            }
            if (bundles.length > 1) {
                int skip = Math.max(0, this.activeIndex);
                ArrayList<Bundle> dirty = new ArrayList<Bundle>();
                int i2 = 0;
                int n2 = bundles.length;
                while (i2 < n2) {
                    Bundle bundle = bundles[i2];
                    if (i2 == skip) {
                        System.out.println("Skipped bundle version " + String.valueOf(bundle.getVersion()));
                    } else {
                        System.out.println("Stopped bundle version " + String.valueOf(bundle.getVersion()));
                        bundle.uninstall();
                        dirty.add(bundle);
                    }
                    ++i2;
                }
                this.refreshPackages(dirty);
            }
        }
        return this;
    }

    private void dump(Collection<Bundle> bundles) {
        for (Bundle b : bundles) {
            System.out.printf("%3d %s_%s %s%n", b.getBundleId(), b.getSymbolicName(), b.getVersion(), CompilerChooser.stateString(b.getState()));
        }
    }

    private void refreshPackages(Collection<Bundle> bundles) {
        FrameworkWiring wiring = (FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class);
        System.out.println("Refresh bundles:");
        this.dump(wiring.getDependencyClosure(bundles));
        CountDownLatch latch = new CountDownLatch(1);
        wiring.refreshBundles(bundles, new FrameworkListener[]{event -> {
            if (event.getType() == 4) {
                latch.countDown();
            }
        }});
        try {
            latch.await(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String stateString(int bundleState) {
        switch (bundleState) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return "UNKNOWN(" + bundleState + ")";
    }
}

