/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.admin.mapper;

import com.kms.katalon.admin.dto.AdministrationControlTagResponseDto;
import com.kms.katalon.admin.dto.AdministrationManagedAiAutoTagResponseDto;
import com.kms.katalon.admin.dto.AdministrationManagedAppSettingResponseDto;
import com.kms.katalon.session.core.model.AdminControlTag;
import com.kms.katalon.session.core.model.AdministrationManagedAiAutoTag;
import com.kms.katalon.session.core.model.AdministrationManagedKsSetting;
import com.kms.katalon.session.core.model.AiAutoTagPolicyType;
import com.kms.katalon.session.core.model.AiAutoTagSetting;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AdministrationManagedKsSettingMapper {
    private static final boolean DEFAULT_AI_ENABLED = false;
    private static final boolean DEFAULT_DIRECT_USAGE_ALLOWED = false;
    private static final boolean DEFAULT_KS_NEW_VERSION_NOTIFICATION = false;
    private static final boolean DEFAULT_SA_CHAT_TRACKING_ALLOWED = true;

    public static AdministrationManagedKsSetting fromAppSettingsDto(AdministrationManagedAppSettingResponseDto appSettingsDto) {
        return Optional.ofNullable(appSettingsDto).map(AdministrationManagedKsSettingMapper::buildKsSettingFromDto).orElse(AdministrationManagedKsSetting.defaultSettings().build());
    }

    private static AdministrationManagedKsSetting buildKsSettingFromDto(AdministrationManagedAppSettingResponseDto dto) {
        return AdministrationManagedKsSetting.builder().enableAi(AdministrationManagedKsSettingMapper.extractBooleanValue(dto.isEnableAi(), false)).allowDirectUsage(AdministrationManagedKsSettingMapper.extractBooleanValue(dto.isAllowDirectUsage(), false)).ksNewVersionNotification(AdministrationManagedKsSettingMapper.extractBooleanValue(dto.isKsNewVersionNotification(), false)).allowSaChatTracking(AdministrationManagedKsSettingMapper.extractBooleanValue(dto.isAllowSaChatTracking(), true)).aiAutoTagging(AdministrationManagedKsSettingMapper.createAiAutoTaggingSetting(dto.getAiAutoTagging())).build();
    }

    private static boolean extractBooleanValue(Boolean value, boolean defaultValue) {
        return Optional.ofNullable(value).orElse(defaultValue);
    }

    private static AiAutoTagSetting createAiAutoTaggingSetting(AdministrationManagedAiAutoTagResponseDto autoTaggingDto) {
        AdministrationManagedAiAutoTagResponseDto safeAutoTaggingDto = Optional.ofNullable(autoTaggingDto).orElseGet(AdministrationManagedAiAutoTagResponseDto::new);
        AiAutoTagPolicyType policyType = AdministrationManagedKsSettingMapper.determinePolicyType(safeAutoTaggingDto);
        AiAutoTagSetting autoTaggingSetting = new AiAutoTagSetting();
        autoTaggingSetting.setType(policyType);
        if (policyType == AiAutoTagPolicyType.ADMIN_MANAGED_AI_AUTO_TAG) {
            List<AdministrationManagedAiAutoTag> adminControlTags = AdministrationManagedKsSettingMapper.convertToAdminManagedTags(safeAutoTaggingDto.getAdminControlTags());
            autoTaggingSetting.setAdministrationManagedAiAutoTag(adminControlTags);
        }
        return autoTaggingSetting;
    }

    private static List<AdministrationManagedAiAutoTag> convertToAdminManagedTags(List<AdministrationControlTagResponseDto> controlTagDtos) {
        return Optional.ofNullable(controlTagDtos).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(AdministrationManagedKsSettingMapper::createAdminManagedTag).toList();
    }

    private static AdministrationManagedAiAutoTag createAdminManagedTag(AdministrationControlTagResponseDto dto) {
        AdministrationManagedAiAutoTag tag = new AdministrationManagedAiAutoTag();
        Optional.ofNullable(dto.getKey()).map(AdminControlTag::fromTagName).ifPresent(arg_0 -> ((AdministrationManagedAiAutoTag)tag).setKey(arg_0));
        tag.setValue(dto.getValue());
        return tag;
    }

    private static AiAutoTagPolicyType determinePolicyType(AdministrationManagedAiAutoTagResponseDto autoTaggingDto) {
        if (autoTaggingDto == null) {
            return AiAutoTagPolicyType.USER_MANAGED_AI_AUTO_TAG;
        }
        if (!autoTaggingDto.isEnabled()) {
            return AiAutoTagPolicyType.AI_AUTO_TAG_DISABLED;
        }
        return autoTaggingDto.isAllowUserTag() ? AiAutoTagPolicyType.USER_MANAGED_AI_AUTO_TAG : AiAutoTagPolicyType.ADMIN_MANAGED_AI_AUTO_TAG;
    }
}

