/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.services;

import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.constants.FeatureConstants;
import com.kms.katalon.session.core.model.Feature;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureManager;
import com.kms.katalon.session.core.services.IFeatureService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Creatable
@Singleton
public class FeatureManager
implements IFeatureManager {
    @Inject
    private IFeatureService featureService;
    private static IFeatureManager instance;

    public static IFeatureManager getInstance() {
        if (Objects.isNull(instance)) {
            BundleContext bundleContext = FrameworkUtil.getBundle(FeatureManager.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (IFeatureManager)ContextInjectionFactory.make(FeatureManager.class, (IEclipseContext)context);
        }
        return instance;
    }

    public void initFeatures(License license) {
        if (license == null) {
            return;
        }
        this.clear();
        LicenseType licenseType = license.getLicenseType();
        switch (licenseType) {
            case ENTERPRISE: {
                this.featureService.setFeatures(this.generateEnterpriseFeatures());
                break;
            }
            case TRIAL: {
                this.featureService.setFeatures(this.generateTrialFeatures());
                break;
            }
            case FREE: {
                this.featureService.setFeatures(this.generateFreeFeatures());
                break;
            }
            case EDUCATION: {
                this.featureService.setFeatures(this.generateEducationFeatures());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported License Type: " + String.valueOf(licenseType));
            }
        }
        if (license.getFeatures() != null) {
            for (Feature feature : license.getFeatures()) {
                String featureKey = feature.getKey();
                try {
                    ProductFeature productFeature = ProductFeature.valueOf((String)featureKey.toUpperCase());
                    this.enable(productFeature);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LogUtil.logInfo((String)String.format("WARNING: Ignored unrecognized feature key (%s) in the license payload", featureKey));
                }
            }
        }
    }

    public boolean canUse(ProductFeature feature) {
        if (this.featureService != null) {
            return this.featureService.getBoolean(feature);
        }
        return false;
    }

    public boolean isLimitReached(ProductFeature feature, int currentUsage) {
        if (this.featureService != null) {
            int quota = this.featureService.getInt(feature);
            return quota != FeatureConstants.UNLIMITED_QUOTA && currentUsage >= quota;
        }
        return true;
    }

    public boolean isQuotaUnlimited(ProductFeature feature) {
        if (this.featureService != null) {
            int quota = this.featureService.getInt(feature);
            return quota == FeatureConstants.UNLIMITED_QUOTA;
        }
        return false;
    }

    public void enable(ProductFeature feature) {
        if (!this.featureService.getBoolean(feature)) {
            this.featureService.enable(feature, (Object)Boolean.TRUE);
        }
    }

    public void clear() {
        if (this.featureService != null) {
            this.featureService.clear();
        }
    }

    private Map<ProductFeature, Object> generateEnterpriseFeatures() {
        HashMap<ProductFeature, Object> features = new HashMap<ProductFeature, Object>();
        ProductFeature[] productFeatureArray = ProductFeature.values();
        int n = productFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProductFeature feature = productFeatureArray[n2];
            features.put(feature, Boolean.TRUE);
            ++n2;
        }
        features.put(ProductFeature.TEST_SUITE_CREATIONS_LIMIT, FeatureConstants.UNLIMITED_QUOTA);
        features.put(ProductFeature.PRIVATE_PLUGIN, FeatureConstants.UNLIMITED_QUOTA);
        features.put(ProductFeature.OFFLINE, Boolean.FALSE);
        features.put(ProductFeature.AUTO_MIGRATION, Boolean.TRUE);
        return features;
    }

    private Map<ProductFeature, Object> generateTrialFeatures() {
        Map<ProductFeature, Object> features = this.generateEnterpriseFeatures();
        features.put(ProductFeature.TEST_SUITE_CREATIONS_LIMIT, 40);
        features.put(ProductFeature.AUTO_MIGRATION, Boolean.FALSE);
        return features;
    }

    private Map<ProductFeature, Object> generateFreeFeatures() {
        HashMap<ProductFeature, Object> features = new HashMap<ProductFeature, Object>();
        features.put(ProductFeature.SOURCE_CODE_FOR_DEBUGGING, Boolean.TRUE);
        features.put(ProductFeature.DECOMPILE_CLASS_FILE, Boolean.TRUE);
        features.put(ProductFeature.IMPORT_SELENIUM_IDE_V3, Boolean.TRUE);
        features.put(ProductFeature.GUI, Boolean.TRUE);
        features.put(ProductFeature.PRIVATE_PLUGIN, 1);
        features.put(ProductFeature.TEST_SUITE_CREATIONS_LIMIT, 40);
        return features;
    }

    private Map<ProductFeature, Object> generateEducationFeatures() {
        HashMap<ProductFeature, Object> features = new HashMap<ProductFeature, Object>();
        features.put(ProductFeature.SOURCE_CODE_FOR_DEBUGGING, Boolean.TRUE);
        features.put(ProductFeature.DECOMPILE_CLASS_FILE, Boolean.TRUE);
        features.put(ProductFeature.IMPORT_SELENIUM_IDE_V3, Boolean.TRUE);
        features.put(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT, Boolean.TRUE);
        features.put(ProductFeature.TEST_OBJECT_REFACTORING, Boolean.TRUE);
        features.put(ProductFeature.SELF_HEALING, Boolean.TRUE);
        features.put(ProductFeature.SMART_LOCATOR, Boolean.TRUE);
        features.put(ProductFeature.IMAGE_LOCATOR, Boolean.TRUE);
        features.put(ProductFeature.GUI, Boolean.TRUE);
        features.put(ProductFeature.ONLINE_PAID_PLUGINS, Boolean.TRUE);
        features.put(ProductFeature.GIT_SSH, Boolean.TRUE);
        features.put(ProductFeature.PRIVATE_PLUGIN, 1);
        features.put(ProductFeature.TEST_SUITE_CREATIONS_LIMIT, FeatureConstants.UNLIMITED_QUOTA);
        features.put(ProductFeature.AI_FAILURE_ANALYSIS, Boolean.TRUE);
        return features;
    }
}

