/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureChatExtensionConfiguration;
import com.azure.ai.openai.models.AzureChatExtensionType;
import com.azure.ai.openai.models.AzureCosmosDBChatExtensionParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureCosmosDBChatExtensionConfiguration
extends AzureChatExtensionConfiguration {
    private final AzureCosmosDBChatExtensionParameters parameters;
    private AzureChatExtensionType type = AzureChatExtensionType.AZURE_COSMOS_DB;

    public AzureCosmosDBChatExtensionParameters getParameters() {
        return this.parameters;
    }

    public AzureCosmosDBChatExtensionConfiguration(AzureCosmosDBChatExtensionParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public AzureChatExtensionType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureCosmosDBChatExtensionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AzureCosmosDBChatExtensionConfiguration)jsonReader.readObject(reader -> {
            AzureCosmosDBChatExtensionParameters parameters = null;
            AzureChatExtensionType type = AzureChatExtensionType.AZURE_COSMOS_DB;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    parameters = AzureCosmosDBChatExtensionParameters.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = AzureChatExtensionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            AzureCosmosDBChatExtensionConfiguration deserializedAzureCosmosDBChatExtensionConfiguration = new AzureCosmosDBChatExtensionConfiguration(parameters);
            deserializedAzureCosmosDBChatExtensionConfiguration.type = type;
            return deserializedAzureCosmosDBChatExtensionConfiguration;
        });
    }
}

