/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatRequestSystemMessage
extends ChatRequestMessage {
    private final BinaryData content;
    private final String stringContent;
    private final List<ChatMessageContentItem> chatMessageContentItem;
    private String name;
    private ChatRole role = ChatRole.SYSTEM;

    public BinaryData getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public ChatRequestSystemMessage setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.stringContent != null) {
            jsonWriter.writeStringField("content", this.stringContent);
        } else if (this.chatMessageContentItem != null) {
            jsonWriter.writeArrayField("content", this.chatMessageContentItem, JsonWriter::writeJson);
        }
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestSystemMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestSystemMessage)jsonReader.readObject(reader -> {
            BinaryData content = null;
            ChatRole role = ChatRole.SYSTEM;
            String name = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    if (reader.currentToken() == JsonToken.STRING) {
                        content = BinaryData.fromString((String)reader.getString());
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.START_ARRAY) {
                        content = BinaryData.fromObject((Object)reader.readArray(arrayReader -> (ChatMessageContentItem)arrayReader.readObject(ChatMessageContentItem::fromJson)));
                        continue;
                    }
                    throw new IllegalStateException("Unexpected 'content' type found when deserializing ChatRequestSystemMessage JSON object: " + reader.currentToken());
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestSystemMessage deserializedChatRequestSystemMessage = new ChatRequestSystemMessage(content);
            deserializedChatRequestSystemMessage.role = role;
            deserializedChatRequestSystemMessage.name = name;
            return deserializedChatRequestSystemMessage;
        });
    }

    private ChatRequestSystemMessage(BinaryData content) {
        this.content = content;
        this.stringContent = null;
        this.chatMessageContentItem = null;
    }

    public ChatRequestSystemMessage(String content) {
        this.content = BinaryData.fromString((String)content);
        this.stringContent = content;
        this.chatMessageContentItem = null;
    }

    public ChatRequestSystemMessage(List<ChatMessageContentItem> content) {
        this.content = BinaryData.fromObject(content);
        this.stringContent = null;
        this.chatMessageContentItem = content;
    }
}

