/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ChatRequestUserMessage
extends ChatRequestMessage {
    private final BinaryData content;
    private final String stringContent;
    private final List<ChatMessageContentItem> chatMessageContentItems;
    private String name;
    private ChatRole role = ChatRole.USER;

    private ChatRequestUserMessage(BinaryData content) {
        this.content = content;
        this.stringContent = null;
        this.chatMessageContentItems = null;
    }

    public ChatRequestUserMessage(String content) {
        this.content = BinaryData.fromString((String)content);
        this.stringContent = content;
        this.chatMessageContentItems = null;
    }

    public ChatRequestUserMessage(ChatMessageContentItem[] content) {
        this.content = BinaryData.fromObject((Object)content);
        this.chatMessageContentItems = Arrays.asList(content);
        this.stringContent = null;
    }

    public ChatRequestUserMessage(List<ChatMessageContentItem> content) {
        this.content = BinaryData.fromObject(content);
        this.stringContent = null;
        this.chatMessageContentItems = content;
    }

    public BinaryData getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public ChatRequestUserMessage setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        if (this.stringContent != null) {
            jsonWriter.writeStringField("content", this.stringContent);
        } else if (this.chatMessageContentItems != null) {
            jsonWriter.writeArrayField("content", this.chatMessageContentItems, JsonWriter::writeJson);
        }
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestUserMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestUserMessage)jsonReader.readObject(reader -> {
            BinaryData content = null;
            ChatRole role = ChatRole.USER;
            String name = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    if (reader.currentToken() == JsonToken.STRING) {
                        content = BinaryData.fromString((String)reader.getString());
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.START_ARRAY) {
                        content = BinaryData.fromObject((Object)reader.readArray(arrayReader -> (ChatMessageContentItem)arrayReader.readObject(ChatMessageContentItem::fromJson)));
                        continue;
                    }
                    throw new IllegalStateException("Unexpected 'content' type found when deserializing ChatRequestUserMessage JSON object: " + reader.currentToken());
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestUserMessage deserializedChatRequestUserMessage = new ChatRequestUserMessage(content);
            deserializedChatRequestUserMessage.role = role;
            deserializedChatRequestUserMessage.name = name;
            return deserializedChatRequestUserMessage;
        });
    }
}

