/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.compiler;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;

public class CompilerCheckerParticipant
extends CompilationParticipant {
    public static final String COMPILER_MISMATCH_PROBLEM = "org.codehaus.groovy.eclipse.core.compilerMismatch";

    public boolean isActive(IJavaProject javaProject) {
        if (GroovyNature.hasGroovyNature((IProject)javaProject.getProject())) {
            IEclipsePreferences workspacePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.groovy.core");
            return workspacePreferences.getBoolean("groovy.check.for.compiler.mismatch", true);
        }
        return false;
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        if (files == null || files.length == 0) {
            return;
        }
        IProject project = files[0].getFile().getProject();
        SpecifiedVersion projectLevel = CompilerUtils.getCompilerLevel(project);
        try {
            boolean compilerMatch = CompilerUtils.projectVersionMatchesWorkspaceVersion(projectLevel);
            IMarker[] markers = project.findMarkers(COMPILER_MISMATCH_PROBLEM, true, 0);
            if (compilerMatch) {
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    marker.delete();
                    ++n2;
                }
            } else if (markers.length == 0) {
                CompilerUtils.addCompilerMismatchError(project, projectLevel);
            }
        }
        catch (CoreException e) {
            GroovyCore.logException("Error creating/deleting marker(s)", e);
        }
    }

    public void cleanStarting(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = project.findMarkers(COMPILER_MISMATCH_PROBLEM, true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                marker.delete();
                ++n2;
            }
        }
        catch (CoreException e) {
            GroovyCore.logException("Error deleting markers", e);
        }
    }

    public void buildFinished(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        try {
            SpecifiedVersion projectLevel = CompilerUtils.getCompilerLevel(project);
            if (projectLevel == SpecifiedVersion.DONT_CARE) {
                return;
            }
            if (projectLevel == SpecifiedVersion.UNSPECIFIED) {
                IClasspathEntry[] classpath = javaProject.getResolvedClasspath(true);
                SpecifiedVersion found1 = null;
                SpecifiedVersion found2 = null;
                IClasspathEntry[] iClasspathEntryArray = classpath;
                int n = classpath.length;
                int n2 = 0;
                while (n2 < n) {
                    String jarName;
                    SpecifiedVersion inferredProjectLevel;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 1 && (inferredProjectLevel = SpecifiedVersion.parseVersion((String)(jarName = entry.getPath().lastSegment()))) != SpecifiedVersion.UNSPECIFIED) {
                        if (found1 == null) {
                            found1 = inferredProjectLevel;
                        } else if (found2 == null && inferredProjectLevel != found1) {
                            found2 = inferredProjectLevel;
                            CompilerUtils.addMultipleCompilersOnClasspathError(project, found1, found2);
                        }
                    }
                    ++n2;
                }
                if (found1 != null && found2 == null) {
                    CompilerUtils.setCompilerLevel(project, found1);
                }
            }
        }
        catch (CoreException e) {
            GroovyCore.logException("Exception thrown while inferring project " + project.getName() + "'s groovy compiler level.", e);
        }
    }
}

