/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.compiler;

import java.util.Iterator;
import java.util.UUID;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.CompilationUnitResolver;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;

public class GroovySnippetCompiler {
    private CompilerOptions compilerOptions;
    private INameEnvironment nameEnvironment;

    public GroovySnippetCompiler(JavaProject project) {
        try {
            this.compilerOptions = new CompilerOptions(project.getOptions(true));
            this.nameEnvironment = new SearchableEnvironment(project, null, false);
        }
        catch (JavaModelException e) {
            GroovyCore.logException("Problem initializing snippet compiler for project " + project.getElementName(), e);
        }
    }

    public ModuleNode compile(String source) {
        return this.compile(source, null);
    }

    public ModuleNode compile(String source, String sourcePath) {
        GroovyCompilationUnitDeclaration decl = this.internalCompile(source, sourcePath);
        ModuleNode node = decl.getModuleNode();
        for (ClassNode classNode : node.getClasses()) {
            Iterator methodIter = classNode.getMethods().iterator();
            while (methodIter.hasNext()) {
                MethodNode method = (MethodNode)methodIter.next();
                if (!GroovyUtils.isSynthetic((MethodNode)method)) continue;
                methodIter.remove();
            }
        }
        return node;
    }

    public CompilationResult compileForErrors(String source, String sourcePath) {
        GroovyCompilationUnitDeclaration unit = this.internalCompile(source, sourcePath);
        return unit.compilationResult();
    }

    private GroovyCompilationUnitDeclaration internalCompile(String source, String sourcePath) {
        if (sourcePath == null) {
            sourcePath = "Snippet" + UUID.randomUUID().toString().replaceAll("-", "") + ".groovy";
        } else if (!ContentTypeUtils.isGroovyLikeFileName((CharSequence)sourcePath)) {
            sourcePath = ((String)sourcePath).concat(".groovy");
        }
        CompilationUnitResolver compiler = new CompilationUnitResolver(this.nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, result -> {}, (IProblemFactory)new DefaultProblemFactory(), null, true);
        BasicCompilationUnit unit = new BasicCompilationUnit(source.toCharArray(), CharOperation.NO_CHAR_CHAR, (String)sourcePath, null);
        GroovyCompilationUnitDeclaration decl = (GroovyCompilationUnitDeclaration)compiler.resolve((ICompilationUnit)unit, true, false, false);
        return decl;
    }

    public void cleanup() {
        this.nameEnvironment.cleanup();
    }
}

