/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.util;

import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.codehaus.groovy.eclipse.core.impl.StringSourceBuffer;
import org.codehaus.groovy.eclipse.core.util.ParseException;
import org.codehaus.groovy.eclipse.core.util.Token;
import org.codehaus.groovy.eclipse.core.util.TokenStream;
import org.codehaus.groovy.eclipse.core.util.TokenStreamException;

public class ExpressionFinder {
    public String[] splitForCompletion(String expression) {
        String[] result = this.splitForCompletionNoTrim(expression);
        if (result[0] != null) {
            result[0] = result[0].trim();
            if (result[0].startsWith("$")) {
                result[0] = result[0].substring(1);
            }
        }
        if (result[1] != null) {
            result[1] = result[1].trim();
            if (result[1].startsWith("$")) {
                result[1] = result[1].substring(1);
            }
        }
        return result;
    }

    public String[] splitForCompletionNoTrim(String expression) {
        String[] stringArray = new String[2];
        stringArray[0] = "";
        String[] result = stringArray;
        if (!expression.trim().isEmpty()) {
            TokenStream stream = new TokenStream(new StringSourceBuffer(expression), expression.length() - 1);
            try {
                ExpressionFinder.skipLineBreaksAndComments(stream);
                Token token0 = stream.next();
                ExpressionFinder.skipLineBreaksAndComments(stream);
                Token token1 = stream.next();
                ExpressionFinder.skipLineBreaksAndComments(stream);
                Token token2 = stream.next();
                if (token0.isDotAccess() && token1.isValidBeforeDot()) {
                    result[0] = expression.substring(0, token1.endOffset);
                    result[1] = "";
                } else if (token0.isType(Token.Type.IDENT) && token1.isDotAccess() && token2.isValidBeforeDot()) {
                    result[0] = expression.substring(0, token2.endOffset);
                    result[1] = expression.substring(token0.startOffset, expression.length());
                } else if (token0.isType(Token.Type.IDENT)) {
                    result[0] = expression;
                }
            }
            catch (IllegalStateException | NullPointerException | TokenStreamException exception) {
                // empty catch block
            }
        }
        return result;
    }

    public int findTokenEnd(ISourceBuffer buffer, int offset) {
        int result = offset;
        while (buffer.length() > result) {
            if (!Character.isJavaIdentifierPart(buffer.charAt(result))) break;
            ++result;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String findForCompletions(ISourceBuffer buffer, int offset) throws ParseException {
        Token token = null;
        int endOffset = 0;
        TokenStream stream = new TokenStream(buffer, offset);
        try {
            token = stream.peek();
            if (token == null) return null;
            if (token.isType(Token.Type.EOF)) {
                return null;
            }
            endOffset = token.endOffset;
            boolean offsetIsWhitespace = Character.isWhitespace(stream.getCurrentChar());
            if (stream.getCurrentChar() == '\"') return null;
            if (stream.getCurrentChar() == '\'') return null;
            boolean bl = false;
            boolean offsetIsQuote = bl;
            if (offsetIsQuote) {
                return null;
            }
            ExpressionFinder.skipLineBreaksAndComments(stream);
            token = stream.next();
            if (offsetIsWhitespace && !token.isDotAccess() && !token.isType(Token.Type.DOUBLE_DOT)) {
                return "";
            }
            if ("@".equals(token.text)) {
                return "@";
            }
            switch (token.getType()) {
                case EOF: {
                    return null;
                }
                case DOT: 
                case DOUBLE_DOT: 
                case SAFE_DEREF: 
                case SPREAD: 
                case FIELD_ACCESS: 
                case METHOD_POINTER: {
                    token = ExpressionFinder.dot(stream);
                    break;
                }
                case IDENT: {
                    token = ExpressionFinder.ident(stream);
                    break;
                }
                case BRACK_BLOCK: {
                    return "";
                }
                default: {
                    throw new ParseException(token);
                }
            }
        }
        catch (TokenStreamException e) {
            Token last = stream.last();
            if (last != null) {
                token = last;
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (token == null) return "";
        return buffer.subSequence(token.startOffset, endOffset).toString();
    }

    /*
     * Unable to fully structure code
     */
    public NameAndLocation findPreviousTypeNameToken(ISourceBuffer buffer, int start) {
        current = Math.min(start, buffer.length()) - 1;
        while (current >= 0 && !Character.isWhitespace(buffer.charAt(current)) && Character.isJavaIdentifierPart(buffer.charAt(current))) {
            --current;
        }
        if (current < 0 || !Character.isWhitespace(buffer.charAt(current))) {
            return null;
        }
        sb = new StringBuilder();
        while (current >= 0 && (Character.isWhitespace(buffer.charAt(current)) || buffer.charAt(current) == '[' || buffer.charAt(current) == ']') && buffer.charAt(current) != '\n' && buffer.charAt(current) != '\r') {
            sb.append(buffer.charAt(current--));
        }
        if (current >= 0 && Character.isJavaIdentifierPart(buffer.charAt(current))) ** GOTO lbl16
        return null;
lbl-1000:
        // 1 sources

        {
            sb.append(buffer.charAt(current--));
lbl16:
            // 2 sources

            ** while (current >= 0 && Character.isJavaIdentifierPart((char)buffer.charAt((int)current)))
        }
lbl17:
        // 1 sources

        if (sb.length() > 0) {
            return new NameAndLocation(sb.reverse().toString(), current + 1);
        }
        return null;
    }

    private static Token dot(TokenStream stream) throws TokenStreamException, ParseException {
        ExpressionFinder.skipLineBreaksAndComments(stream);
        Token token = stream.next();
        switch (token.getType()) {
            case IDENT: {
                return ExpressionFinder.ident(stream);
            }
            case BRACE_BLOCK: {
                return ExpressionFinder.braceBlock(stream);
            }
            case BRACK_BLOCK: {
                return ExpressionFinder.brackBlock(stream);
            }
            case PAREN_BLOCK: {
                return ExpressionFinder.parenBlock(stream);
            }
            case QUOTED_STRING: {
                return ExpressionFinder.quotedString(stream);
            }
        }
        throw new ParseException(token);
    }

    private static Token ident(TokenStream stream) throws TokenStreamException, ParseException {
        Token last = stream.last();
        Token token = ExpressionFinder.peek(stream);
        switch (token.getType()) {
            case LINE_BREAK: {
                ExpressionFinder.skipLineBreaksAndComments(stream);
                if (!ExpressionFinder.peek(stream).isDotAccess()) break;
                stream.next();
                return ExpressionFinder.dot(stream);
            }
            case DOUBLE_DOT: {
                break;
            }
            case DOT: 
            case SAFE_DEREF: 
            case SPREAD: 
            case FIELD_ACCESS: 
            case METHOD_POINTER: {
                stream.next();
                return ExpressionFinder.dot(stream);
            }
            case IDENT: {
                if (!"new".equals(token.text)) break;
                return ExpressionFinder.stop(stream.next());
            }
        }
        return ExpressionFinder.stop(last);
    }

    private static Token braceBlock(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.next();
        switch (token.getType()) {
            case IDENT: {
                return ExpressionFinder.ident(stream);
            }
            case PAREN_BLOCK: {
                return ExpressionFinder.parenBlock(stream);
            }
        }
        throw new ParseException(token);
    }

    private static Token brackBlock(TokenStream stream) throws TokenStreamException, ParseException {
        Token last = stream.last();
        Token token = stream.next();
        switch (token.getType()) {
            case EOF: {
                return ExpressionFinder.stop(last);
            }
            case SEMI: 
            case LINE_BREAK: {
                return stream.last();
            }
            case IDENT: {
                return ExpressionFinder.ident(stream);
            }
            case BRACE_BLOCK: {
                return ExpressionFinder.braceBlock(stream);
            }
            case BRACK_BLOCK: {
                return ExpressionFinder.brackBlock(stream);
            }
            case PAREN_BLOCK: {
                return ExpressionFinder.parenBlock(stream);
            }
        }
        throw new ParseException(token);
    }

    private static Token parenBlock(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.peek();
        switch (token.getType()) {
            case IDENT: {
                stream.next();
                return ExpressionFinder.ident(stream);
            }
            case EOF: 
            case SEMI: 
            case LINE_BREAK: {
                return stream.last();
            }
        }
        throw new ParseException(token);
    }

    private static Token quotedString(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.peek();
        switch (token.getType()) {
            case EOF: 
            case IDENT: 
            case SEMI: 
            case LINE_BREAK: {
                return ExpressionFinder.stop(stream.last());
            }
        }
        throw new ParseException(token);
    }

    private static void skipLineBreaksAndComments(TokenStream stream) throws TokenStreamException {
        while (ExpressionFinder.peek(stream).isType(Token.Type.LINE_BREAK)) {
            stream.next();
        }
        while (ExpressionFinder.peek(stream).isType(Token.Type.LINE_COMMENT)) {
            stream.next();
        }
    }

    private static Token peek(TokenStream stream) throws TokenStreamException {
        Token token = stream.peek();
        return token != null ? token : ExpressionFinder.stop(stream.last());
    }

    private static Token stop(Token token) throws TokenStreamException {
        return new Token(Token.Type.EOF, token.startOffset, token.endOffset, null);
    }

    public static class NameAndLocation {
        public final String name;
        public final int location;

        public NameAndLocation(String name, int locaiton) {
            this.name = name;
            this.location = locaiton;
        }

        public String toTypeName() {
            int i = 0;
            StringBuilder sb = new StringBuilder();
            while (i < this.name.length() && Character.isJavaIdentifierPart(this.name.charAt(i))) {
                sb.append(this.name.charAt(i++));
            }
            return sb.toString();
        }

        public int dims() {
            int i = 0;
            int dims = 0;
            while (i < this.name.length()) {
                if (this.name.charAt(i++) != ']') continue;
                ++dims;
            }
            return dims;
        }
    }
}

