/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testops.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.composer.testops.service.ZonedDateTimeAdapter;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsTeam;
import com.kms.katalon.testops.core.model.AnalyticsTestProject;
import com.kms.katalon.testops.core.model.GitRepositoryEntity;
import com.kms.katalon.testops.core.services.ITestOpsSettingStore;
import com.kms.katalon.util.CryptoUtil;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Creatable
public class AnalyticsSettingStore
extends BundleSettingStore
implements ITestOpsSettingStore {
    private static String BUNDLE_ID = "com.kms.katalon.integration.analytics";
    @Inject
    private IDiscoveryController discoveryController;

    public static AnalyticsSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return AnalyticsSettingStore.getStore(projectEntity.getLocation());
    }

    public static AnalyticsSettingStore getStore(String projectDir) {
        Path path = Paths.get(projectDir, new String[0]);
        if (path.toString().endsWith(".prj")) {
            path = path.getParent();
        }
        AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(path.toString());
        BundleContext bundleContext = FrameworkUtil.getBundle(AnalyticsSettingStore.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ContextInjectionFactory.inject((Object)((Object)analyticsSettingStore), (IEclipseContext)context);
        return analyticsSettingStore;
    }

    public AnalyticsSettingStore(String projectDir) {
        super(projectDir, BUNDLE_ID, false);
    }

    public void enableAutoUploadReport(boolean enabled) throws IOException {
        this.setProperty("analytics.testreport.autoupload.enable", enabled);
    }

    public void enableIntegration(boolean enabled) throws IOException {
        this.setProperty("analytics.integration.enable", enabled);
    }

    public void enableOverrideAuthentication(boolean isEnableOverride) throws IOException {
        this.setProperty("analytics.onpremise.enable", isEnableOverride);
    }

    public void enableTestCloudIntegration(boolean enabled) throws IOException {
        this.setProperty("analytics.testcloud.integration.enable", enabled);
    }

    public String getEmail() {
        try {
            return this.getString("onpremise.email", "");
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return "";
        }
    }

    public GitRepositoryEntity getGitRepositoryEntity() {
        try {
            String gitRepoJson = this.getString("analytics.git", "");
            if (StringUtils.isNotBlank((String)gitRepoJson) || !StringUtils.contains((String)gitRepoJson, (String)"null")) {
                GitRepositoryEntity gitRepo = new GitRepositoryEntity();
                gitRepo = (GitRepositoryEntity)JsonUtil.fromJson((String)gitRepoJson, GitRepositoryEntity.class);
                return gitRepo;
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    public AnalyticsTestProject getLastLinkedTestProject() {
        try {
            return (AnalyticsTestProject)JsonUtil.fromJson((String)this.getString("analytics.test.project.last.linked", null), AnalyticsTestProject.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AnalyticsProject getManualProject() {
        try {
            String projectJson = this.getString("analytics.manual.project", "");
            if (StringUtils.isNotBlank((String)projectJson) || !StringUtils.contains((String)projectJson, (String)"null")) {
                AnalyticsProject project = new AnalyticsProject();
                project = (AnalyticsProject)JsonUtil.fromJson((String)projectJson, AnalyticsProject.class);
                return project;
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return this.getProject();
    }

    public AnalyticsTeam getManualTeam() {
        try {
            String teamJson = this.getString("analytics.manual.team", "");
            if (StringUtils.isNotBlank((String)teamJson)) {
                AnalyticsTeam team = new AnalyticsTeam();
                team = (AnalyticsTeam)JsonUtil.fromJson((String)teamJson, AnalyticsTeam.class);
                return team;
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return this.getTeam();
    }

    public Organization getOrganization() {
        try {
            String orgJson = this.getString("analytics.onpremise.organization", "");
            if (StringUtils.isNotBlank((String)orgJson)) {
                Gson gson = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).create();
                return (Organization)gson.fromJson(orgJson, Organization.class);
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    public String getPassword() {
        try {
            String encryptedPassword = this.getString("onpremise.password", "");
            if (!StringUtils.isEmpty((String)encryptedPassword)) {
                return CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)encryptedPassword));
            }
        }
        catch (IOException | GeneralSecurityException e) {
            LogUtil.logError((Throwable)e);
        }
        return "";
    }

    public AnalyticsProject getProject() {
        try {
            String json = this.getString("analytics.project", "");
            if (StringUtils.isNotBlank((String)json)) {
                return (AnalyticsProject)JsonUtil.fromJson((String)json, AnalyticsProject.class);
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    public String getServerEndpoint() {
        try {
            return this.getString("analytics.onpremise.server", this.discoveryController.getServerUrl(ServerType.TESTOPS));
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    public AnalyticsTeam getTeam() {
        try {
            String json = this.getString("analytics.team", "");
            if (StringUtils.isNotBlank((String)json)) {
                return (AnalyticsTeam)JsonUtil.fromJson((String)json, AnalyticsTeam.class);
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    public String getTestCloudServer() {
        try {
            return this.getString("testcloud.server", this.discoveryController.getServerUrl(ServerType.TESTCLOUD));
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    public String getToken() throws IOException, GeneralSecurityException {
        return this.getStringProperty("analytics.authentication.token", "", true);
    }

    public boolean isAttachCapturedVideos() throws IOException {
        return this.getBoolean("analytics.testresult.attach.capturedvideos", false);
    }

    public boolean isAttachLog() throws IOException {
        return this.getBoolean("analytics.testresult.attach.log", false);
    }

    public boolean isAttachScreenshot() throws IOException {
        return this.getBoolean("analytics.testresult.attach.screenshot", false);
    }

    public boolean isAutoSubmit() throws IOException {
        return this.getBoolean("analytics.testresult.autosubmit", false);
    }

    public boolean isAutoUploadReportEnabled() {
        try {
            return this.getBoolean("analytics.testreport.autoupload.enable", true);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public boolean isIntegrationEnabled() {
        try {
            return this.getBoolean("analytics.integration.enable", false);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public boolean isOverrideAuthenticationEnabled() {
        try {
            return this.getBoolean("analytics.onpremise.enable", false);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isTestCloudIntegrationEnabled() {
        try {
            return this.getBoolean("analytics.testcloud.integration.enable", true);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public boolean isSwitchToTestCloudHubEnabled() {
        try {
            return this.getBoolean("analytics.testcloud.hub.switchHub.enable", false);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void enableSwitchToTestCloudHub(boolean enabled) throws IOException {
        this.setProperty("analytics.testcloud.hub.switchHub.enable", enabled);
    }

    public void removeProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("analytics.server.endpoint");
        properties.add("testcloud.server");
        properties.add("analytics.authentication.email");
        properties.add("analytics.authentication.password");
        properties.add("analytics.testresult.autosubmit");
        properties.add("analytics.testresult.attach.screenshot");
        properties.add("analytics.testresult.attach.log");
        properties.add("analytics.testresult.attach.capturedvideos");
        properties.add("analytics.authentication.encryptionEnabled");
        try {
            this.removeProperties(properties);
        }
        catch (IOException iOException) {}
    }

    public void setAttachCapturedVideos(boolean capturedVideos) throws IOException {
        this.setProperty("analytics.testresult.attach.capturedvideos", capturedVideos);
    }

    public void setAttachLog(boolean attachLog) throws IOException {
        this.setProperty("analytics.testresult.attach.log", attachLog);
    }

    public void setAttachScreenshot(boolean attachScreenshot) throws IOException {
        this.setProperty("analytics.testresult.attach.screenshot", attachScreenshot);
    }

    public void setAutoSubmit(boolean autoSubmit) throws IOException {
        this.setProperty("analytics.testresult.autosubmit", autoSubmit);
    }

    public void setEmail(String email) throws IOException {
        this.setProperty("onpremise.email", email);
    }

    public void setGitRepositoryEntity(GitRepositoryEntity gitRepositoryEntity) throws IOException {
        this.setProperty("analytics.git", JsonUtil.toJson((Object)gitRepositoryEntity));
    }

    public void setLastLinkedTestProject(AnalyticsTestProject testProject) throws IOException {
        this.setProperty("analytics.test.project.last.linked", JsonUtil.toJson((Object)testProject));
    }

    public void setManualProject(AnalyticsProject project) throws IOException {
        this.setProperty("analytics.manual.project", JsonUtil.toJson((Object)project));
    }

    public void setManualTeam(AnalyticsTeam team) throws IOException {
        this.setProperty("analytics.manual.team", JsonUtil.toJson((Object)team));
    }

    public void setOrganization(Organization organization) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).create();
        this.setProperty("analytics.onpremise.organization", gson.toJson((Object)organization));
    }

    public void setPassword(String rawPassword) throws GeneralSecurityException, IOException {
        String encryptedPassword = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)rawPassword));
        this.setProperty("onpremise.password", encryptedPassword);
    }

    public void setProject(AnalyticsProject project) throws IOException {
        this.setProperty("analytics.project", JsonUtil.toJson((Object)project));
    }

    public void setServerEndPoint(String serverUrl) throws IOException {
        this.setProperty("analytics.onpremise.server", serverUrl);
    }

    public void setTeam(AnalyticsTeam team) throws IOException {
        this.setProperty("analytics.team", JsonUtil.toJson((Object)team));
    }

    public void setTestCloudServer(String serverUrl) throws IOException {
        if (Objects.nonNull(serverUrl)) {
            this.setProperty("testcloud.server", serverUrl);
        } else {
            ArrayList<String> properties = new ArrayList<String>(Arrays.asList("testcloud.server"));
            try {
                this.removeProperties(properties);
            }
            catch (IOException iOException) {}
        }
    }

    public void setToken(String token) throws IOException, GeneralSecurityException {
        this.setStringProperty("analytics.authentication.token", token, true);
    }
}

