/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.preferences;

import com.kms.katalon.composer.components.dialogs.FieldEditorPreferencePageWithHelp;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.MessageComponentBuilder;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.helper.UIEventController;
import com.kms.katalon.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.Project;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.User;
import com.kms.katalon.session.core.model.UserInfo;
import com.kms.katalon.session.core.model.UserOrganizationRole;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.testcloud.core.model.TestCloudConfiguration;
import com.kms.katalon.testcloud.core.model.TestCloudSessionTypes;
import com.kms.katalon.testcloud.core.model.exception.TestCloudAPIException;
import com.kms.katalon.testcloud.core.service.ITestCloudController;
import com.kms.katalon.testcloud.util.TestCloudModelParser;
import com.kms.katalon.testops.core.model.AnalyticsAuthenticationSetting;
import com.kms.katalon.testops.core.model.AnalyticsIntegrationSetting;
import com.kms.katalon.testops.core.model.AnalyticsSetting;
import com.kms.katalon.testops.core.model.TestOpsRequestOptions;
import com.kms.katalon.testops.core.model.TestOpsSession;
import com.kms.katalon.testops.core.model.exception.TestOpsException;
import com.kms.katalon.testops.core.model.exception.TestOpsPreferencesException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.testops.core.services.ITestOpsPreferences;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsPreferencesPage
extends FieldEditorPreferencePageWithHelp {
    private Logger logger = LoggerFactory.getLogger(AnalyticsPreferencesPage.class);
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ITestCloudController testCloudController;
    @Inject
    private ISessionController sessionController;
    @Inject
    private ITestOpsController testOpsController;
    @Inject
    private IDiscoveryController discoveryController;
    @Inject
    private ITestOpsPreferences testOpsPreferences;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private Composite container;
    private Composite mainComposite;
    private Button btnRefresh;
    private Button btnConnect;
    private Button enableAnalyticsIntegration;
    private Button enableOverrideAuthentication;
    private Button enableTestCloudIntegration;
    private Button autoUploadTestReports;
    private Button enableSwitchToTestCloudHub;
    private Text txtServerUrl;
    private Text txtEmail;
    private Text txtPassword;
    private Link lblStatus;
    private Label lblStatusOnPremise;
    private Combo cbbOrganizations;
    private Combo cbbProjects;
    private List<Project> projects = new ArrayList<Project>();
    private List<Organization> organizations = new ArrayList<Organization>();
    private Button btnCreate;
    private String email;
    private String password;
    private String testOpsServerUrl;
    private boolean isIntegrationEnabled = false;
    private boolean isAuthenticationEnabled = false;
    private boolean fetchingOrganizations = false;
    private Composite infoContainer;
    private Group grpAuthentication;
    private Group grpIntegration;
    private AnalyticsSetting setting;
    private TestOpsSession session;
    private Organization organization;
    private Project project;
    private boolean testCloudAutomationNewHubEnabled;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.mainComposite = new Composite(this.container, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glMainComposite = new GridLayout(1, false);
        glMainComposite.marginWidth = 0;
        glMainComposite.marginHeight = 0;
        this.mainComposite.setLayout((Layout)glMainComposite);
        this.createInfoGroup();
        this.createAuthenticationGroup();
        this.createIntegrationGroup();
        this.lblStatus = new Link(this.mainComposite, 64);
        GridData gdStatus = new GridData(4, 0x1000000, true, false, 1, 1);
        gdStatus.heightHint = 40;
        this.lblStatus.setLayoutData((Object)gdStatus);
        this.addListeners();
        this.initialize();
        return this.container;
    }

    private void createInfoGroup() {
        this.infoContainer = MessageComponentBuilder.create().parent(this.mainComposite).message(ComposerIntegrationAnalyticsMessageConstants.MSG_SETUP_ACCOUNT_REQUEST).infoStyle().build();
    }

    private void createAuthenticationGroup() {
        this.grpAuthentication = new Group(this.mainComposite, 0);
        this.grpAuthentication.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glGrpAuthentication = new GridLayout(2, false);
        glGrpAuthentication.horizontalSpacing = 15;
        this.grpAuthentication.setLayout((Layout)glGrpAuthentication);
        this.grpAuthentication.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_AUTHENTICATE_GROUP);
        this.enableOverrideAuthentication = new Button((Composite)this.grpAuthentication, 32);
        this.enableOverrideAuthentication.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.enableOverrideAuthentication.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_OVERRIDE_AUTHENTICATION);
        Label lblServerUrl = new Label((Composite)this.grpAuthentication, 0);
        lblServerUrl.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_SERVER_URL);
        this.txtServerUrl = new Text((Composite)this.grpAuthentication, 2048);
        this.txtServerUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtServerUrl.addModifyListener(e -> this.onServerUrlChanged());
        Label lblEmail = new Label((Composite)this.grpAuthentication, 0);
        lblEmail.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_EMAIL);
        this.txtEmail = new Text((Composite)this.grpAuthentication, 2048);
        this.txtEmail.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtEmail.addModifyListener(e -> this.onEmailChanged());
        Label lblPassword = new Label((Composite)this.grpAuthentication, 0);
        lblPassword.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PASSWORD);
        this.txtPassword = new Text((Composite)this.grpAuthentication, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtPassword.addModifyListener(e -> this.onPasswordChanged());
        this.btnConnect = new Button((Composite)this.grpAuthentication, 0);
        this.btnConnect.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnConnect.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_FETCH_ORGANIZATION);
        this.lblStatusOnPremise = new Label((Composite)this.grpAuthentication, 64);
        this.lblStatusOnPremise.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblOrganization = new Label((Composite)this.grpAuthentication, 0);
        lblOrganization.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_ORGANIZATION);
        this.cbbOrganizations = new Combo((Composite)this.grpAuthentication, 8);
        this.cbbOrganizations.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void createIntegrationGroup() {
        this.grpIntegration = new Group(this.mainComposite, 0);
        this.grpIntegration.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.grpIntegration.setLayout((Layout)new GridLayout(4, false));
        this.grpIntegration.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_INTEGRATION);
        this.enableAnalyticsIntegration = new Button((Composite)this.grpIntegration, 32);
        this.enableAnalyticsIntegration.setLayoutData((Object)new GridData(4, 128, true, false, 4, 1));
        this.enableAnalyticsIntegration.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_ENABLE_PLATFORM_INTEGRATION);
        Label lblProject = new Label((Composite)this.grpIntegration, 0);
        lblProject.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PROJECT);
        this.cbbProjects = new Combo((Composite)this.grpIntegration, 8);
        this.cbbProjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cbbProjects.setEnabled(false);
        this.btnCreate = new Button((Composite)this.grpIntegration, 0);
        this.btnCreate.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnCreate.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_NEW_PROJECT);
        this.btnCreate.setEnabled(false);
        Composite compConnect = new Composite((Composite)this.grpIntegration, 0);
        compConnect.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        GridLayout glConnect = new GridLayout(4, false);
        glConnect.marginWidth = 0;
        compConnect.setLayout((Layout)glConnect);
        this.btnRefresh = new Button(compConnect, 0);
        GridData gdBtn = new GridData(4, 0x1000000, false, false, 1, 1);
        gdBtn.widthHint = 120;
        this.btnRefresh.setLayoutData((Object)gdBtn);
        this.btnRefresh.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_FETCH_PROJECT);
        this.btnRefresh.setEnabled(false);
        this.enableTestCloudIntegration = new Button((Composite)this.grpIntegration, 32);
        this.enableTestCloudIntegration.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.enableTestCloudIntegration.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_ENABLE_TESTCLOUD);
        this.enableTestCloudIntegration.setEnabled(false);
        this.enableSwitchToTestCloudHub = new Button((Composite)this.grpIntegration, 32);
        GridData gdRadio = new GridData(4, 2, true, false, 3, 1);
        gdRadio.horizontalIndent = 15;
        gdRadio.exclude = true;
        this.enableSwitchToTestCloudHub.setLayoutData((Object)gdRadio);
        this.enableSwitchToTestCloudHub.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_SWITCH_TO_TESTCLOUD_HUB);
        this.setButtonVisible(this.enableSwitchToTestCloudHub, this.testCloudAutomationNewHubEnabled);
        this.autoUploadTestReports = new Button((Composite)this.grpIntegration, 32);
        this.autoUploadTestReports.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.autoUploadTestReports.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_AUTO_UPLOAD_ALL_REPORTS);
        this.autoUploadTestReports.setEnabled(false);
    }

    private void setButtonVisible(Button button, boolean isVisibleEnable) {
        button.setVisible(isVisibleEnable);
        GridData gridData = (GridData)button.getLayoutData();
        gridData.exclude = !isVisibleEnable;
        Composite parent = button.getParent();
        parent.layout();
    }

    protected void initialize() {
        super.initialize();
        this.clearAuthenticationMessage();
        this.clearIntegrationMessage();
        Session session = this.sessionController.getSession();
        License license = session.getLicense();
        if (license != null && !license.isOffline()) {
            this.retrievalTestCloudSettings();
            ComponentUtil.hide((Control)this.infoContainer);
        }
        try {
            this.setting = this.testOpsPreferences.getSetting();
        }
        catch (TestOpsPreferencesException e) {
            throw new RuntimeException(e);
        }
        AnalyticsAuthenticationSetting authSetting = this.setting.getAuthentication();
        AnalyticsIntegrationSetting integrationSetting = this.setting.getIntegration();
        if (!this.testOpsController.canOverrideSession()) {
            this.grpAuthentication.setEnabled(false);
            this.enableOverrideAuthentication.setEnabled(false);
            this.isAuthenticationEnabled = false;
        } else {
            boolean bl = this.isAuthenticationEnabled = authSetting != null;
        }
        if (this.isAuthenticationEnabled) {
            this.testOpsServerUrl = authSetting.getServerUrl();
            this.email = (String)StringUtils.defaultIfBlank((CharSequence)authSetting.getEmail(), (CharSequence)"");
            this.password = (String)StringUtils.defaultIfBlank((CharSequence)authSetting.getPassword(), (CharSequence)"");
        } else {
            this.testOpsServerUrl = this.discoveryController.getServerUrl(ServerType.TESTOPS);
            User user = session.getUser();
            this.email = user != null ? user.getEmail() : "";
            this.password = "";
        }
        this.txtServerUrl.setText(this.testOpsServerUrl);
        this.txtEmail.setText(this.email);
        this.txtPassword.setText(this.password);
        if (this.isAuthenticationEnabled) {
            TestOpsRequestOptions requestOption = this.testOpsController.getRequestOptions(false);
            this.session = requestOption.getSession();
            this.organization = this.session != null ? this.session.getOrganization() : null;
        }
        this.enableOverrideAuthentication.setSelection(this.isAuthenticationEnabled);
        this.updateOverrideAuthenticationUI();
        if (!this.isAuthenticationEnabled && session.getLicense().isOffline()) {
            this.grpIntegration.setEnabled(false);
            this.isIntegrationEnabled = false;
        } else {
            boolean bl = this.isIntegrationEnabled = integrationSetting != null;
        }
        if (this.isIntegrationEnabled) {
            this.project = integrationSetting.getProject();
            this.enableTestCloudIntegration.setSelection(integrationSetting.isEnabledTestCloudIntegration());
            this.setButtonVisible(this.enableSwitchToTestCloudHub, this.testCloudAutomationNewHubEnabled && integrationSetting.isEnabledTestCloudIntegration());
            if (integrationSetting.isEnabledTestCloudIntegration() && this.testCloudAutomationNewHubEnabled) {
                this.enableSwitchToTestCloudHub.setSelection(integrationSetting.isEnableSwitchToTestCloudHub());
            }
            this.autoUploadTestReports.setSelection(integrationSetting.isAutoUploadReports());
        }
        this.enableAnalyticsIntegration.setSelection(this.isIntegrationEnabled);
        this.updateAnalyticsIntegrationUI(this.isIntegrationEnabled);
        this.reloadOverrideAuthentication(false);
    }

    private void retrievalTestCloudSettings() {
        this.testCloudAutomationNewHubEnabled = false;
        try {
            TestCloudConfiguration[] testCloudConfigurations = this.testCloudController.getConfigurations();
            this.testCloudAutomationNewHubEnabled = TestCloudModelParser.getConfigTestCloudAutomationHub((TestCloudConfiguration[])testCloudConfigurations);
        }
        catch (TestCloudAPIException e) {
            LoggerSingleton.logError((String)("TestCloud API: " + e.getMessage()));
        }
    }

    protected void createFieldEditors() {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initialize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performOk() {
        if (!this.isInitialized()) {
            return true;
        }
        try {
            AnalyticsSetting setting = new AnalyticsSetting();
            if (this.enableOverrideAuthentication.getSelection() && this.organization != null) {
                String serverUrl = this.txtServerUrl.getText();
                String email = this.txtEmail.getText();
                String password = this.txtPassword.getText();
                if (StringUtils.isBlank((CharSequence)serverUrl) || StringUtils.isBlank((CharSequence)email) || StringUtils.isBlank((CharSequence)password)) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.REPORT_MSG_MUST_ENTER_REQUIRED_INFORMATION);
                    return false;
                }
                int index = this.cbbOrganizations.getSelectionIndex();
                if (this.session == null || index == -1 || index >= this.organizations.size()) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.MSG_NO_ORGANIZATION);
                    return false;
                }
                AnalyticsAuthenticationSetting authSetting = new AnalyticsAuthenticationSetting();
                authSetting.setServerUrl(serverUrl);
                authSetting.setEmail(email);
                authSetting.setPassword(password);
                authSetting.setOrganization(this.organization);
                setting.setAuthentication(authSetting);
            }
            AnalyticsIntegrationSetting integrationSetting = null;
            if (this.enableAnalyticsIntegration.getSelection()) {
                int index = this.cbbProjects.getSelectionIndex();
                if (index == -1 || index >= this.projects.size()) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.REPORT_MSG_MUST_SET_PROJECT);
                    return false;
                }
                integrationSetting = new AnalyticsIntegrationSetting();
                integrationSetting.setProject(this.project);
                integrationSetting.setAutoUploadReports(this.autoUploadTestReports.getSelection());
                integrationSetting.setEnabledTestCloudIntegration(this.enableTestCloudIntegration.getSelection());
                if (this.enableSwitchToTestCloudHub != null && !this.enableSwitchToTestCloudHub.isDisposed() && this.enableTestCloudIntegration.getSelection()) {
                    integrationSetting.setEnableSwitchToTestCloudHub(this.enableSwitchToTestCloudHub.getSelection());
                }
                setting.setIntegration(integrationSetting);
            }
            this.testOpsPreferences.saveSetting(setting);
            this.testOpsController.useSession(this.session, integrationSetting);
            this.trackingPlatformIntegration(setting);
        }
        catch (TestOpsException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        this.eventBroker.post("EXPLORER/RELOAD_DATA", (Object)true);
        this.eventBroker.post("START_PAGE/RELOAD", (Object)true);
        this.eventBroker.post("SETTINGS/INTERGRATION/KATALON_ANALYTICS", (Object)true);
        UIEventController.getInstance().emitSettingsChange(UIEventController.SettingPage.TESTOPS);
        return super.performOk();
    }

    public boolean performCancel() {
        if (this.fetchingOrganizations) {
            return false;
        }
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.post("SETTINGS/INTERGRATION/KATALON_ANALYTICS", (Object)(this.isInitialized() && this.setting.getIntegration() != null ? 1 : 0));
        return super.performCancel();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty()) && event.getSource() == this.enableAnalyticsIntegration) {
            this.updateAnalyticsIntegrationUI(this.isIntegrationEnabled);
        }
        super.propertyChange(event);
    }

    private void onOverrideAuthenticationChanged() {
        if (!this.featureController.canUse(ProductFeature.OVERRIDE_TESTOPS_AUTHENTICATION)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.OVERRIDE_TESTOPS_AUTHENTICATION);
            this.isAuthenticationEnabled = false;
            this.updateOverrideAuthenticationUI();
            this.enableOverrideAuthentication.setSelection(this.isAuthenticationEnabled);
            return;
        }
        this.session = null;
        this.organization = null;
        this.isAuthenticationEnabled = this.enableOverrideAuthentication.getSelection();
        this.updateOverrideAuthenticationUI();
        this.reloadOverrideAuthentication(true);
        this.reloadAnalyticsIntegration(false, false);
    }

    private void onServerUrlChanged() {
        this.testOpsServerUrl = this.txtServerUrl.getText();
        this.session = null;
        this.organization = null;
        this.resetAuthentication();
        this.resetIntegration();
    }

    private void onEmailChanged() {
        this.email = this.txtEmail.getText();
        this.session = null;
        this.organization = null;
        this.resetAuthentication();
        this.resetIntegration();
    }

    private void onPasswordChanged() {
        this.password = this.txtPassword.getText();
        this.session = null;
        this.organization = null;
        this.resetAuthentication();
        this.resetIntegration();
    }

    private void onFetchOrganizations() {
        this.reloadOverrideAuthentication(true);
    }

    private void onOrganizationSelected() {
        this.organization = this.organizations.get(this.cbbOrganizations.getSelectionIndex());
        this.session.setOrganization(this.organization);
        this.reloadAnalyticsIntegration(false, false);
    }

    private void onEnableIntegrationChanged() {
        this.isIntegrationEnabled = this.enableAnalyticsIntegration.getSelection();
        this.updateAnalyticsIntegrationUI(this.isIntegrationEnabled);
        this.reloadAnalyticsIntegration(false, false);
    }

    private void onFetchProjects() {
        this.reloadAnalyticsIntegration(true, false);
    }

    private void onProjectSelected() {
        this.project = this.projects.get(this.cbbProjects.getSelectionIndex());
        this.reloadAnalyticsIntegration(false, false);
    }

    private void onCreateProjectClicked() {
        Organization organization = this.organization;
        if (organization == null) {
            organization = this.sessionController.getSession().getOrganization();
        }
        String url = MessageFormat.format(ComposerIntegrationAnalyticsMessageConstants.LINK_TO_PROJECTS_PAGE_BY_ORG_ID, organization.getId().toString());
        Program.launch((String)url);
    }

    private void onEnableTestCloudIntegrationChanged() {
        this.clearIntegrationMessage();
        this.fetchTestCloudExecutionAndSetMessage();
        this.enableSwitchToTestCloudHubUI(this.enableTestCloudIntegration.getSelection());
    }

    private void enableSwitchToTestCloudHubUI(boolean isEnable) {
        this.setButtonVisible(this.enableSwitchToTestCloudHub, isEnable && this.testCloudAutomationNewHubEnabled);
        this.enableSwitchToTestCloudHub.setEnabled(isEnable);
    }

    private void resetAuthentication() {
        this.organizations.clear();
        UISynchronizeService.syncExec(() -> {
            this.cbbOrganizations.clearSelection();
            this.cbbOrganizations.removeAll();
        });
        this.clearAuthenticationMessage();
    }

    private void reloadOverrideAuthentication(boolean reload) {
        this.resetAuthentication();
        if (!this.isAuthenticationEnabled) {
            this.updateOverrideAuthenticationUI();
            this.reloadAnalyticsIntegration(false, !reload);
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.email) || StringUtils.isBlank((CharSequence)this.password) || StringUtils.isBlank((CharSequence)this.testOpsServerUrl)) {
            this.setAuthenticationMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_MUST_ENTER_CREDENTIAL, true);
            return;
        }
        Executors.newFixedThreadPool(1).submit(() -> {
            this.enableOverrideAuthenticationUI(false);
            this.setAuthenticationMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false);
            try {
                this.fetchingOrganizations = true;
                if (reload) {
                    AnalyticsAuthenticationSetting authSetting = new AnalyticsAuthenticationSetting();
                    authSetting.setServerUrl(this.testOpsServerUrl);
                    authSetting.setEmail(this.email);
                    authSetting.setPassword(this.password);
                    this.session = this.testOpsController.authenticate(authSetting);
                } else if (this.session == null) {
                    String message = ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_CONNECTION;
                    this.setAuthenticationMessage(message, true);
                    return;
                }
                if (this.session == null) {
                    this.clearAuthenticationMessage();
                    return;
                }
                try {
                    this.organizations = new ArrayList<Organization>(this.session.getUserInfo().getOrganizations());
                    this.bindOrganizations();
                    if (this.organizations.isEmpty()) {
                        this.organization = null;
                    } else {
                        UISynchronizeService.syncExec(() -> {
                            Organization organization = this.organization = this.organizations.get(this.cbbOrganizations.getSelectionIndex());
                        });
                        this.session.setOrganization(this.organization);
                    }
                    String message = ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_FETCH_SUCCESSFULLY;
                    this.setAuthenticationMessage(message, false);
                    this.reloadAnalyticsIntegration(false, !reload);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    String message = ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_INVALID_CREDENTIAL;
                    this.setAuthenticationMessage(message, true);
                }
            }
            finally {
                this.fetchingOrganizations = false;
                this.enableOverrideAuthenticationUI(true);
                this.updateOverrideAuthenticationUI();
            }
        });
    }

    private void resetIntegration() {
        this.projects.clear();
        UISynchronizeService.syncExec(() -> {
            this.cbbProjects.clearSelection();
            this.cbbProjects.removeAll();
        });
        this.clearIntegrationMessage();
    }

    private void reloadAnalyticsIntegration(boolean reload, boolean keepCurrentProject) {
        this.resetIntegration();
        Session loginSession = this.sessionController.getSession();
        UISynchronizeService.syncExec(() -> {
            boolean canEnabled = this.isAuthenticationEnabled || !loginSession.getLicense().isOffline();
            this.grpIntegration.setEnabled(canEnabled);
            this.enableAnalyticsIntegration.setEnabled(canEnabled);
            if (!canEnabled) {
                this.enableAnalyticsIntegration.setSelection(false);
                this.isIntegrationEnabled = false;
            }
        });
        if (this.isAuthenticationEnabled && this.session == null) {
            this.updateAnalyticsIntegrationUI(false);
            return;
        }
        if (!this.isIntegrationEnabled) {
            this.updateAnalyticsIntegrationUI(false);
            return;
        }
        Executors.newFixedThreadPool(1).submit(() -> {
            boolean isPresent;
            this.enableAnalyticsIntegrationUI(false);
            if (reload) {
                this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false);
                try {
                    UserInfo userInfo;
                    if (this.session != null) {
                        userInfo = this.sessionController.getUserInfo(this.testOpsServerUrl, this.session.getToken());
                    } else {
                        Session session2 = this.sessionController.getSession();
                        String serverUrl = this.discoveryController.getServerUrl(ServerType.ADMIN);
                        userInfo = this.sessionController.getUserInfo(serverUrl, session2.getAdminToken());
                    }
                    this.projects.clear();
                    this.projects.addAll(userInfo.getProjects());
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    String message = ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_FETCH_FAILED;
                    this.setProgressMessage(message, true);
                    this.enableAnalyticsIntegrationUI(true);
                    return;
                }
            } else if (this.session != null) {
                this.projects = this.session.getUserInfo().getProjects();
            } else if (loginSession.getUserInfo() != null) {
                this.projects = loginSession.getUserInfo().getProjects();
            }
            Organization org = this.organization != null ? this.organization : loginSession.getOrganization();
            this.projects = org != null ? this.projects.stream().filter(p -> Objects.equals(p.getAccountId(), org.getAccountId())).collect(Collectors.toList()) : new ArrayList<Project>();
            if (reload) {
                this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_SUCCESSFULLY, false);
            }
            if (this.projects.isEmpty()) {
                this.bindProjects();
                this.enableAnalyticsIntegrationUI(true);
                String message = ComposerIntegrationAnalyticsMessageConstants.REPORT_WARNING_MSG_NO_PROJECT;
                this.setProgressMessage(message, true);
                return;
            }
            if (keepCurrentProject && this.project != null && !(isPresent = this.projects.stream().anyMatch(p -> Objects.equals(p.getId(), this.project.getId())))) {
                this.projects.add(this.project);
                String message = ComposerIntegrationAnalyticsMessageConstants.VIEW_ERROR_MSG_PROJ_USER_CAN_NOT_ACCESS_PROJECT;
                this.setProgressMessage(message, true);
            }
            this.bindProjects();
            if (this.projects.isEmpty()) {
                this.project = null;
            } else {
                UISynchronizeService.syncExec(() -> {
                    Project project = this.project = this.projects.get(this.cbbProjects.getSelectionIndex());
                });
            }
            this.enableAnalyticsIntegrationUI(true);
            this.updateAnalyticsIntegrationUI(this.isIntegrationEnabled);
            UISynchronizeService.syncExec(() -> this.fetchTestCloudExecutionAndSetMessage());
        });
    }

    private void bindProjects() {
        UISynchronizeService.syncExec(() -> {
            OptionalInt indexOpt;
            Project project;
            this.cbbProjects.clearSelection();
            this.cbbProjects.removeAll();
            if (this.projects.isEmpty()) {
                return;
            }
            String[] names = (String[])this.projects.stream().map(Project::getName).toArray(String[]::new);
            this.cbbProjects.setItems(names);
            this.cbbProjects.select(0);
            Project configuredProject = this.setting.getIntegration() != null ? this.setting.getIntegration().getProject() : null;
            Project project2 = project = this.project != null ? this.project : configuredProject;
            if (project != null && (indexOpt = IntStream.range(0, this.projects.size()).filter(i -> Objects.equals(project.getId(), this.projects.get(i).getId())).findFirst()).isPresent()) {
                this.cbbProjects.select(indexOpt.getAsInt());
            }
        });
    }

    private void bindOrganizations() {
        UISynchronizeService.syncExec(() -> {
            OptionalInt index;
            Organization organization;
            this.cbbOrganizations.clearSelection();
            this.cbbOrganizations.removeAll();
            String[] names = (String[])this.organizations.stream().map(Organization::getName).toArray(String[]::new);
            this.cbbOrganizations.setItems(names);
            this.cbbOrganizations.select(0);
            Organization organization2 = organization = this.setting.getAuthentication() != null ? this.setting.getAuthentication().getOrganization() : null;
            if (organization != null && (index = IntStream.range(0, this.organizations.size()).filter(i -> Objects.equals(organization.getId(), this.organizations.get(i).getId())).findFirst()).isPresent()) {
                this.cbbOrganizations.select(index.getAsInt());
            }
            this.organization = this.organizations.get(this.cbbOrganizations.getSelectionIndex());
        });
    }

    private void setProgressMessage(String message, boolean isError) {
        UISynchronizeService.syncExec(() -> {
            if (isError) {
                this.lblStatus.setForeground(ColorUtil.getTextErrorColor());
            } else {
                this.lblStatus.setForeground(ColorUtil.getTextSuccessfulColor());
            }
            this.lblStatus.setText(message);
            this.lblStatus.getParent().layout();
        });
    }

    private void setAuthenticationMessage(String message, boolean isError) {
        UISynchronizeService.syncExec(() -> {
            if (isError) {
                this.lblStatusOnPremise.setForeground(ColorUtil.getTextErrorColor());
            } else {
                this.lblStatusOnPremise.setForeground(ColorUtil.getTextSuccessfulColor());
            }
            this.lblStatusOnPremise.setText(message);
            this.lblStatusOnPremise.getParent().layout();
        });
    }

    private void updateAnalyticsIntegrationUI(boolean enabled) {
        UISynchronizeService.syncExec(() -> {
            this.btnRefresh.setEnabled(enabled);
            this.cbbProjects.setEnabled(enabled);
            this.enableTestCloudIntegration.setEnabled(enabled);
            this.autoUploadTestReports.setEnabled(enabled);
            if (this.enableSwitchToTestCloudHub != null && !this.enableSwitchToTestCloudHub.isDisposed()) {
                this.enableSwitchToTestCloudHub.setEnabled(enabled && this.enableTestCloudIntegration.getSelection());
            }
            if (enabled) {
                Organization organization = this.organization;
                if (organization == null) {
                    organization = this.sessionController.getSession().getOrganization();
                }
                if (organization != null) {
                    this.btnCreate.setEnabled(!StringUtils.equals((CharSequence)organization.getRole(), (CharSequence)UserOrganizationRole.USER.getValue()));
                }
            } else {
                this.btnCreate.setEnabled(false);
            }
        });
    }

    private void updateOverrideAuthenticationUI() {
        UISynchronizeService.syncExec(() -> {
            this.txtEmail.setEnabled(this.isAuthenticationEnabled);
            this.txtPassword.setEnabled(this.isAuthenticationEnabled);
            this.txtServerUrl.setEnabled(this.isAuthenticationEnabled);
            this.btnConnect.setEnabled(this.isAuthenticationEnabled);
            this.cbbOrganizations.setEnabled(this.isAuthenticationEnabled);
        });
    }

    private void addListeners() {
        this.enableAnalyticsIntegration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsPreferencesPage.this.onEnableIntegrationChanged();
            }
        });
        this.enableOverrideAuthentication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsPreferencesPage.this.onOverrideAuthenticationChanged();
            }
        });
        this.enableTestCloudIntegration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsPreferencesPage.this.onEnableTestCloudIntegrationChanged();
            }
        });
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsPreferencesPage.this.onFetchProjects();
            }
        });
        this.btnConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AnalyticsPreferencesPage.this.onFetchOrganizations();
            }
        });
        this.cbbOrganizations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsPreferencesPage.this.onOrganizationSelected();
            }
        });
        this.cbbProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsPreferencesPage.this.onProjectSelected();
            }
        });
        this.btnCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsPreferencesPage.this.onCreateProjectClicked();
            }
        });
        this.lblStatus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }
        });
    }

    private void fetchTestCloudExecutionAndSetMessage() {
        if (this.isAuthenticationEnabled && this.session == null) {
            return;
        }
        if (!this.isIntegrationEnabled) {
            return;
        }
        if (!this.enableTestCloudIntegration.getSelection()) {
            return;
        }
        Executors.newFixedThreadPool(1).submit(() -> {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false);
            TestCloudSessionTypes testCloudSessionTypes = null;
            try {
                TestOpsRequestOptions requestOptions;
                if (this.session != null) {
                    String serverUrl = (String)this.session.getServerInfo().get(ServerType.TESTCLOUD);
                    requestOptions = TestOpsRequestOptions.builder().session(this.session).serverUrl(serverUrl).build();
                } else {
                    requestOptions = this.testOpsController.getRequestOptions(true);
                    requestOptions.setServerUrl(this.discoveryController.getServerUrl(ServerType.TESTCLOUD));
                }
                AnalyticsIntegrationSetting integrationSetting = new AnalyticsIntegrationSetting();
                integrationSetting.setProject(this.project);
                requestOptions.setIntegratedSetting(integrationSetting);
                testCloudSessionTypes = this.testCloudController.requestTestCloudSessionTypes(requestOptions);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
            if (testCloudSessionTypes == null || CollectionUtils.isEmpty((Collection)testCloudSessionTypes.getSupportedTestSessionTypes())) {
                this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_FAILED_TO_INTEGRATE_WITH_TESTCLOUD, true);
                UISynchronizeService.syncExec(() -> {
                    this.enableTestCloudIntegration.setSelection(false);
                    this.setButtonVisible(this.enableSwitchToTestCloudHub, false);
                });
                return;
            }
            this.setMessageForTestCloudSessionTypes(testCloudSessionTypes);
        });
    }

    private void setMessageForTestCloudSessionTypes(TestCloudSessionTypes testCloudSessionTypes) {
        ArrayList<String> supported = new ArrayList<String>();
        if (testCloudSessionTypes.isSupportedDesktopBrowser()) {
            supported.add("desktop browsers");
        }
        if (testCloudSessionTypes.isSupportedMobileBrowser()) {
            supported.add("mobile browsers");
        }
        if (testCloudSessionTypes.isSupportedMobileNative()) {
            supported.add("mobile native apps");
        }
        this.setProgressMessage(MessageFormat.format(ComposerIntegrationAnalyticsMessageConstants.LBL_TEST_CLOUD_SESSION_TYPES, String.join((CharSequence)", ", supported)), false);
    }

    private void clearAuthenticationMessage() {
        UISynchronizeService.syncExec(() -> this.setAuthenticationMessage("", false));
    }

    private void clearIntegrationMessage() {
        UISynchronizeService.syncExec(() -> this.setProgressMessage("", false));
    }

    private void enableOverrideAuthenticationUI(boolean isEnable) {
        UISynchronizeService.syncExec(() -> {
            if (!this.txtServerUrl.isDisposed()) {
                this.txtServerUrl.setEnabled(isEnable);
            }
            if (!this.txtEmail.isDisposed()) {
                this.txtEmail.setEnabled(isEnable);
            }
            if (!this.txtPassword.isDisposed()) {
                this.txtPassword.setEnabled(isEnable);
            }
            if (!this.btnConnect.isDisposed()) {
                this.btnConnect.setEnabled(isEnable);
            }
            if (!this.cbbOrganizations.isDisposed()) {
                this.cbbOrganizations.setEnabled(isEnable);
            }
        });
    }

    private void enableAnalyticsIntegrationUI(boolean isEnable) {
        UISynchronizeService.syncExec(() -> {
            if (!this.btnRefresh.isDisposed()) {
                this.btnRefresh.setEnabled(isEnable);
            }
            if (!this.cbbProjects.isDisposed()) {
                this.cbbProjects.setEnabled(isEnable);
            }
            if (!this.enableTestCloudIntegration.isDisposed()) {
                this.enableTestCloudIntegration.setEnabled(isEnable);
                if (this.enableSwitchToTestCloudHub != null && !this.enableSwitchToTestCloudHub.isDisposed()) {
                    this.enableSwitchToTestCloudHub.setEnabled(isEnable);
                }
            }
            if (!this.autoUploadTestReports.isDisposed()) {
                this.autoUploadTestReports.setEnabled(isEnable);
            }
        });
    }

    protected boolean isInitialized() {
        return this.enableAnalyticsIntegration != null;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_KATALON_ANALYTICS;
    }

    private void trackingPlatformIntegration(AnalyticsSetting setting) {
        AnalyticsIntegrationSetting integrationSetting = setting.getIntegration();
        AnalyticsAuthenticationSetting authenticationSetting = setting.getAuthentication();
        boolean enableAnalyticsIntegrationValue = integrationSetting != null;
        boolean enableAutoUploadTestReportsValue = integrationSetting != null ? integrationSetting.isAutoUploadReports() : false;
        boolean enableTestCloudIntegrationValue = integrationSetting != null ? integrationSetting.isEnabledTestCloudIntegration() : false;
        boolean enableOverrideAuthenticationValue = authenticationSetting != null;
        String projectId = integrationSetting != null ? integrationSetting.getProject().getId().toString() : "";
        String accountId = authenticationSetting != null ? authenticationSetting.getOrganization().getAccountId().toString() : "";
        Trackings.trackTestOpsIntegrationSetting((Boolean)enableAnalyticsIntegrationValue, (Boolean)enableOverrideAuthenticationValue, (Boolean)enableAutoUploadTestReportsValue, (String)projectId, (String)accountId);
        Trackings.trackTestCloudIntegrationSetting((Boolean)enableAnalyticsIntegrationValue, (Boolean)enableOverrideAuthenticationValue, (Boolean)enableTestCloudIntegrationValue, (String)projectId, (String)accountId);
    }
}

