/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.updater;

import com.google.gson.Gson;
import com.kms.katalon.updater.UpdateException;
import com.kms.katalon.updater.download.FileExtractor;
import com.kms.katalon.updater.models.AppInfo;
import com.kms.katalon.updater.models.ExecInfo;
import com.kms.katalon.updater.models.FileInfo;
import com.kms.katalon.updater.utils.ImageUtils;
import com.kms.katalon.updater.utils.LogUtils;
import com.kms.katalon.updater.utils.PlatformUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class Updater {
    private static Logger logger = LogUtils.getLogger();
    private ExecInfo execInfo;

    public Updater(ExecInfo execInfo) {
        this.execInfo = execInfo;
        logger.info(new Gson().toJson(execInfo));
    }

    public void copyResourcesAndStart() {
        UpdaterUI ui = new UpdaterUI();
        try {
            this.startWaitingUntilKatalonClosed();
            logger.info("Start launching Updater UI");
            SwingUtilities.invokeLater(() -> {
                ui.createUI();
                ui.setInput(this.execInfo);
            });
            logger.info("Copying and Replacing resources...");
            this.copyResources();
            SwingUtilities.invokeLater(() -> ui.close());
            this.startKatalon();
        }
        catch (UpdateException | IOException | InterruptedException e) {
            logger.log(Level.SEVERE, "Unable to install Katalon", e);
            if (ui != null) {
                ui.close();
            }
            JOptionPane.showMessageDialog(null, "An error occurs when installing Katalon");
        }
    }

    private void startKatalon() throws IOException {
        File execFile = new File(this.execInfo.getExecFile());
        String execName = PlatformUtils.isWindows() ? "katalon.exe" : "katalon";
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(String.valueOf(execFile.getParentFile()) + File.separator + execName);
        processBuilder.start();
    }

    private void copyResources() throws IOException, UpdateException {
        String latestVersionDir = this.execInfo.getLatestVersionDir();
        File appInfoFile = new File(latestVersionDir, "app_info.json");
        String appInfoContent = FileUtils.readFileToString(appInfoFile, StandardCharsets.UTF_8);
        File extractDir = new File(latestVersionDir, "extract");
        AppInfo appInfo = new Gson().fromJson(appInfoContent, AppInfo.class);
        for (FileInfo f : appInfo.getFiles()) {
            FileExtractor extractor = new FileExtractor(f, this.execInfo.getAppDir(), extractDir);
            extractor.extract();
        }
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        CodeSource codeSource = Updater.class.getProtectionDomain().getCodeSource();
        File jarFile = new File(codeSource.getLocation().toURI().getPath());
        String jarDir = jarFile.getParentFile().getPath();
        File execInfoFile = new File(jarDir, "exec_info.json");
        String execInfoContent = FileUtils.readFileToString(execInfoFile, StandardCharsets.UTF_8);
        ExecInfo execInfo = new Gson().fromJson(execInfoContent, ExecInfo.class);
        Updater updater = new Updater(execInfo);
        updater.copyResourcesAndStart();
    }

    private void startWaitingUntilKatalonClosed() throws IOException, InterruptedException {
        while (!this.isProgramClosed()) {
            logger.info("Waiting for Katalon to close");
            try {
                TimeUnit.MICROSECONDS.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info("Katalon Studio closed");
    }

    private boolean isProgramClosed() throws IOException, InterruptedException {
        logger.info(MessageFormat.format("Platform: {0}", PlatformUtils.getPlatform()));
        if (PlatformUtils.isWindows()) {
            String[] commands = new String[]{"TASKLIST", "/FI", "\"IMAGENAME eq katalon.exe\""};
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(commands);
            p.waitFor();
            String output = IOUtils.toString(p.getInputStream(), StandardCharsets.UTF_8);
            logger.info(MessageFormat.format("Console output on Windows: {0}", output));
            return !output.contains("katalon.exe");
        }
        String[] commands = new String[]{"/bin/sh", "-c", "ps cax | grep katalon"};
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(commands);
        p.waitFor();
        String output = IOUtils.toString(p.getInputStream(), StandardCharsets.UTF_8);
        logger.info(MessageFormat.format("Console output on UNIX: {0}", output));
        return StringUtils.isBlank(output);
    }

    private class UpdaterUI {
        private JLabel fVersion;
        private JLabel fStatus;
        private JLabel fSize;
        private JLabel fNotification;
        private JProgressBar fProgress;
        private JFrame window;

        private UpdaterUI() {
        }

        private void createUI() {
            this.window = new JFrame();
            this.configWindow(this.window);
            JPanel mainContainer = new JPanel();
            mainContainer.setLayout(new BorderLayout(10, 10));
            this.window.add(mainContainer);
            this.createBodyContainer(mainContainer);
            this.window.pack();
            this.window.setVisible(true);
            this.window.setSize(this.getInitialSize());
        }

        public void setInput(ExecInfo execInfo) {
            logger.info("Calculating install size");
            long sizeOfDirectoryInBytes = FileUtils.sizeOfDirectory(new File(execInfo.getLatestVersionDir()));
            logger.info(MessageFormat.format("Install size: {0}", sizeOfDirectoryInBytes));
            this.fSize.setText("Calculating Size...");
            this.fSize.setText(FileUtils.byteCountToDisplaySize(sizeOfDirectoryInBytes));
            this.fStatus.setText("Installing...");
            this.fVersion.setText(String.format("%s (Latest: %s)", execInfo.getCurrentVersion(), execInfo.getLatestVersion()));
            this.fProgress.setValue(0);
            this.fProgress.setMaximum(100);
        }

        public void close() {
            this.window.dispose();
        }

        private void configWindow(JFrame window) {
            window.setTitle("Katalon Studio Updater");
            window.setUndecorated(false);
            window.setIconImage(ImageUtils.getImage("images/logo_128.png"));
            window.setSize(this.getInitialSize());
            window.setResizable(false);
            window.setLocationRelativeTo(null);
            window.setDefaultCloseOperation(0);
        }

        private Dimension getInitialSize() {
            return new Dimension(400, 150);
        }

        private void createBodyContainer(Container parent) {
            JPanel bodyContainer = new JPanel();
            GroupLayout bodyLayout = new GroupLayout(bodyContainer);
            bodyLayout.setAutoCreateGaps(true);
            bodyLayout.setAutoCreateContainerGaps(true);
            bodyContainer.setLayout(bodyLayout);
            parent.add((Component)bodyContainer, "Center");
            JLabel lblVersion = new JLabel("Version");
            JLabel lblStatus = new JLabel("Status");
            JLabel lblSize = new JLabel("Size");
            JLabel lblProgress = new JLabel("Progress");
            JLabel lblNotification = new JLabel();
            this.fVersion = new JLabel();
            this.fStatus = new JLabel();
            this.fSize = new JLabel();
            this.fProgress = new JProgressBar();
            this.fProgress.setIndeterminate(true);
            this.fNotification = new JLabel();
            this.fNotification.setText("Please wait a minute...");
            bodyLayout.setHorizontalGroup(bodyLayout.createSequentialGroup().addGroup(bodyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lblVersion).addComponent(lblStatus).addComponent(lblSize).addComponent(lblProgress).addComponent(lblNotification)).addGroup(bodyLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fVersion).addComponent(this.fStatus).addComponent(this.fSize).addComponent(this.fProgress).addComponent(this.fNotification)));
            bodyLayout.setVerticalGroup(bodyLayout.createSequentialGroup().addGroup(bodyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblVersion).addComponent(this.fVersion)).addGroup(bodyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblStatus).addComponent(this.fStatus)).addGroup(bodyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblSize).addComponent(this.fSize)).addGroup(bodyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblProgress).addComponent(this.fProgress)).addGroup(bodyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblNotification).addComponent(this.fNotification)));
        }
    }
}

