/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.kms.katalon.integration.qtest.QTestIntegrationAuthenticationManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestTestStep;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import java.util.List;
import org.qas.qtest.api.auth.BasicQTestCredentials;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.services.design.TestDesignServiceAsyncClient;
import org.qas.qtest.api.services.design.model.CreateTestStepRequest;
import org.qas.qtest.api.services.design.model.ListTestStepRequest;
import org.qas.qtest.api.services.design.model.TestStep;

public class QTestIntegrationTestStepManager {
    private QTestIntegrationTestStepManager() {
    }

    public static QTestTestStep addTestStep(IQTestCredential credential, long projectId, long testCaseId, long testCaseVersionId, String description) throws QTestUnauthorizedException, QTestInvalidFormatException {
        String token = credential.getToken().getAccessTokenHeader();
        String serverUrl = credential.getServerUrl();
        if (!QTestIntegrationAuthenticationManager.validateToken(token)) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        BasicQTestCredentials credentials = new BasicQTestCredentials(token);
        TestDesignServiceAsyncClient testDesignService = new TestDesignServiceAsyncClient((QTestCredentials)credentials);
        testDesignService.setEndpoint(serverUrl);
        TestStep qTestTestStep = new TestStep().withDescription(description);
        CreateTestStepRequest createSteprequest = new CreateTestStepRequest().withProjectId(Long.valueOf(projectId)).withTestCaseId(Long.valueOf(testCaseId)).withTestStep(qTestTestStep);
        TestStep qtTestStepResult = testDesignService.createTestStep(createSteprequest);
        if (qtTestStepResult != null) {
            int order = qtTestStepResult.getOrder();
            ListTestStepRequest listStepsRequest = new ListTestStepRequest().withProjectId(Long.valueOf(projectId)).withTestCaseId(Long.valueOf(testCaseId)).withTestCaseVersion(Long.valueOf(testCaseVersionId));
            List lstStepsResult = testDesignService.listTestStep(listStepsRequest);
            if (listStepsRequest != null) {
                for (TestStep step : lstStepsResult) {
                    if (step.getOrder() != order) continue;
                    QTestTestStep qTestStepEntity = new QTestTestStep(step.getId());
                    return qTestStepEntity;
                }
            }
        }
        return null;
    }
}

