/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.credential;

import com.kms.katalon.integration.qtest.credential.IQTestToken;
import com.kms.katalon.integration.qtest.credential.impl.AbstractQTestToken;
import com.kms.katalon.integration.qtest.credential.impl.V6Token;
import com.kms.katalon.integration.qtest.credential.impl.V7Token;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.setting.QTestVersion;
import org.apache.commons.lang.StringUtils;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;

public class QTestTokenManager {
    public static IQTestToken getToken(String rawToken) throws QTestInvalidFormatException {
        if (StringUtils.isBlank((String)rawToken)) {
            return null;
        }
        AbstractQTestToken token = null;
        try {
            new JsonObject(rawToken);
            token = new V7Token(rawToken);
        }
        catch (JsonException jsonException) {
            token = new V6Token(rawToken);
        }
        if (token != null) {
            token.getAccessTokenHeader();
        }
        return token;
    }

    public static IQTestToken getToken(QTestVersion version, String rawToken) throws QTestInvalidFormatException {
        IQTestToken qTestToken = QTestTokenManager.getToken(rawToken);
        if (qTestToken.getVersion().higherThan(version)) {
            throw new QTestInvalidFormatException("Token and version are not compatible");
        }
        return qTestToken;
    }

    public static IQTestToken getTokenByAccessToken(QTestVersion version, String accessToken) throws QTestInvalidFormatException {
        if (version == QTestVersion.V6) {
            return new V6Token(accessToken);
        }
        if (version == QTestVersion.V7) {
            try {
                JsonObject js = new JsonObject().put("access_token", (Object)accessToken).put("token_type", (Object)"bearer");
                return new V7Token(js.toString());
            }
            catch (JsonException e) {
                throw QTestInvalidFormatException.createInvalidJsonFormatException(e.getMessage());
            }
        }
        return null;
    }
}

