/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.helper;

import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.exception.QTestAPIConnectionException;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestIOException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;

public class QTestHttpRequestHelper {
    private QTestHttpRequestHelper() {
    }

    private static HttpOptions buildHttpOptions(Map<String, String> cookies, String host) {
        INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();
        ProxyConfig proxyConfig = networkPreferences.getProxyConfig(ProxyType.SYSTEM);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (Objects.nonNull(host)) {
            headers.put("Host", host);
        }
        if (Objects.nonNull(cookies)) {
            headers.put("Cookie", QTestHttpRequestHelper.cookiesString(cookies));
        }
        headers.put("User-Agent", "Mozilla/5.0");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Accept-Language", "en-US,en;q=0.5");
        headers.put("Connection", "keep-alive");
        headers.put("X-CSRF-Token", "0.0");
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)Authentication.BasicAuthentication((String)"katalon-user", (String)"")).proxy(proxyConfig).build();
        return httpOptions;
    }

    public static String getTokenViaQTestV6(String serverUrl, String username, String password) throws QTestException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        String responseBody = "";
        try {
            URI baseUri = new URI(StringUtils.stripEnd((String)serverUrl, (String)"/"));
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/login").addParameter("j_username", username).addParameter("j_password", password).build();
            HashMap body = new HashMap();
            HttpResponse response = httpClient.formPost(uri, body, QTestHttpRequestHelper.buildHttpOptions(null, null));
            responseBody = response.getBody();
            if (response.getStatusCode() == 200) {
                return responseBody;
            }
            JsonObject jo = new JsonObject(responseBody);
            throw new QTestIOException(jo.getString("message"));
        }
        catch (HttpException | URISyntaxException e) {
            throw new QTestIOException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(responseBody);
        }
    }

    public static String getV7Token(String serverURL, String username, String password) throws QTestException {
        HttpResponse response = QTestHttpRequestHelper.internallyGetV7Token(serverURL, username, password);
        int statusCode = response.getStatusCode();
        if (statusCode == 200) {
            return response.getBody();
        }
        if (statusCode == 401) {
            try {
                JsonObject jo = new JsonObject(response.getBody());
                throw new QTestAPIConnectionException(jo.getString("error_description"));
            }
            catch (JsonException jsonException) {
                throw new QTestAPIConnectionException(response.getBody());
            }
        }
        throw new QTestAPIConnectionException(response.getBody());
    }

    private static HttpResponse internallyGetV7Token(String serverUrl, String username, String password) throws QTestIOException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI baseUri = new URI(StringUtils.stripEnd((String)serverUrl, (String)"/"));
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/oauth/token").build();
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("grant_type", "password");
            body.put("username", username);
            body.put("password", password);
            HttpResponse response = httpClient.formPost(uri, body, QTestHttpRequestHelper.buildHttpOptions(null, null));
            return response;
        }
        catch (HttpException | URISyntaxException e) {
            throw new QTestIOException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    public static String sendPostRequest(IQTestCredential credential, String path, Map<String, String> body) throws QTestException {
        HashMap<String, String> cookies = new HashMap<String, String>();
        QTestHttpRequestHelper.doLogin(credential, cookies);
        String result = QTestHttpRequestHelper.doPost(credential.getServerUrl(), path, body, cookies).getBody();
        QTestHttpRequestHelper.doLogout(credential, cookies);
        return result;
    }

    public static String sendGetRequest(IQTestCredential credential, String path) throws QTestException {
        HashMap<String, String> cookies = new HashMap<String, String>();
        QTestHttpRequestHelper.doLogin(credential, cookies);
        String result = QTestHttpRequestHelper.doGet(credential.getServerUrl(), path, cookies).getBody();
        QTestHttpRequestHelper.doLogout(credential, cookies);
        return result;
    }

    public static String createDataBody(Map<String, Object> mapProperties, boolean useBrackets) {
        StringBuilder builder = new StringBuilder("[{");
        int index = 0;
        for (Map.Entry<String, Object> entry : mapProperties.entrySet()) {
            if (index > 0) {
                builder.append(",");
            }
            builder.append("\"").append(entry.getKey()).append("\"").append(":");
            Object value = String.valueOf(entry.getValue());
            if (entry.getValue() instanceof String) {
                value = "\"" + (String)value + "\"";
            } else if (entry.getValue() instanceof Map) {
                value = QTestHttpRequestHelper.createDataBody((Map)entry.getValue(), useBrackets);
            }
            builder.append((String)value);
            if (useBrackets) {
                builder.insert(0, "[").append("]");
            }
            ++index;
        }
        builder.append("}]");
        return builder.toString();
    }

    public static void doLogin(IQTestCredential credential, Map<String, String> cookies) throws QTestException {
        String serverUrl = credential.getServerUrl();
        QTestHttpRequestHelper.doGet(serverUrl, "/portal/loginform", cookies);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("j_username", credential.getUsername());
        body.put("j_password", credential.getPassword());
        QTestHttpRequestHelper.doPost(serverUrl, "/login?redirect=%2Fportal%2Fproject", body, cookies);
        QTestHttpRequestHelper.doGet(serverUrl, "/portal/project", cookies);
    }

    public static void doLogout(IQTestCredential credential, Map<String, String> cookies) throws QTestIOException {
        QTestHttpRequestHelper.doPost(credential.getServerUrl(), "/logout", new HashMap<String, String>(), cookies);
    }

    private static HttpResponse doPost(String serverUrl, String path, Map<String, String> body, Map<String, String> cookies) throws QTestIOException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI baseUri = new URI(StringUtils.stripEnd((String)serverUrl, (String)"/"));
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(path).build();
            HttpResponse response = httpClient.formPost(uri, body, QTestHttpRequestHelper.buildHttpOptions(cookies, serverUrl.replace("http://", "").replace("https://", "")));
            QTestHttpRequestHelper.addCookies(response, cookies);
            return response;
        }
        catch (HttpException | URISyntaxException e) {
            throw new QTestIOException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    private static HttpResponse doGet(String serverUrl, String path, Map<String, String> cookies) throws QTestIOException {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        try {
            URI baseUri = new URI(StringUtils.stripEnd((String)serverUrl, (String)"/"));
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(path).build();
            HttpResponse response = httpClient.get(uri, QTestHttpRequestHelper.buildHttpOptions(cookies, null));
            QTestHttpRequestHelper.addCookies(response, cookies);
            return response;
        }
        catch (HttpException | URISyntaxException e) {
            throw new QTestIOException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    private static String cookiesString(Map<String, String> cookies) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> cookie : cookies.entrySet()) {
            builder.append(cookie.getKey()).append("=").append(cookie.getValue()).append(";");
        }
        return builder.toString();
    }

    private static void addCookies(HttpResponse response, Map<String, String> cookies) {
        for (Map.Entry entry : response.getHeaders()) {
            if (!"Set-Cookie".equals(entry.getKey())) continue;
            String cookieValue = (String)entry.getValue();
            String[] stringArray = cookieValue.trim().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String composedValue = stringArray[n2];
                int seperatingIndex = composedValue.indexOf("=");
                if (seperatingIndex == -1) {
                    cookies.put(composedValue, "");
                } else {
                    String name = composedValue.substring(0, seperatingIndex);
                    String value = composedValue.substring(seperatingIndex + 1);
                    cookies.put(name, value);
                }
                ++n2;
            }
            break block0;
        }
    }
}

