/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.provider;

import com.katalon.platform.api.network.ApplicationProxyPreference;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyServerType;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.integration.qtest.api.services.BasicApiWebServiceClient;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import org.apache.commons.lang.StringUtils;
import org.qas.api.ClientConfiguration;
import org.qas.qtest.api.auth.BasicQTestCredentials;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.services.design.TestDesignServiceClient;

public class QTestWebServiceClientProvider {
    private QTestWebServiceClientProvider() {
    }

    public static BasicApiWebServiceClient getBasicApiWebServiceClient() throws QTestInvalidFormatException {
        BasicApiWebServiceClient client = new BasicApiWebServiceClient(QTestWebServiceClientProvider.getQTestCredentials(), QTestWebServiceClientProvider.getDefaultClientConfig());
        client.setEndpoint(QTestWebServiceClientProvider.getQTestServerUrl());
        return client;
    }

    public static TestDesignServiceClient getTestDesignServiceClient() throws QTestException {
        TestDesignServiceClient testDesignService = new TestDesignServiceClient(QTestWebServiceClientProvider.getQTestCredentials(), QTestWebServiceClientProvider.getDefaultClientConfig());
        testDesignService.setEndpoint(QTestWebServiceClientProvider.getQTestServerUrl());
        return testDesignService;
    }

    private static QTestCredentials getQTestCredentials() throws QTestInvalidFormatException {
        QTestSettingCredential settingsCredentials = QTestWebServiceClientProvider.getSettingsCredentials();
        String accessToken = settingsCredentials.getToken().getAccessTokenHeader();
        return new BasicQTestCredentials(accessToken);
    }

    private static String getQTestServerUrl() {
        QTestSettingCredential settingsCredentials = QTestWebServiceClientProvider.getSettingsCredentials();
        return settingsCredentials.getServerUrl();
    }

    private static QTestSettingCredential getSettingsCredentials() {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        return QTestSettingCredential.getCredential(projectDir);
    }

    private static ClientConfiguration getDefaultClientConfig() {
        ClientConfiguration clientConfig = new ClientConfiguration();
        QTestWebServiceClientProvider.configureProxy(clientConfig);
        return clientConfig;
    }

    private static void configureProxy(ClientConfiguration clientConfig) {
        boolean useSocksProxy;
        ProxyInformation proxyInformation = ProxyPreferences.getSystemProxyInformation();
        boolean configManualProxy = ApplicationProxyPreference.ProxyOption.valueOf((String)proxyInformation.getProxyOption()) == ApplicationProxyPreference.ProxyOption.MANUAL_CONFIG;
        boolean bl = useSocksProxy = ProxyServerType.valueOf((String)proxyInformation.getProxyServerType()) == ProxyServerType.SOCKS;
        if (configManualProxy && !useSocksProxy) {
            clientConfig.setProxyHost(proxyInformation.getProxyServerAddress());
            clientConfig.setProxyPort(proxyInformation.getProxyServerPort());
            String username = proxyInformation.getUsername();
            String pw = proxyInformation.getPassword();
            if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)pw)) {
                clientConfig.setProxyUsername(username);
                clientConfig.setProxyPassword(pw);
            }
        }
    }
}

