/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.report;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.helper.LogRecordHelper;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseGroupLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.LongConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.integration.qtest.QTestIntegrationReportManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestCaseManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestSuiteManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestLog;
import com.kms.katalon.integration.qtest.entity.QTestLogUploadedPreview;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestRun;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.entity.QTestSuiteParent;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.model.ParityReportInput;
import com.kms.katalon.integration.qtest.model.TestCaseRepo;
import com.kms.katalon.integration.qtest.model.TestSuiteCollectionParityReportInput;
import com.kms.katalon.integration.qtest.model.TestSuiteParityReportInput;
import com.kms.katalon.integration.qtest.model.TestSuiteRepo;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import com.kms.katalon.logging.LogUtil;
import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class QTestIntegrationReporter
implements ReportIntegrationContribution {
    private static final String UPLOADED_ID_PREFIX = "qTestDestId";
    private static final String UPLOADED_TYPE_PREFIX = "qTestDestType";
    private static final long DEFAULT_DESTINATION_ID = -1L;
    private long destId = -1L;
    private String destType;
    public static final LongConsoleOption DESTINATION_ID_CONSOLE_OPTION = new LongConsoleOption(){

        public String getOption() {
            return QTestIntegrationReporter.UPLOADED_ID_PREFIX;
        }
    };
    public static final StringConsoleOption DESTINATION_TYPE_CONSOLE_OPTION = new StringConsoleOption(){

        public String getOption() {
            return QTestIntegrationReporter.UPLOADED_TYPE_PREFIX;
        }
    };

    private IQTestCredential getCredential() {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        return QTestSettingCredential.getCredential(projectDir);
    }

    public void fetchRemoteSettings() {
    }

    public void generateIntegrationReportForTestSuite(TestSuiteLogRecord suiteLogRecord) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (!QTestSettingStore.isGenerateParityReportEnabled(project.getFolderLocation())) {
            return;
        }
        String testSuiteCollectionId = suiteLogRecord.getTestSuiteCollectionId();
        if (StringUtils.isNotBlank((String)testSuiteCollectionId)) {
            return;
        }
        String testSuiteId = suiteLogRecord.getId();
        TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, project);
        if (!QTestIntegrationUtil.isIntegrated((IntegratedFileEntity)testSuite, project)) {
            return;
        }
        TestSuiteParityReportInput reportInput = new TestSuiteParityReportInput(testSuite);
        this.generateParityReport(suiteLogRecord.getLogFolder(), reportInput);
    }

    public void generateIntegrationReportForTestSuiteCollection(TestSuiteCollectionLogRecord collectionLogRecord) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (!QTestSettingStore.isGenerateParityReportEnabled(project.getFolderLocation())) {
            return;
        }
        String collectionId = collectionLogRecord.getId();
        TestSuiteCollectionEntity testSuiteCollection = TestSuiteCollectionController.getInstance().getTestRunByDisplayId(collectionId);
        TestSuiteCollectionParityReportInput reportInput = new TestSuiteCollectionParityReportInput(testSuiteCollection);
        String reportFolderPath = collectionLogRecord.getReportFolder();
        this.generateParityReport(reportFolderPath, reportInput);
    }

    private void generateParityReport(String reportFolder, ParityReportInput reportInput) throws IOException, CompilationFailedException, ClassNotFoundException {
        String template = this.getParityReportTemplate();
        File reportFile = new File(reportFolder, "parity_report.html");
        reportFile.createNewFile();
        HashMap<String, ParityReportInput> binding = new HashMap<String, ParityReportInput>();
        binding.put("input", reportInput);
        GStringTemplateEngine templateEngine = new GStringTemplateEngine();
        Writable reportWritable = templateEngine.createTemplate(template).make(binding);
        OutputStreamWriter reportFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), StandardCharsets.UTF_8);
        reportWritable.writeTo((Writer)reportFileWriter);
        reportFileWriter.close();
    }

    private String getParityReportTemplate() throws IOException {
        Bundle bundle = FrameworkUtil.getBundle(QTestIntegrationReporter.class);
        URL templateFileUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("/resources/template/parity_report_template.html"), null);
        File templateFile = FileUtils.toFile((URL)FileLocator.toFileURL((URL)templateFileUrl));
        String template = FileUtils.readFileToString((File)templateFile, (Charset)StandardCharsets.UTF_8);
        return template;
    }

    public void uploadTestCaseResult(TestSuiteEntity testSuiteEntity, IntegratedEntity projectIntegratedEntity, TestCaseLogRecord testLogEntity, TestSuiteLogRecord suiteLog) throws Exception {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        String projectDir = projectEntity.getFolderLocation();
        TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId(testLogEntity.getId());
        IntegratedEntity testCaseIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCaseEntity);
        if (testCaseIntegratedEntity != null && this.isSameQTestProject(testCaseEntity, testSuiteEntity, projectEntity)) {
            QTestSuite selectedQTestSuite = this.getSelectedTestSuite(testSuiteEntity);
            IntegratedEntity testSuiteIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuiteEntity);
            List<QTestSuite> qTestSuiteCollection = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity(testSuiteIntegratedEntity);
            if (selectedQTestSuite == null) {
                return;
            }
            QTestTestCase qTestCase = QTestIntegrationTestCaseManager.getQTestTestCaseByIntegratedEntity(testCaseIntegratedEntity);
            QTestProject qTestProject = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)testCaseEntity, projectEntity).getQTestProject();
            QTestRun qTestRun = QTestIntegrationTestSuiteManager.getTestRunByTestSuiteAndTestCaseId(selectedQTestSuite, qTestCase.getId());
            if (qTestRun == null) {
                qTestRun = QTestIntegrationUtil.getQTestRun(qTestCase, this.getCurrentQTestRuns(testSuiteEntity, projectEntity));
                if (qTestRun == null) {
                    qTestRun = QTestIntegrationTestSuiteManager.uploadTestCaseInTestSuite(qTestCase, selectedQTestSuite, qTestProject, this.getCredential());
                }
                QTestIntegrationUtil.addNewTestRunToTestSuite(testSuiteEntity, testSuiteIntegratedEntity, selectedQTestSuite, qTestRun, qTestSuiteCollection);
            }
            qTestRun.setTestCaseVersionId(qTestCase.getVersionId());
            int testLogIndex = LogRecordHelper.getLogRecordIndex((ILogRecord)testLogEntity);
            QTestLogUploadedPreview uploadedPreview = new QTestLogUploadedPreview();
            uploadedPreview.setQTestProject(qTestProject);
            uploadedPreview.setQTestSuite(selectedQTestSuite);
            uploadedPreview.setQTestCase(qTestCase);
            uploadedPreview.setQTestRun(qTestRun);
            uploadedPreview.setQTestLog(null);
            uploadedPreview.setTestLogIndex(testLogIndex);
            uploadedPreview.setTestCaseLogRecord(testLogEntity);
            QTestLog qTestLog = QTestIntegrationReportManager.uploadTestLog(projectDir, uploadedPreview, QTestIntegrationUtil.getTempDirPath(), suiteLog);
            uploadedPreview.setQTestLog(qTestLog);
            ReportEntity reportEntity = ReportController.getInstance().getReportEntity(suiteLog.getLogFolder());
            QTestIntegrationUtil.saveReportEntity(reportEntity, uploadedPreview);
            this.printlnSuccessfulMessage();
        }
    }

    private void printlnSuccessfulMessage() {
        if (this.isUploadByDefault()) {
            return;
        }
        System.out.println(MessageFormat.format("Test results are uploaded to qTest:{0} - {1} successfully.", Long.toString(this.destId), this.destType));
    }

    private QTestSuite getSelectedTestSuite(TestSuiteEntity testSuite) throws Exception {
        IntegratedEntity testSuiteIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuite);
        ArrayList<QTestSuite> qTestSuiteCollection = new ArrayList();
        if (testSuiteIntegratedEntity != null) {
            qTestSuiteCollection = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity(testSuiteIntegratedEntity);
        }
        QTestProject qTestProject = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)testSuite, ProjectController.getInstance().getCurrentProject()).getQTestProject();
        if (this.isUploadByDefault()) {
            return QTestIntegrationTestSuiteManager.getSelectedQTestSuiteByIntegratedEntity(qTestSuiteCollection);
        }
        QTestSuite selectedQTestSuite = null;
        if ("test-suite".equals(this.destType)) {
            selectedQTestSuite = QTestIntegrationTestSuiteManager.getQTestSuite(this.destId, qTestSuiteCollection);
            if (selectedQTestSuite != null) {
                return this.updateTestSuite(selectedQTestSuite, qTestSuiteCollection, testSuite, qTestProject);
            }
            selectedQTestSuite = QTestIntegrationTestSuiteManager.getQTestSuite(this.destId, qTestProject, this.getCredential());
            return this.updateTestSuite(selectedQTestSuite, qTestSuiteCollection, testSuite, qTestProject);
        }
        selectedQTestSuite = this.getQTestSuiteByParentId(this.destId, qTestSuiteCollection);
        if (selectedQTestSuite != null) {
            return this.updateTestSuite(selectedQTestSuite, qTestSuiteCollection, testSuite, qTestProject);
        }
        QTestSuiteParent testSuiteParent = null;
        int parentType = QTestIntegrationTestSuiteManager.getTestSuiteParentType(this.destType);
        testSuiteParent = QTestIntegrationTestSuiteManager.getQTestSuiteParent(this.destId, parentType, qTestProject, this.getCredential());
        selectedQTestSuite = new QTestSuite();
        selectedQTestSuite.setParent(testSuiteParent);
        return this.updateTestSuite(selectedQTestSuite, qTestSuiteCollection, testSuite, qTestProject);
    }

    private QTestSuite updateTestSuite(QTestSuite selectedQTs, List<QTestSuite> qTsCollection, TestSuiteEntity testSuite, QTestProject qTestProject) throws Exception {
        if (selectedQTs.getId() <= 0L) {
            QTestSuite siblingQTestSuite = QTestIntegrationTestSuiteManager.getDuplicatedTestSuiteOnQTest(this.getCredential(), testSuite.getName(), selectedQTs.getParent(), qTestProject);
            selectedQTs = siblingQTestSuite != null ? siblingQTestSuite : QTestIntegrationTestSuiteManager.uploadTestSuite(this.getCredential(), testSuite.getName(), testSuite.getDescription(), selectedQTs.getParent(), qTestProject);
        }
        QTestIntegrationTestSuiteManager.setSelectedQTestSuite(selectedQTs, qTsCollection);
        IntegratedEntity tsIntegratedEntity = QTestIntegrationTestSuiteManager.getIntegratedEntityByTestSuiteList(qTsCollection);
        QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)testSuite, tsIntegratedEntity);
        TestSuiteController.getInstance().updateTestSuite(testSuite);
        return selectedQTs;
    }

    private QTestSuite getQTestSuiteByParentId(long id, List<QTestSuite> qTestSuiteCollection) {
        for (QTestSuite qTestSuite : qTestSuiteCollection) {
            QTestSuiteParent parent = qTestSuite.getParent();
            if (parent == null || id != parent.getId()) continue;
            return qTestSuite;
        }
        return null;
    }

    private boolean isSameQTestProject(TestCaseEntity testCaseEntity, TestSuiteEntity testSuiteEntity, ProjectEntity projectEntity) throws Exception {
        TestCaseRepo testCaseRepo = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)testCaseEntity, projectEntity);
        TestSuiteRepo testSuiteRepo = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)testSuiteEntity, projectEntity);
        if (testCaseRepo == null || testSuiteRepo == null) {
            return false;
        }
        QTestProject testCaseProject = testCaseRepo.getQTestProject();
        QTestProject testSuiteProject = testSuiteRepo.getQTestProject();
        return testCaseProject.equals(testSuiteProject);
    }

    private List<QTestRun> getCurrentQTestRuns(TestSuiteEntity testSuiteEntity, ProjectEntity projectEntity) throws Exception {
        IntegratedEntity testSuiteIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuiteEntity);
        if (testSuiteIntegratedEntity != null) {
            List<QTestSuite> qTestSuiteCollection = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity(testSuiteIntegratedEntity);
            QTestSuite selectedQTestSuite = QTestIntegrationTestSuiteManager.getSelectedQTestSuiteByIntegratedEntity(qTestSuiteCollection);
            QTestProject qTestProject = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)testSuiteEntity, projectEntity).getQTestProject();
            return QTestIntegrationTestSuiteManager.getTestRuns(selectedQTestSuite, qTestProject, QTestSettingCredential.getCredential(projectEntity.getFolderLocation()));
        }
        return null;
    }

    public void uploadTestSuiteResult(TestSuiteLogRecord suiteLogRecord) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        String testSuiteId = suiteLogRecord.getId();
        TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, project);
        if (!this.isIntegrationActive(testSuite) || suiteLogRecord == null) {
            return;
        }
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        IntegratedEntity projectIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity);
        List testCaseGroups = LogRecordHelper.reduceRawLogRecords((TestSuiteLogRecord)suiteLogRecord, (ILogRecord[])suiteLogRecord.getChildRecords());
        for (ILogRecord testCaseGroup : testCaseGroups) {
            try {
                this.uploadTestCaseResult(testSuite, projectIntegratedEntity, ((TestCaseGroupLogRecord)testCaseGroup).getLastLogRecord(), suiteLogRecord);
            }
            catch (Exception e) {
                LogUtil.printErrorLine((String)MessageFormat.format("Failed to upload test result to qTest. Test suite: {0}. Test case: {1}.", testSuite.getName(), testCaseGroup.getName()));
                throw new Exception(e);
            }
        }
    }

    public void uploadTestSuiteCollectionResult(TestSuiteCollectionLogRecord collectionLogRecord) throws Exception {
    }

    public TestSuiteEntity getTestSuiteFromLogRecord(TestSuiteLogRecord suiteLogRecord) throws Exception {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        String testSuiteId = suiteLogRecord.getId();
        return TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, projectEntity);
    }

    private boolean isUploadByDefault() {
        return this.destId <= 0L || StringUtils.isBlank((String)this.destType);
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList integrationCommandList = new ArrayList();
        integrationCommandList.add((ConsoleOption<?>)DESTINATION_ID_CONSOLE_OPTION);
        integrationCommandList.add((ConsoleOption<?>)DESTINATION_TYPE_CONSOLE_OPTION);
        return integrationCommandList;
    }

    public boolean isIntegrationActive(TestSuiteEntity testSuite) {
        if (testSuite == null) {
            return false;
        }
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (!QTestIntegrationUtil.isIntegrationEnable(projectEntity) || !QTestSettingStore.isAutoSubmitResultActive(projectEntity.getFolderLocation())) {
            return false;
        }
        return QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity) != null && QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuite) != null;
    }

    public boolean isAllowedGenerateReport(TestSuiteEntity testSuite) {
        if (testSuite == null) {
            return false;
        }
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (!QTestIntegrationUtil.isIntegrationEnable(projectEntity)) {
            return false;
        }
        return QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity) != null && QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuite) != null;
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (StringUtils.isBlank((String)argumentValue)) {
            return;
        }
        if (consoleOption == DESTINATION_ID_CONSOLE_OPTION) {
            this.destId = Long.parseLong(argumentValue.trim());
        } else if (consoleOption == DESTINATION_TYPE_CONSOLE_OPTION) {
            this.destType = argumentValue.trim();
        }
    }

    public boolean isIntegrationEnabled() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        return QTestIntegrationUtil.isIntegrationEnable(projectEntity);
    }
}

