/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.handler;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.folder.handlers.deletion.IDeleteFolderHandler;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.composer.testsuite.handlers.DeleteTestSuiteHandler;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.file.IFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteTestSuiteFolderHandler
extends DeleteTestSuiteHandler
implements IDeleteFolderHandler {
    public FolderEntity.FolderType getFolderType() {
        return FolderEntity.FolderType.TESTSUITE;
    }

    public boolean execute(FolderTreeEntity folderTreeEntity, IProgressMonitor monitor) {
        try {
            if (folderTreeEntity == null || folderTreeEntity.getObject() == null) {
                return false;
            }
            FolderEntity folderEntity = folderTreeEntity.getObject();
            String folderId = folderEntity.getIdForDisplay();
            List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(folderEntity);
            monitor.beginTask(MessageFormat.format(ComposerTestsuiteCollectionMessageConstants.HAND_JOB_DELETING_FOLDER, folderId), descendantEntities.size() + 1);
            ArrayList<TestSuiteEntity> undeleteTestSuites = new ArrayList<TestSuiteEntity>();
            for (Object entity : descendantEntities) {
                if (monitor.isCanceled()) {
                    return false;
                }
                if (entity instanceof TestSuiteEntity && !this.deleteTestSuiteTask((TestSuiteEntity)entity, monitor)) {
                    undeleteTestSuites.add((TestSuiteEntity)entity);
                    continue;
                }
                if (entity instanceof TestSuiteCollectionEntity) {
                    this.deleteTestSuiteCollectionTask((TestSuiteCollectionEntity)entity, monitor);
                }
                if (!(entity instanceof FolderEntity)) continue;
                this.deleteFolder((FolderEntity)entity, undeleteTestSuites, monitor);
            }
            this.deleteFolder(folderEntity, undeleteTestSuites, monitor);
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)folderTreeEntity.getParent());
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private boolean deleteTestSuiteTask(final TestSuiteEntity testSuite, IProgressMonitor monitor) {
        return this.deleteEntityTask((IFileEntity)testSuite, monitor, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DeleteTestSuiteFolderHandler.this.performDeleteTestSuite(testSuite);
                return null;
            }
        });
    }

    private boolean deleteTestSuiteCollectionTask(final TestSuiteCollectionEntity testSuiteCollection, IProgressMonitor monitor) {
        return this.deleteEntityTask((IFileEntity)testSuiteCollection, monitor, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                EntityPartUtil.closePart((IEntity)testSuiteCollection);
                TestSuiteCollectionController.getInstance().deleteTestSuiteCollection(testSuiteCollection);
                return null;
            }
        });
    }

    private boolean deleteEntityTask(IFileEntity fileEntity, IProgressMonitor monitor, Callable<Object> callable) {
        String testSuiteId = fileEntity.getIdForDisplay();
        monitor.subTask(MessageFormat.format(ComposerTestsuiteCollectionMessageConstants.HAND_JOB_DELETING_ENTITY, testSuiteId));
        try {
            callable.call();
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.worked(1);
        }
    }
}

